/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Style;

public class FlowLayout
extends Layout {
    private boolean fillRows;
    private int orientation = 1;
    private int valign = 0;
    private boolean vAlignByRow;
    private Dimension dim = new Dimension(0, 0);

    public FlowLayout() {
    }

    public FlowLayout(int orientation) {
        this.orientation = orientation;
    }

    public FlowLayout(int orientation, int valign) {
        this.orientation = orientation;
        this.valign = valign;
    }

    public FlowLayout(int orientation, int valign, boolean vAlignByRow) {
        this.orientation = orientation;
        this.valign = valign;
        this.vAlignByRow = vAlignByRow;
    }

    public void layoutContainer(Container parent) {
        block12: {
            Component cmp;
            int dy;
            int numOfcomponents;
            int rowH;
            int y;
            Style s;
            block13: {
                s = parent.getStyle();
                boolean rtl = parent.isRTL();
                int containerPaddingLeft = s.getPaddingLeftNoRTL();
                int containerPaddingRight = s.getPaddingRightNoRTL();
                int sideGap = parent.getSideGap();
                int x = containerPaddingLeft;
                int layoutWidth = parent.getLayoutWidth();
                int width = layoutWidth - sideGap - containerPaddingRight - containerPaddingLeft;
                if (rtl) {
                    x += sideGap;
                }
                int initX = x;
                y = s.getPaddingTop();
                rowH = 0;
                int start = 0;
                int rowBaseline = 0;
                int maxComponentWidth = width;
                numOfcomponents = parent.getComponentCount();
                for (int i = 0; i < numOfcomponents; ++i) {
                    int cmpBaseline;
                    int cmpPrefH;
                    Component cmp2 = parent.getComponentAt(i);
                    Style style = cmp2.getStyle();
                    int marginX = style.getHorizontalMargins();
                    cmp2.setWidth(Math.min(maxComponentWidth - marginX, cmp2.getPreferredW()));
                    cmp2.setHeight(cmp2.getPreferredH());
                    if (x == initX || x + cmp2.getPreferredW() <= width + containerPaddingLeft) {
                        x += cmp2.getStyle().getMarginLeftNoRTL();
                        if (rtl) {
                            cmp2.setX(layoutWidth - x - cmp2.getWidth());
                        } else {
                            cmp2.setX(x);
                        }
                        cmp2.setY(y + cmp2.getStyle().getMarginTop());
                        x += cmp2.getWidth() + cmp2.getStyle().getMarginRightNoRTL();
                        rowH = Math.max(rowH, cmp2.getHeight() + cmp2.getStyle().getMarginTop() + cmp2.getStyle().getMarginBottom());
                        if (this.valign != 5) continue;
                        cmpPrefH = cmp2.getPreferredH();
                        cmpBaseline = cmp2.getBaseline(cmp2.getPreferredW(), cmpPrefH);
                        rowBaseline = Math.max(rowBaseline, cmpBaseline + cmp2.getStyle().getMarginTop());
                        rowH = Math.max(rowH, rowBaseline + cmp2.getStyle().getMarginBottom() + cmpPrefH - cmpBaseline);
                        continue;
                    }
                    this.moveComponents(parent, 0, y, width - (x - initX), rowH, start, i, rowBaseline);
                    if (this.fillRows) {
                        this.fillRow(parent, width, start, i);
                    }
                    x = initX;
                    y += rowH;
                    rowBaseline = 0;
                    if (rtl) {
                        cmp2.setX(layoutWidth - x - cmp2.getWidth());
                    } else {
                        cmp2.setX(x);
                    }
                    cmp2.setY(y + cmp2.getStyle().getMarginTop());
                    rowH = cmp2.getPreferredH() + cmp2.getStyle().getMarginTop() + cmp2.getStyle().getMarginBottom();
                    if (this.valign == 5) {
                        cmpPrefH = cmp2.getPreferredH();
                        cmpBaseline = cmp2.getBaseline(cmp2.getPreferredW(), cmpPrefH);
                        rowBaseline = Math.max(rowBaseline, cmpBaseline + cmp2.getStyle().getMarginTop());
                        rowH = Math.max(rowH, rowBaseline + cmp2.getStyle().getMarginBottom() + cmpPrefH - cmpBaseline);
                    }
                    x += cmp2.getPreferredW() + cmp2.getStyle().getMarginRightNoRTL();
                    start = i;
                }
                this.moveComponents(parent, 0, y, width - (x - initX), rowH, start, numOfcomponents, rowBaseline);
                if (this.fillRows) {
                    this.fillRow(parent, width, start, numOfcomponents);
                }
                if (this.vAlignByRow) break block12;
                if (this.valign != 2) break block13;
                dy = parent.getLayoutHeight() - s.getPaddingBottom() - (y + rowH);
                for (int i = 0; i < numOfcomponents; ++i) {
                    cmp = parent.getComponentAt(i);
                    cmp.setY(cmp.getY() + dy);
                }
                break block12;
            }
            if (this.valign != 4) break block12;
            dy = (parent.getLayoutHeight() - s.getPaddingBottom() - (y + rowH)) / 2;
            for (int i = 0; i < numOfcomponents; ++i) {
                cmp = parent.getComponentAt(i);
                cmp.setY(cmp.getY() + dy);
            }
        }
    }

    protected void fillRow(Container target, int width, int start, int end) {
        int available = width;
        for (int iter = start; iter < end; ++iter) {
            Component c = target.getComponentAt(iter);
            available -= c.getWidth() + c.getStyle().getMarginRightNoRTL() + c.getStyle().getMarginLeftNoRTL();
        }
        if (available > 0 && end - start > 0) {
            int perComponent = available / (end - start);
            int lastComponent = perComponent + available % (end - start);
            if (perComponent > 0) {
                int addOffset = 0;
                boolean rtl = target.isRTL();
                for (int iter = start; iter < end - 1; ++iter) {
                    Component c = target.getComponentAt(iter);
                    c.setWidth(c.getWidth() + perComponent);
                    if (rtl) {
                        c.setX(c.getX() - (addOffset += perComponent));
                        continue;
                    }
                    c.setX(c.getX() + addOffset);
                    addOffset += perComponent;
                }
                Component c = target.getComponentAt(end - 1);
                if (rtl) {
                    c.setX(c.getX() - (addOffset += lastComponent));
                } else {
                    c.setX(c.getX() + addOffset);
                }
                c.setWidth(c.getWidth() + lastComponent);
            } else {
                Component c = target.getComponentAt(end - 1);
                c.setWidth(c.getWidth() + lastComponent);
            }
        }
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, int baseline) {
        switch (this.orientation) {
            case 4: {
                if (target.isRTL()) {
                    x = -width / 2;
                    break;
                }
                x = width / 2;
                break;
            }
            case 3: {
                x = target.isRTL() ? -width : width;
            }
        }
        Style parentStyle = target.getStyle();
        int parentPadding = parentStyle.getHorizontalPadding();
        block9: for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponentAt(i);
            Style style = m.getStyle();
            int marginX = style.getMarginLeftNoRTL() + style.getMarginRightNoRTL();
            if (m.getWidth() + marginX < target.getWidth() - parentPadding) {
                m.setX(m.getX() + x);
            }
            int marginTop = style.getMarginTop();
            switch (this.valign) {
                case 2: {
                    if (!this.vAlignByRow) continue block9;
                    m.setY(y + Math.max(marginTop, height - m.getHeight() - style.getMarginBottom()));
                    continue block9;
                }
                case 4: {
                    if (!this.vAlignByRow) continue block9;
                    m.setY(y + Math.max(marginTop, (height - m.getOuterHeight()) / 2 + style.getMarginTop()));
                    continue block9;
                }
                case 5: {
                    m.setY(y + Math.max(marginTop, baseline - m.getBaseline(m.getWidth(), m.getHeight())));
                    continue block9;
                }
                default: {
                    m.setY(y + marginTop);
                }
            }
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int parentWidth = parent.getWidth();
        if (parentWidth == 0 || parentWidth > Display.getInstance().getDisplayWidth()) {
            parent.invalidate();
        }
        int width = 0;
        int height = 0;
        int w = 0;
        int numOfcomponents = parent.getComponentCount();
        Style parentStyle = parent.getStyle();
        int parentPadding = parentStyle.getHorizontalPadding();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            height = Math.max(height, cmp.getPreferredH() + cmp.getStyle().getMarginTop() + cmp.getStyle().getMarginBottom());
            int prefW = cmp.getPreferredW() + cmp.getStyle().getHorizontalMargins();
            if (parentWidth <= parentPadding || (w += prefW) <= parentWidth - parentPadding || i <= 0) continue;
            height += cmp.getPreferredH() + cmp.getStyle().getMarginTop() + cmp.getStyle().getMarginBottom();
            width = Math.max(w, width);
            w = prefW;
        }
        width = Math.max(w, width);
        this.dim.setWidth(width + parent.getStyle().getPaddingLeftNoRTL() + parent.getStyle().getPaddingRightNoRTL());
        this.dim.setHeight(height + parent.getStyle().getPaddingTop() + parent.getStyle().getPaddingBottom());
        return this.dim;
    }

    public String toString() {
        return "FlowLayout";
    }

    public boolean isFillRows() {
        return this.fillRows;
    }

    public void setFillRows(boolean fillRows) {
        this.fillRows = fillRows;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public void setValignByRow(boolean internal) {
        this.vAlignByRow = internal;
    }

    public boolean isValignByRow() {
        return this.vAlignByRow;
    }

    public int getAlign() {
        return this.orientation;
    }

    public void setAlign(int orientation) {
        this.orientation = orientation;
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((FlowLayout)o).orientation == this.orientation && ((FlowLayout)o).valign == this.valign && ((FlowLayout)o).fillRows == this.fillRows;
    }

    public static Container encloseIn(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(), cmps);
    }

    public static Container encloseCenter(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(4), cmps);
    }

    public static Container encloseRight(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(3), cmps);
    }

    public static Container encloseMiddle(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(1, 4), cmps);
    }

    public static Container encloseMiddleByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(1, 4, true), cmps);
    }

    public static Container encloseCenterMiddle(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(4, 4), cmps);
    }

    public static Container encloseCenterMiddleByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(4, 4, true), cmps);
    }

    public static Container encloseRightMiddle(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(3, 4), cmps);
    }

    public static Container encloseRightMiddleByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(3, 4, true), cmps);
    }

    public static Container encloseLeftMiddle(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(1, 4), cmps);
    }

    public static Container encloseLeftMiddleByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(1, 4, true), cmps);
    }

    public static Container encloseBottom(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(1, 2), cmps);
    }

    public static Container encloseCenterBottom(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(4, 2), cmps);
    }

    public static Container encloseRightBottom(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(3, 2), cmps);
    }

    public static Container encloseBottomByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(1, 2, true), cmps);
    }

    public static Container encloseCenterBottomByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(4, 2, true), cmps);
    }

    public static Container encloseRightBottomByRow(Component ... cmps) {
        return Container.encloseIn((Layout)new FlowLayout(3, 2, true), cmps);
    }
}

