/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.components.InfiniteProgress;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.Slider;
import com.codename1.ui.TextArea;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.util.FailureCallback;
import com.codename1.util.SuccessCallback;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToastBar {
    private static int defaultMessageTimeout = 4000;
    private int position = 2;
    private String defaultUIID = "ToastBar";
    private String defaultMessageUIID = "ToastBarMessage";
    private static ToastBar instance;
    private boolean useFormLayeredPane;
    private final ArrayList<Status> statuses = new ArrayList();
    private boolean updatingStatus;
    private boolean pendingUpdateStatus;

    public static int getDefaultMessageTimeout() {
        return defaultMessageTimeout;
    }

    public static void setDefaultMessageTimeout(int aDefaultMessageTimeout) {
        defaultMessageTimeout = aDefaultMessageTimeout;
    }

    public static ToastBar getInstance() {
        if (instance == null) {
            instance = new ToastBar();
        }
        return instance;
    }

    private ToastBar() {
    }

    public String getDefaultUIID() {
        return this.defaultUIID;
    }

    public void setDefaultUIID(String defaultUIID) {
        this.defaultUIID = defaultUIID;
    }

    public String getDefaultMessageUIID() {
        return this.defaultMessageUIID;
    }

    public ToastBar useFormLayeredPane(boolean useFormLayeredPane) {
        if (useFormLayeredPane != this.useFormLayeredPane) {
            ToastBarComponent c = this.getToastBarComponent(false);
            if (c != null) {
                c.remove();
                this.getLayeredPane().remove();
            }
            this.useFormLayeredPane = useFormLayeredPane;
        }
        return this;
    }

    public void setDefaultMessageUIID(String defaultMessageUIID) {
        this.defaultMessageUIID = defaultMessageUIID;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStatus() {
        block42: {
            block40: {
                final ToastBarComponent c = this.getToastBarComponent();
                this.moveLayerToFront();
                if (c == null) return;
                try {
                    Status s;
                    if (this.updatingStatus) {
                        this.pendingUpdateStatus = true;
                        Object var9_2 = null;
                        this.updatingStatus = false;
                        if (!this.pendingUpdateStatus) return;
                        this.pendingUpdateStatus = false;
                        Display.getInstance().callSerially(new Runnable(){

                            public void run() {
                                ToastBar.this.updateStatus();
                            }
                        });
                        return;
                    }
                    this.updatingStatus = true;
                    if (c.currentlyShowing != null && !this.statuses.contains(c.currentlyShowing)) {
                        c.currentlyShowing = null;
                    }
                    if (c.currentlyShowing == null || this.statuses.isEmpty()) {
                        if (this.statuses.isEmpty()) {
                            this.setVisible(false);
                            break block40;
                        }
                        c.currentlyShowing = this.statuses.get(this.statuses.size() - 1);
                    }
                    Label l = new Label((s = c.currentlyShowing).getMessage() != null ? s.getMessage() : "", this.defaultMessageUIID);
                    c.leadButton.getListeners().clear();
                    c.leadButton.addActionListener(s.getListener());
                    c.leadButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            if (c.currentlyShowing != null && !c.currentlyShowing.showProgressIndicator) {
                                c.currentlyShowing.clear();
                            }
                            ToastBar.this.setVisible(false);
                        }
                    });
                    c.progressLabel.setVisible(s.isShowProgressIndicator());
                    if (c.progressLabel.isVisible()) {
                        Image anim;
                        if (!c.contains(c.progressLabel)) {
                            c.addComponent("East", (Component)c.progressLabel);
                        }
                        if ((anim = c.progressLabel.getAnimation()) != null && anim.getWidth() > 0) {
                            c.progressLabel.setWidth(anim.getWidth());
                        }
                        if (anim != null && anim.getHeight() > 0) {
                            c.progressLabel.setHeight(anim.getHeight());
                        }
                    } else if (c.contains(c.progressLabel)) {
                        c.removeComponent(c.progressLabel);
                    }
                    c.progressBar.setVisible(s.getProgress() >= -1);
                    if (s.getProgress() >= -1) {
                        if (!c.contains(c.progressBar)) {
                            c.addComponent("South", (Component)c.progressBar);
                        }
                        if (s.getProgress() < 0) {
                            c.progressBar.setInfinite(true);
                        } else {
                            c.progressBar.setInfinite(false);
                            c.progressBar.setProgress(s.getProgress());
                        }
                    } else {
                        c.removeComponent(c.progressBar);
                    }
                    c.icon.setVisible(s.getIcon() != null);
                    if (s.getIcon() != null && c.icon.getIcon() != s.getIcon()) {
                        c.icon.setIcon(s.getIcon());
                    }
                    if (s.getIcon() == null && c.contains(c.icon)) {
                        c.removeComponent(c.icon);
                    } else if (s.getIcon() != null && !c.contains(c.icon)) {
                        c.addComponent("West", (Component)c.icon);
                    }
                    String oldText = c.label.getText();
                    if (!oldText.equals(l.getText())) {
                        if (s.getUiid() != null) {
                            c.setUIID(s.getUiid());
                        } else if (this.defaultUIID != null) {
                            c.setUIID(this.defaultUIID);
                        }
                        if (c.isVisible()) {
                            TextArea newLabel = new TextArea();
                            newLabel.setUIID(this.defaultMessageUIID);
                            newLabel.setFocusable(false);
                            newLabel.setEditable(false);
                            newLabel.setVerticalAlignment(4);
                            if (s.getMessageUIID() != null) {
                                newLabel.setUIID(s.getMessageUIID());
                            } else if (this.defaultMessageUIID != null) {
                                newLabel.setUIID(this.defaultMessageUIID);
                            } else {
                                newLabel.setUIID(c.label.getUIID());
                            }
                            if (s.getUiid() != null) {
                                c.setUIID(s.getUiid());
                            } else if (this.defaultUIID != null) {
                                c.setUIID(this.defaultUIID);
                            }
                            newLabel.setWidth(c.label.getWidth());
                            newLabel.setText(l.getText());
                            Dimension oldTextAreaSize = UIManager.getInstance().getLookAndFeel().getTextAreaSize(c.label, true);
                            Dimension newTexAreaSize = UIManager.getInstance().getLookAndFeel().getTextAreaSize(newLabel, true);
                            if (c.label.getParent() == null) break block42;
                            c.label.getParent().replaceAndWait(c.label, newLabel, CommonTransitions.createCover(1, true, 300));
                            c.label = newLabel;
                            if (oldTextAreaSize.getHeight() != newTexAreaSize.getHeight()) {
                                c.label.setPreferredH(newTexAreaSize.getHeight());
                                c.getParent().animateHierarchyAndWait(300);
                            }
                            break block42;
                        }
                        if (s.getMessageUIID() != null) {
                            c.label.setUIID(s.getMessageUIID());
                        } else if (this.defaultMessageUIID != null) {
                            c.label.setUIID(this.defaultMessageUIID);
                        }
                        if (s.getUiid() != null) {
                            c.setUIID(s.getUiid());
                        } else if (this.defaultUIID != null) {
                            c.setUIID(this.defaultUIID);
                        }
                        c.label.setText(l.getText());
                        c.label.setPreferredW(c.getWidth());
                        c.revalidate();
                        break block42;
                    }
                    c.revalidate();
                    break block42;
                }
                catch (Throwable throwable) {
                    Object var9_5 = null;
                    this.updatingStatus = false;
                    if (!this.pendingUpdateStatus) throw throwable;
                    this.pendingUpdateStatus = false;
                    Display.getInstance().callSerially(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            Object var9_3 = null;
            this.updatingStatus = false;
            if (!this.pendingUpdateStatus) return;
            this.pendingUpdateStatus = false;
            Display.getInstance().callSerially(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        Object var9_4 = null;
        this.updatingStatus = false;
        if (!this.pendingUpdateStatus) return;
        this.pendingUpdateStatus = false;
        Display.getInstance().callSerially(new /* invalid duplicate definition of identical inner class */);
    }

    public Status createStatus() {
        Status s = new Status();
        this.statuses.add(s);
        return s;
    }

    private void removeStatus(Status status) {
        if (status.timer != null) {
            status.timer.cancel();
            status.timer = null;
        }
        this.statuses.remove(status);
        this.updateStatus();
    }

    private Container getLayeredPane() {
        Form f = Display.getInstance().getCurrent();
        if (f == null) {
            throw new IllegalStateException("Cannot get layered pane when form is null");
        }
        if (this.useFormLayeredPane) {
            return f.getFormLayeredPane(this.getClass(), true);
        }
        return f.getLayeredPane(this.getClass(), true);
    }

    private void moveLayerToFront() {
        Form f = Display.getInstance().getCurrent();
        if (f == null) {
            return;
        }
        final Container layered = this.getLayeredPane();
        final Container parent = layered.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getComponentIndex(layered) != parent.getComponentCount() - 1) {
            f.getAnimationManager().flushAnimation(new Runnable(){

                public void run() {
                    parent.removeComponent(layered);
                    parent.addComponent(layered);
                    parent.revalidate();
                }
            });
        }
    }

    private ToastBarComponent getToastBarComponent() {
        return this.getToastBarComponent(true);
    }

    private ToastBarComponent getToastBarComponent(boolean create) {
        Form f = Display.getInstance().getCurrent();
        if (f != null && !(f instanceof Dialog)) {
            ToastBarComponent c = (ToastBarComponent)f.getClientProperty("ToastBarComponent");
            if (c == null && !create) {
                return null;
            }
            if (c == null || c.getParent() == null) {
                c = new ToastBarComponent();
                c.hidden = true;
                f.putClientProperty("ToastBarComponent", c);
                Container layered = this.getLayeredPane();
                layered.setLayout(new BorderLayout());
                layered.addComponent(this.position == 0 ? "North" : "South", (Component)c);
                this.updateStatus();
            }
            if (this.position == 2 && f.getInvisibleAreaUnderVKB() > 0) {
                Style s = c.getAllStyles();
                s.setMarginUnit(0);
                s.setMarginBottom(f.getInvisibleAreaUnderVKB());
            }
            return c;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        ToastBarComponent c = this.getToastBarComponent();
        if (c == null || c.isVisible() == visible) {
            return;
        }
        if (visible) {
            c.hidden = true;
            c.setVisible(false);
            c.setHeight(0);
            c.setShouldCalcPreferredSize(true);
            Form f = c.getComponentForm();
            if (f != null) {
                f.revalidate();
            } else {
                c.getParent().revalidate();
            }
            c.hidden = false;
            c.label.setPreferredH(UIManager.getInstance().getLookAndFeel().getTextAreaSize(c.label, true).getHeight());
            c.setShouldCalcPreferredSize(true);
            ComponentSelector.$(c).slideUpAndWait(2);
            ComponentSelector.$(c).slideDownAndWait(800);
            c.setVisible(true);
            this.updateStatus();
        } else {
            Form f = c.getComponentForm();
            if (Display.getInstance().getCurrent() == f && !f.getMenuBar().isMenuShowing()) {
                if (this.position == 2) {
                    c.setY(c.getY() + c.getHeight());
                }
                ComponentSelector.$(c).slideUpAndWait(500);
            } else {
                c.getParent().revalidate();
            }
            c.hidden = true;
            c.setVisible(false);
        }
    }

    public static void showErrorMessage(String msg) {
        ToastBar.showErrorMessage(msg, defaultMessageTimeout);
    }

    public static Status showMessage(String msg, char icon, int timeout, ActionListener listener) {
        Status s = ToastBar.getInstance().createStatus();
        Style stl = UIManager.getInstance().getComponentStyle(s.getMessageUIID());
        s.setIcon(FontImage.createMaterial(icon, stl, 4.0f));
        s.setMessage(msg);
        if (listener != null) {
            s.setListener(listener);
        }
        s.setExpires(timeout);
        s.show();
        return s;
    }

    public static Status showMessage(String msg, char icon, int timeout) {
        return ToastBar.showMessage(msg, icon, timeout, null);
    }

    public static Status showMessage(String msg, char icon, ActionListener listener) {
        return ToastBar.showMessage(msg, icon, defaultMessageTimeout, listener);
    }

    public static Status showMessage(String msg, char icon) {
        return ToastBar.showMessage(msg, icon, defaultMessageTimeout);
    }

    public static Status showInfoMessage(String msg) {
        return ToastBar.showMessage(msg, '\ue88e', defaultMessageTimeout);
    }

    public static Status showErrorMessage(String msg, int timeout) {
        return ToastBar.showMessage(msg, '\ue000', timeout);
    }

    public static void showConnectionProgress(String message, final ConnectionRequest cr, final SuccessCallback<NetworkEvent> onSuccess, final FailureCallback<NetworkEvent> onError) {
        final Status s = ToastBar.getInstance().createStatus();
        s.setProgress(-1);
        s.setMessage(message);
        s.show();
        final ActionListener[] progListener = new ActionListener[1];
        final ActionListener<NetworkEvent> errorListener = new ActionListener<NetworkEvent>(){

            @Override
            public void actionPerformed(NetworkEvent evt) {
                s.clear();
                NetworkManager.getInstance().removeErrorListener(this);
                if (progListener[0] != null) {
                    NetworkManager.getInstance().removeProgressListener(progListener[0]);
                }
                if (onError != null) {
                    onError.onError(cr, evt.getError(), evt.getResponseCode(), evt.getMessage());
                }
            }
        };
        NetworkManager.getInstance().addErrorListener(errorListener);
        progListener[0] = new ActionListener<NetworkEvent>(){
            private int soFar;

            @Override
            public void actionPerformed(NetworkEvent evt) {
                switch (evt.getProgressType()) {
                    case 1: {
                        s.setProgress(-1);
                        break;
                    }
                    case 2: 
                    case 3: {
                        int currentLength = cr.getContentLength();
                        if (currentLength > 0) {
                            int sentReceived = evt.getSentReceived();
                            float prog = (float)sentReceived / (float)currentLength * 100.0f;
                            s.setProgress((int)prog);
                            break;
                        }
                        s.setProgress(-1);
                    }
                }
            }
        };
        cr.addResponseListener(new ActionListener<NetworkEvent>(){

            @Override
            public void actionPerformed(NetworkEvent evt) {
                NetworkManager.getInstance().removeErrorListener(errorListener);
                NetworkManager.getInstance().removeProgressListener(progListener[0]);
                s.clear();
                int rc = cr.getResponseCode();
                if (onSuccess != null && (rc == 200 || rc == 201 || rc == 202)) {
                    onSuccess.onSucess(evt);
                }
            }
        });
        NetworkManager.getInstance().addProgressListener(progListener[0]);
    }

    private class ToastBarComponent
    extends Container {
        private TextArea label;
        private InfiniteProgress progressLabel;
        private Slider progressBar;
        private Label icon;
        private Status currentlyShowing;
        boolean hidden = true;
        Button leadButton = new Button();

        public ToastBarComponent() {
            this.getAllStyles().setBgColor(0);
            this.getAllStyles().setBackgroundType((byte)0);
            this.getAllStyles().setBgTransparency(128);
            this.setVisible(false);
            this.label = new TextArea();
            this.label.setUIID(ToastBar.this.defaultMessageUIID);
            this.label.setEditable(false);
            this.label.setFocusable(false);
            this.label.setVerticalAlignment(4);
            this.progressLabel = new InfiniteProgress();
            this.progressLabel.setAngleIncrease(4);
            this.progressLabel.setVisible(false);
            this.icon = new Label();
            this.icon.setVisible(false);
            this.progressBar = new Slider();
            this.progressBar.setVisible(false);
            this.leadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (ToastBarComponent.this.currentlyShowing != null && !ToastBarComponent.this.currentlyShowing.showProgressIndicator) {
                        ToastBarComponent.this.currentlyShowing.clear();
                    }
                    ToastBar.this.setVisible(false);
                }
            });
            this.leadButton.setVisible(false);
            this.setLeadComponent(this.leadButton);
            this.setLayout(new BorderLayout());
            this.addComponent("West", (Component)this.icon);
            this.addComponent("Center", (Component)this.label);
            this.addComponent("South", (Component)this.progressBar);
            this.addComponent("East", (Component)this.progressLabel);
            this.progressBar.setVisible(false);
        }

        protected Dimension calcPreferredSize() {
            if (this.hidden) {
                return new Dimension(Display.getInstance().getDisplayWidth(), 0);
            }
            return super.calcPreferredSize();
        }
    }

    public class Status {
        private String messageUIID;
        private String uiid;
        private final long startTime;
        private Timer timer;
        private Timer showTimer;
        private String message;
        private ActionListener listener;
        private int progress;
        private Image icon;
        private boolean showProgressIndicator;

        private Status() {
            this.messageUIID = ToastBar.this.defaultMessageUIID;
            this.uiid = ToastBar.this.defaultUIID;
            this.progress = -2;
            this.startTime = System.currentTimeMillis();
        }

        public void setExpires(int millis) {
            if (millis < 0 && this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            } else if (millis > 0) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    public void run() {
                        Display.getInstance().callSerially(new Runnable(){

                            public void run() {
                                Status.this.timer = null;
                                Status.this.clear();
                            }
                        });
                    }
                }, millis);
            }
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setListener(ActionListener listener) {
            this.listener = listener;
        }

        public void setProgress(int progress) {
            this.progress = progress;
            ToastBar.this.updateStatus();
        }

        public void show() {
            ToastBarComponent c;
            if (this.showTimer != null) {
                this.showTimer.cancel();
                this.showTimer = null;
            }
            if ((c = ToastBar.this.getToastBarComponent()) != null) {
                c.currentlyShowing = this;
                ToastBar.this.updateStatus();
                ToastBar.this.setVisible(true);
            }
        }

        public void showDelayed(int millis) {
            this.showTimer = new Timer();
            this.showTimer.schedule(new TimerTask(){

                public void run() {
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            if (Status.this.showTimer != null) {
                                Status.this.showTimer = null;
                                Status.this.show();
                            }
                        }
                    });
                }
            }, millis);
        }

        public void clear() {
            if (this.showTimer != null) {
                this.showTimer.cancel();
                this.showTimer = null;
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            ToastBar.this.removeStatus(this);
        }

        public String getMessage() {
            return this.message;
        }

        public ActionListener getListener() {
            return this.listener;
        }

        public int getProgress() {
            return this.progress;
        }

        public Image getIcon() {
            return this.icon;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public boolean isShowProgressIndicator() {
            return this.showProgressIndicator;
        }

        public void setShowProgressIndicator(boolean showProgressIndicator) {
            this.showProgressIndicator = showProgressIndicator;
        }

        public String getMessageUIID() {
            return this.messageUIID;
        }

        public void setMessageUIID(String messageUIID) {
            this.messageUIID = messageUIID;
        }

        public String getUiid() {
            return this.uiid;
        }

        public void setUiid(String uiid) {
            this.uiid = uiid;
        }
    }
}

