/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.animations;

import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.util.Resources;

public final class AnimationObject {
    public static final int MOTION_TYPE_SPLINE = 2;
    public static final int MOTION_TYPE_LINEAR = 1;
    String imageName;
    Resources res;
    Image img;
    Image[] frames;
    Motion motionX;
    Motion motionY;
    Motion orientation;
    Motion width;
    Motion height;
    Motion opacity;
    int frameWidth;
    int frameHeight;
    int frameDelay = -1;
    private boolean framesInitialized = true;
    private int startTime = -1;
    private int endTime = -1;

    private AnimationObject() {
    }

    public AnimationObject copy() {
        AnimationObject o = new AnimationObject();
        o.imageName = this.imageName;
        o.res = this.res;
        o.img = this.img;
        o.frames = this.frames;
        o.motionX = this.motionX;
        o.motionY = this.motionY;
        o.orientation = this.orientation;
        o.width = this.width;
        o.height = this.height;
        o.opacity = this.opacity;
        o.frameWidth = this.frameWidth;
        o.frameHeight = this.frameHeight;
        o.frameDelay = this.frameDelay;
        o.framesInitialized = this.framesInitialized;
        o.startTime = this.startTime;
        o.endTime = this.endTime;
        return o;
    }

    void lock() {
        if (this.img != null) {
            this.img.lock();
        }
    }

    void unlock() {
        if (this.img != null) {
            this.img.unlock();
        }
    }

    public static AnimationObject createAnimationImage(Image img, int x, int y) {
        AnimationObject o = new AnimationObject();
        o.img = img;
        o.motionX = Motion.createLinearMotion(x, x, 1);
        o.motionX.setStartTime(Long.MAX_VALUE);
        o.motionY = Motion.createLinearMotion(y, y, 1);
        o.motionY.setStartTime(Long.MAX_VALUE);
        return o;
    }

    public void defineFrames(int frameWidth, int frameHeight, int frameDelay) {
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.frameDelay = frameDelay;
        this.framesInitialized = false;
    }

    public static AnimationObject createAnimationImage(String imageName, Resources res, int x, int y) {
        AnimationObject o = new AnimationObject();
        o.imageName = imageName;
        o.res = res;
        o.motionX = Motion.createLinearMotion(x, x, 1);
        o.motionX.setStartTime(Long.MAX_VALUE);
        o.motionY = Motion.createLinearMotion(y, y, 1);
        o.motionY.setStartTime(Long.MAX_VALUE);
        return o;
    }

    Image getImage() {
        if (this.img == null && this.res != null) {
            this.img = this.res.getImage(this.imageName);
            if (this.img == null) {
                return null;
            }
            this.res = null;
        }
        if (this.frameDelay > -1) {
            if (!this.framesInitialized) {
                this.frames = new Image[this.img.getWidth() / this.frameWidth * this.img.getHeight() / this.frameHeight];
                int currentX = 0;
                int currentY = 0;
                int flen = this.frames.length;
                for (int iter = 0; iter < flen; ++iter) {
                    this.frames[iter] = this.img.subImage(currentX, currentY, this.frameWidth, this.frameHeight, true);
                    if ((currentX += this.frameWidth) + this.frameWidth <= this.img.getWidth()) continue;
                    currentX = 0;
                    currentY += this.frameHeight;
                }
                if (System.getProperty("microedition.platform") != null) {
                    this.img = null;
                }
            }
            long time = this.motionX.getCurrentMotionTime();
            int frameCount = Math.max(1, this.frames.length);
            int frame = Math.min(Math.max(0, (int)(time / (long)Math.max(1, this.frameDelay) % (long)frameCount)), frameCount - 1);
            return this.frames[frame];
        }
        return this.img;
    }

    private void setTimeNotNull(Motion m, int time) {
        if (m != null) {
            m.setCurrentMotionTime(time);
        }
    }

    void setTime(int time) {
        this.motionX.setCurrentMotionTime(time);
        this.motionY.setCurrentMotionTime(time);
        this.setTimeNotNull(this.orientation, time);
        this.setTimeNotNull(this.width, time);
        this.setTimeNotNull(this.height, time);
        this.setTimeNotNull(this.opacity, time);
    }

    public void defineMotionX(int motionType, int startTime, int duration, int start, int end) {
        this.motionX = this.createMotion(motionType, startTime, duration, start, end);
    }

    public void defineMotionY(int motionType, int startTime, int duration, int start, int end) {
        this.motionY = this.createMotion(motionType, startTime, duration, start, end);
    }

    public void defineOrientation(int motionType, int startTime, int duration, int start, int end) {
        this.orientation = this.createMotion(motionType, startTime, duration, start, end);
    }

    public void defineOpacity(int motionType, int startTime, int duration, int start, int end) {
        this.opacity = this.createMotion(motionType, startTime, duration, start, end);
    }

    public void defineWidth(int motionType, int startTime, int duration, int start, int end) {
        this.width = this.createMotion(motionType, startTime, duration, start, end);
    }

    public void defineHeight(int motionType, int startTime, int duration, int start, int end) {
        this.height = this.createMotion(motionType, startTime, duration, start, end);
    }

    private Motion createMotion(int motionType, int startTime, int duration, int start, int end) {
        Motion m;
        switch (motionType) {
            case 1: {
                m = Motion.createLinearMotion(start, end, startTime + duration);
                break;
            }
            case 2: {
                m = Motion.createSplineMotion(start, end, startTime + duration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Motion type: " + motionType);
            }
        }
        m.setStartTime(startTime);
        return m;
    }

    int getX() {
        return this.motionX.getValue();
    }

    int getY() {
        return this.motionY.getValue();
    }

    int getOrientation() {
        if (this.orientation == null) {
            return 0;
        }
        return this.orientation.getValue();
    }

    int getWidth() {
        if (this.width == null) {
            if (this.getImage() != null) {
                return this.getImage().getWidth();
            }
            return 20;
        }
        return this.width.getValue();
    }

    int getHeight() {
        if (this.height == null) {
            if (this.getImage() != null) {
                return this.getImage().getHeight();
            }
            return 20;
        }
        return this.height.getValue();
    }

    int getOpacity() {
        if (this.opacity == null) {
            return 255;
        }
        return this.opacity.getValue();
    }

    void draw(Graphics g, float scaleX, float scaleY) {
        int r;
        int o = this.getOpacity();
        if (o == 0) {
            return;
        }
        Image i = this.getImage();
        if (i == null) {
            return;
        }
        int scaledImageW = (int)((float)this.getWidth() * scaleX);
        int scaledImageH = (int)((float)this.getHeight() * scaleY);
        if (scaledImageH < 1 || scaledImageW < 1) {
            return;
        }
        i = this.getImage().scaled(scaledImageW, scaledImageH);
        if (o != 255) {
            i = i.modifyAlphaWithTranslucency((byte)o);
        }
        if ((r = this.getOrientation()) != 0) {
            i = i.rotate(r);
        }
        int x = this.getX();
        int y = this.getY();
        x = (int)((float)x * scaleX);
        y = (int)((float)y * scaleY);
        g.drawImage(i, x, y);
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }
}

