/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.components.InteractionDialog;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.l10n.L10NManager;
import com.codename1.l10n.SimpleDateFormat;
import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.VirtualInputDevice;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.RoundRectBorder;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.spinner.CalendarPicker;
import com.codename1.ui.spinner.DateSpinner;
import com.codename1.ui.spinner.DateSpinner3D;
import com.codename1.ui.spinner.DateTimeSpinner;
import com.codename1.ui.spinner.DateTimeSpinner3D;
import com.codename1.ui.spinner.DurationSpinner3D;
import com.codename1.ui.spinner.GenericSpinner;
import com.codename1.ui.spinner.InternalPickerWidget;
import com.codename1.ui.spinner.Spinner3D;
import com.codename1.ui.spinner.TimeSpinner;
import com.codename1.ui.spinner.TimeSpinner3D;
import java.util.Calendar;
import java.util.Date;

public class Picker
extends Button {
    private int type = 1;
    private Object value = new Date();
    private boolean showMeridiem;
    private Object metaData;
    private Object renderingPrototype = "XXXXXXXXXXXXXX";
    private SimpleDateFormat formatter;
    private int preferredPopupWidth;
    private int preferredPopupHeight;
    private int minuteStep = 5;
    private int minHour = -1;
    private int maxHour = -1;
    private Date startDate;
    private Date endDate;
    private VirtualInputDevice currentInput;
    private byte[] tmpContentPaneMarginUnit;
    private float tmpContentPaneBottomMargin;
    private static boolean defaultUseLightweightPopup;
    private static boolean defaultLightweightModeSet;
    private boolean useLightweightPopup;
    private Runnable stopEditingCallback;
    private Label focusedOverlay;
    private boolean suppressPaint;

    public static boolean isDefaultUseLightweightPopup() {
        return defaultUseLightweightPopup;
    }

    public static void setDefaultUseLightweightPopup(boolean aDefaultUseLightweightPopup) {
        defaultLightweightModeSet = true;
        defaultUseLightweightPopup = aDefaultUseLightweightPopup;
    }

    private static boolean isLightweightModeSupportedForType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void setHourRange(int min, int max) {
        if (this.showMeridiem && min >= 0 && min <= 24 && max > min) {
            this.setShowMeridiem(false);
        }
        this.minHour = min;
        this.maxHour = max;
    }

    public int getMinHour() {
        return this.minHour;
    }

    public int getMaxHour() {
        return this.maxHour;
    }

    public void setStartDate(Date start) {
        this.startDate = start;
    }

    public void setEndDate(Date end) {
        this.endDate = end;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setUseLightweightPopup(boolean useLightweightPopup) {
        this.useLightweightPopup = useLightweightPopup;
    }

    public boolean isUseLightweightPopup() {
        return this.useLightweightPopup;
    }

    private boolean ignoreActionEvent(ActionEvent evt) {
        return evt.getX() == -99 && evt.getY() == -99;
    }

    public Picker() {
        this.setUIID("Picker");
        this.setPreferredTabIndex(0);
        if (!defaultLightweightModeSet) {
            defaultLightweightModeSet = true;
            defaultUseLightweightPopup = CN.getPlatformName().equals("ios");
        }
        this.useLightweightPopup = !Display.getInstance().isNativePickerTypeSupported(4) ? true : (defaultUseLightweightPopup = this.getUIManager().isThemeConstant("lightweightPickerBool", defaultUseLightweightPopup));
        this.addActionListener(new ActionListener(){
            private static final int COMMAND_DONE = 1;
            private static final int COMMAND_NEXT = 2;
            private static final int COMMAND_PREV = 3;
            private static final int COMMAND_CANCEL = 4;

            public void actionPerformed(ActionEvent evt) {
                if (Picker.this.ignoreActionEvent(evt)) {
                    return;
                }
                if (Picker.this.isEditing()) {
                    evt.consume();
                    return;
                }
                if ((Picker.this.useLightweightPopup || !Display.getInstance().isNativePickerTypeSupported(Picker.this.type)) && Picker.isLightweightModeSupportedForType(Picker.this.type)) {
                    this.showInteractionDialog();
                    evt.consume();
                    return;
                }
                if (Display.getInstance().isNativePickerTypeSupported(Picker.this.type)) {
                    switch (Picker.this.type) {
                        case 5: 
                        case 6: 
                        case 7: {
                            Picker.this.metaData = "minuteStep=" + Picker.this.minuteStep;
                        }
                    }
                    Picker.this.setEnabled(false);
                    Object val = Display.getInstance().showNativePicker(Picker.this.type, Picker.this, Picker.this.value, Picker.this.metaData);
                    if (val != null) {
                        Picker.this.value = val;
                        Picker.this.updateValue();
                    } else {
                        evt.consume();
                    }
                    Picker.this.setEnabled(true);
                } else {
                    Dialog pickerDlg = new Dialog();
                    pickerDlg.setDisposeWhenPointerOutOfBounds(true);
                    pickerDlg.setLayout(new BorderLayout());
                    Calendar cld = Calendar.getInstance();
                    switch (Picker.this.type) {
                        case 4: {
                            GenericSpinner gs = new GenericSpinner();
                            if (Picker.this.renderingPrototype != null) {
                                gs.setRenderingPrototype((String)Picker.this.renderingPrototype);
                            }
                            String[] strArr = (String[])Picker.this.metaData;
                            gs.setModel(new DefaultListModel<Object>((Object[])strArr));
                            if (Picker.this.value != null) {
                                int slen = strArr.length;
                                for (int iter = 0; iter < slen; ++iter) {
                                    if (!strArr[iter].equals(Picker.this.value)) continue;
                                    gs.getModel().setSelectedIndex(iter);
                                    break;
                                }
                            }
                            if (this.showDialog(pickerDlg, gs)) {
                                Picker.this.value = gs.getValue();
                                break;
                            }
                            evt.consume();
                            break;
                        }
                        case 8: {
                            this.showInteractionDialog();
                            evt.consume();
                            break;
                        }
                        case 1: {
                            DateSpinner ds = new DateSpinner();
                            if (Picker.this.value == null) {
                                cld.setTime(new Date());
                            } else {
                                cld.setTime((Date)Picker.this.value);
                            }
                            ds.setStartYear(UIManager.getInstance().getThemeConstant("pickerStartingDate", 1900));
                            ds.setCurrentDay(cld.get(5));
                            ds.setCurrentMonth(cld.get(2) + 1);
                            ds.setCurrentYear(cld.get(1));
                            if (this.showDialog(pickerDlg, ds)) {
                                cld.set(5, ds.getCurrentDay());
                                cld.set(2, ds.getCurrentMonth() - 1);
                                cld.set(1, ds.getCurrentYear());
                                Picker.this.value = cld.getTime();
                                break;
                            }
                            evt.consume();
                            break;
                        }
                        case 2: {
                            int v = (Integer)Picker.this.value;
                            int hour = v / 60;
                            int minute = v % 60;
                            TimeSpinner ts = new TimeSpinner();
                            ts.setShowMeridiem(Picker.this.isShowMeridiem());
                            if (Picker.this.showMeridiem && hour > 12) {
                                ts.setCurrentMeridiem(true);
                                ts.setCurrentHour(hour - 12);
                            } else {
                                ts.setCurrentHour(hour);
                            }
                            ts.setCurrentMinute(minute);
                            if (this.showDialog(pickerDlg, ts)) {
                                if (Picker.this.isShowMeridiem()) {
                                    int offset = 0;
                                    if (ts.getCurrentHour() == 12) {
                                        if (!ts.isCurrentMeridiem()) {
                                            offset = 12;
                                        }
                                    } else if (ts.isCurrentMeridiem()) {
                                        offset = 12;
                                    }
                                    hour = ts.getCurrentHour() + offset;
                                } else {
                                    hour = ts.getCurrentHour();
                                }
                                Picker.this.value = new Integer(hour * 60 + ts.getCurrentMinute());
                                break;
                            }
                            evt.consume();
                            break;
                        }
                        case 3: {
                            DateTimeSpinner dts = new DateTimeSpinner();
                            cld.setTime((Date)Picker.this.value);
                            dts.setCurrentDate((Date)Picker.this.value);
                            dts.setShowMeridiem(Picker.this.isShowMeridiem());
                            if (Picker.this.isShowMeridiem() && dts.isCurrentMeridiem()) {
                                dts.setCurrentHour(cld.get(10));
                            } else {
                                dts.setCurrentHour(cld.get(11));
                            }
                            dts.setCurrentMinute(cld.get(12));
                            if (this.showDialog(pickerDlg, dts)) {
                                cld.setTime(dts.getCurrentDate());
                                if (Picker.this.isShowMeridiem() && dts.isCurrentMeridiem()) {
                                    cld.set(9, 1);
                                    cld.set(10, dts.getCurrentHour());
                                } else {
                                    cld.set(11, dts.getCurrentHour());
                                }
                                cld.set(12, dts.getCurrentMinute());
                                Picker.this.value = cld.getTime();
                                break;
                            }
                            evt.consume();
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            long v = (Long)Picker.this.value;
                            int hour = (int)(v / 1000L / 60L / 60L);
                            int minute = (int)(v / 1000L / 60L % 60L);
                            TimeSpinner ts = new TimeSpinner();
                            ts.setDurationMode(true);
                            if (Picker.this.type == 6) {
                                ts.setMinutesVisible(false);
                            } else if (Picker.this.type == 7) {
                                ts.setHoursVisible(false);
                            }
                            ts.setCurrentHour(hour);
                            ts.setCurrentMinute(minute);
                            ts.setMinuteStep(Picker.this.minuteStep);
                            if (this.showDialog(pickerDlg, ts)) {
                                Picker.this.value = new Long((long)(ts.getCurrentHour() * 60 * 60) * 1000L + (long)(ts.getCurrentMinute() * 60) * 1000L);
                                break;
                            }
                            evt.consume();
                            break;
                        }
                    }
                    Picker.this.updateValue();
                }
            }

            private Spinner3D createStringPicker3D() {
                Spinner3D out = new Spinner3D(new DefaultListModel<String>((String[])Picker.this.metaData));
                if (Picker.this.value != null) {
                    out.setValue(Picker.this.value);
                }
                return out;
            }

            private DateSpinner3D createDatePicker3D() {
                Date defaultValue;
                DateSpinner3D out = new DateSpinner3D();
                Date date = defaultValue = Picker.this.value == null ? new Date() : (Date)Picker.this.value;
                if (Picker.this.startDate != null && Picker.this.endDate != null) {
                    out.setDateRange(Picker.this.startDate, Picker.this.endDate);
                    if (defaultValue.getTime() < Picker.this.startDate.getTime()) {
                        defaultValue = Picker.this.startDate;
                    }
                    if (defaultValue.getTime() > Picker.this.endDate.getTime()) {
                        defaultValue = Picker.this.startDate;
                    }
                }
                if (Picker.this.value != null) {
                    out.setValue(Picker.this.value);
                } else {
                    out.setValue(defaultValue);
                }
                return out;
            }

            private CalendarPicker createCalendarPicker() {
                CalendarPicker out = new CalendarPicker();
                if (Picker.this.value != null) {
                    out.setValue(Picker.this.value);
                } else {
                    out.setValue(new Date());
                }
                return out;
            }

            private TimeSpinner3D createTimePicker3D() {
                TimeSpinner3D out = new TimeSpinner3D();
                out.setMinuteStep(Picker.this.minuteStep);
                out.setShowMeridiem(Picker.this.showMeridiem);
                if (Picker.this.minHour >= 0 && Picker.this.minHour < 24 && Picker.this.maxHour > Picker.this.minHour) {
                    out.setHourRange(Picker.this.minHour, Picker.this.maxHour);
                }
                if (Picker.this.value != null) {
                    out.setValue(Picker.this.value);
                } else {
                    out.setValue(0);
                }
                return out;
            }

            private DateTimeSpinner3D createDateTimePicker3D() {
                DateTimeSpinner3D out = new DateTimeSpinner3D();
                out.setShowMeridiem(Picker.this.showMeridiem);
                if (Picker.this.startDate != null) {
                    out.setStartDate(Picker.this.startDate);
                }
                if (Picker.this.endDate != null) {
                    out.setEndDate(Picker.this.endDate);
                }
                if (Picker.this.minHour >= 0 && Picker.this.minHour < 24 && Picker.this.maxHour > Picker.this.minHour) {
                    out.setHourRange(Picker.this.minHour, Picker.this.maxHour);
                }
                if (Picker.this.value != null) {
                    out.setValue(Picker.this.value);
                } else {
                    out.setValue(new Date());
                }
                return out;
            }

            private DurationSpinner3D createDurationPicker3D() {
                DurationSpinner3D out = new DurationSpinner3D(Picker.this.type == 7 ? 8 : (Picker.this.type == 6 ? 4 : 12));
                if (Picker.this.value != null) {
                    out.setValue(Picker.this.value);
                } else {
                    out.setValue(0);
                }
                return out;
            }

            private void endEditing(int command, InteractionDialog dlg, InternalPickerWidget spinner) {
                Picker.this.currentInput = null;
                Picker.this.restoreContentPane();
                dlg.disposeToTheBottom();
                if (command != 4) {
                    Picker.this.value = spinner.getValue();
                    Picker.this.updateValue();
                    Picker.this.fireActionEvent(-99, -99);
                    Component next = null;
                    Form f = Picker.this.getComponentForm();
                    if (f != null) {
                        if (command == 2) {
                            next = f.getNextComponent(Picker.this);
                        } else if (command == 3) {
                            next = f.getPreviousComponent(Picker.this);
                        }
                    }
                    if (next != null) {
                        next.requestFocus();
                        next.startEditingAsync();
                    }
                }
            }

            private void showInteractionDialog() {
                Container spinner;
                boolean isTablet = Display.getInstance().isTablet();
                switch (Picker.this.type) {
                    case 4: {
                        spinner = this.createStringPicker3D();
                        break;
                    }
                    case 8: {
                        spinner = this.createCalendarPicker();
                        break;
                    }
                    case 1: {
                        spinner = this.createDatePicker3D();
                        break;
                    }
                    case 2: {
                        spinner = this.createTimePicker3D();
                        break;
                    }
                    case 3: {
                        spinner = this.createDateTimePicker3D();
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        spinner = this.createDurationPicker3D();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported picker type " + Picker.this.type);
                    }
                }
                final InteractionDialog dlg = new InteractionDialog((InternalPickerWidget)((Object)spinner)){
                    ActionListener keyListener;
                    final /* synthetic */ InternalPickerWidget val$spinner;
                    {
                        this.val$spinner = internalPickerWidget;
                    }

                    protected void initComponent() {
                        final 1 self = this;
                        super.initComponent();
                        if (this.keyListener == null) {
                            this.keyListener = new ActionListener(){

                                public void actionPerformed(ActionEvent evt) {
                                    if (Display.getInstance().isShiftKeyDown()) {
                                        this.endEditing(3, self, val$spinner);
                                    } else {
                                        this.endEditing(2, self, val$spinner);
                                    }
                                }
                            };
                        }
                        this.getComponentForm().addKeyListener(9, this.keyListener);
                    }

                    protected void deinitialize() {
                        Form f = this.getComponentForm();
                        if (f == null) {
                            f = Display.getInstance().getCurrent();
                        }
                        if (f != null && this.keyListener != null) {
                            f.removeKeyListener(9, this.keyListener);
                        }
                        super.deinitialize();
                    }
                };
                dlg.setOwner(Picker.this);
                ComponentSelector.select("DialogTitle", dlg).getParent().setPadding(0).setMargin(0).setBorder(Border.createEmpty());
                dlg.getTitleComponent().setVisible(false);
                ComponentSelector.select(dlg.getTitleComponent()).setPadding(0).setMargin(0);
                dlg.setUIID(isTablet ? "PickerDialogTablet" : "PickerDialog");
                dlg.getUnselectedStyle().setBgColor(new Label("", "Spinner3DOverlay").getUnselectedStyle().getBgColor());
                dlg.getUnselectedStyle().setBgTransparency(255);
                if (isTablet) {
                    dlg.getUnselectedStyle().setBorder(RoundRectBorder.create().cornerRadius(2.0f));
                }
                dlg.getContentPane().setLayout(new BorderLayout());
                String dlgUiid = isTablet ? "PickerDialogContentTablet" : "PickerDialogContent";
                dlg.getContentPane().setUIID(dlgUiid);
                dlg.getContentPane().getUnselectedStyle().setBgColor(new Label("", "Spinner3DOverlay").getUnselectedStyle().getBgColor());
                Component spinnerC = spinner;
                Container wrapper = BorderLayout.center(spinnerC);
                ComponentSelector.select(wrapper).addTags("SpinnerWrapper");
                ComponentSelector.select(wrapper).selectAllStyles().setBorder(Border.createEmpty()).setBgTransparency(0).setMargin(0).setPaddingMillimeters(3.0f, 0.0f);
                dlg.getContentPane().add((Object)"Center", wrapper);
                Button doneButton = new Button("Done", isTablet ? "PickerButtonTablet" : "PickerButton");
                doneButton.addActionListener(new ActionListener((InternalPickerWidget)((Object)spinner)){
                    final /* synthetic */ InternalPickerWidget val$spinner;
                    {
                        this.val$spinner = internalPickerWidget;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.endEditing(1, dlg, this.val$spinner);
                    }
                });
                Button cancelButton = new Button("Cancel", isTablet ? "PickerButtonTablet" : "PickerButton");
                cancelButton.addActionListener(new ActionListener((InternalPickerWidget)((Object)spinner)){
                    final /* synthetic */ InternalPickerWidget val$spinner;
                    {
                        this.val$spinner = internalPickerWidget;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.endEditing(4, dlg, this.val$spinner);
                    }
                });
                Button nextButton = null;
                Form.TabIterator traversalIt = Picker.this.getComponentForm().getTabIterator(Picker.this);
                if (traversalIt.hasNext()) {
                    nextButton = new Button("", isTablet ? "PickerButtonTablet" : "PickerButton");
                    nextButton.putClientProperty("$$focus", traversalIt.getNext());
                    FontImage.setMaterialIcon(nextButton, '\ue313');
                    nextButton.addActionListener(new ActionListener((InternalPickerWidget)((Object)spinner)){
                        final /* synthetic */ InternalPickerWidget val$spinner;
                        {
                            this.val$spinner = internalPickerWidget;
                        }

                        public void actionPerformed(ActionEvent evt) {
                            this.endEditing(2, dlg, this.val$spinner);
                        }
                    });
                }
                Button prevButton = null;
                if (traversalIt.hasPrevious()) {
                    prevButton = new Button("", isTablet ? "PickerButtonTablet" : "PickerButton");
                    prevButton.putClientProperty("$$focus", traversalIt.getPrevious());
                    FontImage.setMaterialIcon(prevButton, '\ue316');
                    prevButton.addActionListener(new ActionListener((InternalPickerWidget)((Object)spinner)){
                        final /* synthetic */ InternalPickerWidget val$spinner;
                        {
                            this.val$spinner = internalPickerWidget;
                        }

                        public void actionPerformed(ActionEvent evt) {
                            this.endEditing(3, dlg, this.val$spinner);
                        }
                    });
                }
                Container west = new Container(BoxLayout.x());
                ComponentSelector.$(west).selectAllStyles().setMargin(0).setPadding(0).setBorder(Border.createEmpty()).setBgTransparency(0);
                west.add(cancelButton);
                if (prevButton != null) {
                    west.add(prevButton);
                }
                if (nextButton != null) {
                    west.add(nextButton);
                }
                Container buttonBar = BorderLayout.centerEastWest(null, doneButton, west);
                buttonBar.setUIID(isTablet ? "PickerButtonBarTablet" : "PickerButtonBar");
                dlg.getContentPane().add((Object)"North", buttonBar);
                Form form = Picker.this.getComponentForm();
                if (form == null) {
                    throw new RuntimeException("Attempt to show interaction dialog while button is not on form.  Illegal state");
                }
                final int top = Math.max(0, form.getContentPane().getHeight() - dlg.getPreferredH());
                if (top == 0) {
                    wrapper.getUnselectedStyle().setPaddingTop(0);
                    wrapper.getUnselectedStyle().setPaddingBottom(0);
                }
                boolean left = false;
                boolean right = false;
                boolean bottom = false;
                dlg.setWidth(Display.getInstance().getDisplayWidth());
                dlg.setHeight(dlg.getPreferredH());
                dlg.setY(Display.getInstance().getDisplayHeight());
                dlg.setX(0);
                dlg.setRepositionAnimation(false);
                Picker.this.registerAsInputDevice(dlg);
                if (Display.getInstance().isTablet()) {
                    Picker.this.getComponentForm().getAnimationManager().flushAnimation(new Runnable(){

                        public void run() {
                            dlg.showPopupDialog(Picker.this);
                        }
                    });
                } else {
                    Picker.this.getComponentForm().getAnimationManager().flushAnimation(new Runnable(){

                        public void run() {
                            dlg.show(top, 0, 0, 0);
                            Picker.this.padContentPane(top, 0, 0, 0);
                        }
                    });
                }
            }

            private boolean showDialog(Dialog pickerDlg, Component c) {
                pickerDlg.addComponent("Center", c);
                Button ok = new Button(new Command("OK"));
                final boolean[] userCanceled = new boolean[1];
                Button cancel = new Button(new Command("Cancel"){

                    public void actionPerformed(ActionEvent evt) {
                        userCanceled[0] = true;
                        super.actionPerformed(evt);
                    }
                });
                Container buttons = GridLayout.encloseIn(2, cancel, ok);
                pickerDlg.addComponent("South", (Component)buttons);
                if (Display.getInstance().isTablet()) {
                    pickerDlg.showPopupDialog(Picker.this);
                } else {
                    pickerDlg.show();
                }
                return !userCanceled[0];
            }
        });
        this.updateValue();
    }

    public void startEditingAsync() {
        this.fireActionEvent(-1, -1);
    }

    public void stopEditing(Runnable onFinish) {
        this.stopEditingCallback = onFinish;
        Form f = this.getComponentForm();
        if (f != null && f.getCurrentInputDevice() == this.currentInput) {
            try {
                f.setCurrentInputDevice(null);
            }
            catch (Throwable t) {
                Log.e(t);
            }
        }
    }

    public boolean isEditing() {
        Form f = this.getComponentForm();
        boolean out = this.currentInput != null && f != null && f.getCurrentInputDevice() == this.currentInput;
        return out;
    }

    public boolean isEditable() {
        return this.isUseLightweightPopup();
    }

    public void setType(int type) {
        this.type = type;
        switch (type) {
            case 1: 
            case 3: {
                if (this.value instanceof Date) break;
                this.value = new Date();
                break;
            }
            case 4: {
                if (this.value != null && (Util.instanceofObjArray(this.value) || this.value instanceof String[])) break;
                this.setStrings(" ");
                break;
            }
            case 2: {
                if (this.value instanceof Integer) break;
                this.setTime(0);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (this.value instanceof Long) break;
                this.setDuration(0L);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public Date getDate() {
        return (Date)this.value;
    }

    public void setDate(Date d) {
        this.value = d;
        this.updateValue();
    }

    private String twoDigits(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    public void setStrings(String ... strs) {
        this.type = 4;
        int slen = strs.length;
        for (int i = 0; i < slen; ++i) {
            String str = strs[i];
            strs[i] = this.getUIManager().localize(str, str);
        }
        this.metaData = strs;
        if (!(this.value instanceof String)) {
            this.value = null;
        }
        this.updateValue();
    }

    private void restoreContentPane() {
        Form f = this.getComponentForm();
        if (this.tmpContentPaneMarginUnit != null && f != null) {
            Container contentPane = f.getContentPane();
            Style style = contentPane.getStyle();
            style.setMarginUnit(this.tmpContentPaneMarginUnit);
            style.setMarginBottom(this.tmpContentPaneBottomMargin);
            this.tmpContentPaneMarginUnit = null;
            f.revalidate();
            if (f != null && f.getContentPane() != null && f.getContentPane().getScrollY() < 0) {
                f.getContentPane().pointerPressed(100, 100);
                f.getContentPane().pointerDragged(100, 100);
                f.getContentPane().pointerReleased(100, 100);
            }
        }
    }

    private void padContentPane(final int top, int bottom, int left, int right) {
        final Form f = this.getComponentForm();
        if (f != null) {
            f.getAnimationManager().flushAnimation(new Runnable(){

                public void run() {
                    Container contentPane = f.getContentPane();
                    Style style = contentPane.getStyle();
                    byte[] marginUnits = style.getMarginUnit();
                    if (marginUnits == null) {
                        marginUnits = new byte[]{0, 0, 0, 0};
                    }
                    if (Picker.this.tmpContentPaneMarginUnit == null) {
                        Picker.access$1902(Picker.this, new byte[4]);
                        System.arraycopy(marginUnits, 0, Picker.this.tmpContentPaneMarginUnit, 0, 4);
                        Picker.this.tmpContentPaneBottomMargin = style.getMarginBottom();
                    }
                    marginUnits[2] = 0;
                    style.setMarginUnit(marginUnits);
                    style.setMarginBottom(Math.max(0, contentPane.getHeight() - top));
                    f.revalidate();
                    f.scrollComponentToVisible(Picker.this);
                }
            });
        }
    }

    private void registerAsInputDevice(final InteractionDialog dlg) {
        final Form f = this.getComponentForm();
        if (f != null) {
            ActionListener sizeChanged;
            if (!Display.getInstance().isTablet()) {
                sizeChanged = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        final int top = f.getContentPane().getHeight() - dlg.getPreferredH();
                        if (top <= 0) {
                            ComponentSelector.select(".SpinnerWrapper", dlg).setPadding(0);
                        }
                        boolean left = false;
                        boolean right = false;
                        boolean bottom = false;
                        dlg.setWidth(Display.getInstance().getDisplayWidth());
                        dlg.setHeight(dlg.getPreferredH());
                        dlg.setY(Display.getInstance().getDisplayHeight());
                        dlg.setX(0);
                        f.getAnimationManager().flushAnimation(new Runnable(){

                            public void run() {
                                dlg.resize(top, 0, 0, 0);
                                Picker.this.padContentPane(top, 0, 0, 0);
                            }
                        });
                    }
                };
                f.addSizeChangedListener(sizeChanged);
            } else {
                sizeChanged = null;
            }
            try {
                VirtualInputDevice nextInput = new VirtualInputDevice(){

                    public void close() throws Exception {
                        Picker.this.currentInput = null;
                        if (sizeChanged != null) {
                            f.removeSizeChangedListener(sizeChanged);
                        }
                        if (dlg.isShowing()) {
                            Picker.this.restoreContentPane();
                            dlg.disposeToTheBottom(new Runnable(){

                                public void run() {
                                    if (Picker.this.stopEditingCallback != null) {
                                        Runnable r = Picker.this.stopEditingCallback;
                                        Picker.this.stopEditingCallback = null;
                                        r.run();
                                    }
                                }
                            });
                        } else {
                            Picker.this.stopEditingCallback = null;
                        }
                    }
                };
                f.setCurrentInputDevice(nextInput);
                this.currentInput = nextInput;
            }
            catch (Exception ex) {
                Log.e(ex);
                return;
            }
        }
    }

    public String[] getStrings() {
        return (String[])this.metaData;
    }

    public void setSelectedString(String str) {
        this.value = str;
        this.updateValue();
    }

    public String getSelectedString() {
        return (String)this.value;
    }

    public int getSelectedStringIndex() {
        int offset = 0;
        for (String s : (String[])this.metaData) {
            if (s == this.value) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public void setSelectedStringIndex(int index) {
        this.value = ((String[])this.metaData)[index];
        this.updateValue();
    }

    protected void updateValue() {
        if (this.value == null) {
            this.setText("...");
            return;
        }
        if (this.getFormatter() != null) {
            this.setText(this.formatter.format(this.value));
            return;
        }
        switch (this.type) {
            case 4: {
                this.value = this.getUIManager().localize(this.value.toString(), this.value.toString());
                this.setText(this.value.toString());
                break;
            }
            case 1: 
            case 8: {
                this.setText(L10NManager.getInstance().formatDateShortStyle((Date)this.value));
                break;
            }
            case 2: {
                int v = (Integer)this.value;
                int hour = v / 60;
                int minute = v % 60;
                if (this.showMeridiem) {
                    int cookedHour;
                    String text = hour >= 12 ? "pm" : "am";
                    int n = cookedHour = hour <= 12 ? hour : hour - 12;
                    if (cookedHour == 0) {
                        cookedHour = 12;
                    }
                    this.setText(this.twoDigits(cookedHour) + ":" + this.twoDigits(minute) + text);
                    break;
                }
                this.setText(this.twoDigits(hour) + ":" + this.twoDigits(minute));
                break;
            }
            case 3: {
                this.setText(L10NManager.getInstance().formatDateTimeShort((Date)this.value));
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                long v = (Long)this.value;
                int hour = (int)(v / 60L / 60L / 1000L);
                int minute = (int)(v / 1000L / 60L) % 60;
                StringBuilder sb = new StringBuilder();
                UIManager uim = this.getUIManager();
                if (hour > 0) {
                    sb.append(hour).append(" ").append(hour > 1 ? uim.localize("hours", "hours") : uim.localize("hour", "hour")).append(" ");
                }
                if (minute > 0) {
                    sb.append(minute).append(" ").append(minute > 1 ? uim.localize("minutes", "minutes") : uim.localize("minute", "minute"));
                }
                this.setText(sb.toString().trim());
                if (!"".equals(this.getText())) break;
                this.setText("...");
                break;
            }
        }
    }

    public void setTime(int time) {
        this.value = new Integer(time);
        this.updateValue();
    }

    public void setTime(int hour, int minute) {
        this.setTime(hour * 60 + minute);
    }

    public int getTime() {
        return (Integer)this.value;
    }

    public void setDuration(long duration) {
        this.value = new Long(duration);
        this.updateValue();
    }

    public void setMinuteStep(int step) {
        this.minuteStep = step;
    }

    public void setDuration(int hour, int minute) {
        this.setDuration((long)(hour * 60 * 60) * 1000L + (long)(minute * 60) * 1000L);
    }

    public long getDuration() {
        return (Long)this.value;
    }

    public int getDurationHours() {
        return (int)(this.getDuration() / 60L / 60L / 1000L);
    }

    public int getDurationMinutes() {
        return (int)(this.getDuration() / 1000L / 60L) % 60;
    }

    public boolean isShowMeridiem() {
        return this.showMeridiem;
    }

    public void setShowMeridiem(boolean showMeridiem) {
        this.showMeridiem = showMeridiem;
        this.updateValue();
    }

    public Object getRenderingPrototype() {
        return this.renderingPrototype;
    }

    public void setRenderingPrototype(Object renderingPrototype) {
        this.renderingPrototype = renderingPrototype;
    }

    public SimpleDateFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(SimpleDateFormat formatter) {
        this.formatter = formatter;
        this.updateValue();
    }

    public void setPreferredPopupWidth(int width) {
        this.preferredPopupWidth = width;
    }

    public void setPreferredPopupHeight(int height) {
        this.preferredPopupHeight = height;
    }

    public int getPreferredPopupWidth() {
        return this.preferredPopupWidth;
    }

    public int getPreferredPopupHeight() {
        return this.preferredPopupHeight;
    }

    public String[] getPropertyNames() {
        return new String[]{"Strings"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String[].class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String []"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("Strings")) {
            return this.getStrings();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("Strings")) {
            this.setStrings((String[])value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Object getValue() {
        return this.value;
    }

    public void paint(Graphics g) {
        if (!this.suppressPaint) {
            super.paint(g);
        }
    }

    public Style getStyle() {
        if (this.isEditing()) {
            return this.getSelectedStyle();
        }
        return super.getStyle();
    }

    void setSuppressPaint(boolean suppress) {
        this.suppressPaint = suppress;
    }

    static /* synthetic */ byte[] access$1902(Picker x0, byte[] x1) {
        x0.tmpContentPaneMarginUnit = x1;
        return x1;
    }
}

