/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import com.codename1.io.Util;
import com.codename1.ui.CN;
import com.codename1.util.AsyncResult;
import com.codename1.util.EasyThread;
import com.codename1.util.SuccessCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncResource<V>
extends Observable {
    private V value;
    private Throwable error;
    private SuccessCallback<V> successCallback;
    private SuccessCallback<Throwable> errorCallback;
    private boolean done;
    private boolean cancelled;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return false;
            }
            if (!this.cancelled) {
                this.cancelled = true;
                this.done = true;
                this.error = new CancellationException();
                changed = true;
            }
        }
        if (changed) {
            this.setChanged();
        }
        return true;
    }

    public void waitFor() {
        try {
            this.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public V get() {
        try {
            return this.get((V)-1);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted exception occurred, but this should never happen.  Likely programming error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V get(final int timeout) throws InterruptedException {
        long startTime;
        long l = startTime = timeout > 0 ? System.currentTimeMillis() : 0L;
        if (this.done && this.error == null) {
            return this.value;
        }
        if (this.done && this.error != null) {
            throw new AsyncExecutionException(this.error);
        }
        final boolean[] complete = new boolean[1];
        Observer observer = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void update(Observable obj, Object arg) {
                if (!AsyncResource.this.isDone()) return;
                complete[0] = true;
                boolean[] blArray = complete;
                synchronized (complete) {
                    complete.notify();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        this.addObserver(observer);
        while (true) {
            if (complete[0]) {
                this.deleteObserver(observer);
                if (this.error == null) return this.value;
                throw new AsyncExecutionException(this.error);
            }
            if (timeout > 0 && System.currentTimeMillis() > startTime + (long)timeout) {
                throw new InterruptedException("Timeout occurred in get()");
            }
            if (CN.isEdt()) {
                CN.invokeAndBlock(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray = complete;
                        synchronized (complete) {
                            if (timeout > 0) {
                                Util.wait(complete, (int)Math.max(1L, (long)timeout - (System.currentTimeMillis() - startTime)));
                            } else {
                                Util.wait(complete);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
                continue;
            }
            boolean[] blArray = complete;
            // MONITORENTER : complete
            if (timeout > 0) {
                Util.wait(complete, (int)Math.max(1L, (long)timeout - (System.currentTimeMillis() - startTime)));
            } else {
                Util.wait(complete);
            }
            // MONITOREXIT : blArray
        }
    }

    public static boolean isCancelled(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof AsyncExecutionException) {
            return ((AsyncExecutionException)t).isCancelled();
        }
        return t.getClass() == CancellationException.class;
    }

    public V get(V defaultVal) {
        if (this.value != null) {
            return this.value;
        }
        return defaultVal;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isReady() {
        return this.done && this.error == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResource<V> ready(final SuccessCallback<V> callback, EasyThread t) {
        AsyncCallback<V> runImmediately = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.done && this.error == null) {
                runImmediately = new AsyncCallback<V>(callback, t);
            } else if (this.successCallback == null) {
                this.successCallback = new AsyncCallback<V>(callback, t);
            } else {
                final SuccessCallback<V> oldCallback = this.successCallback;
                this.successCallback = new AsyncCallback<V>(new SuccessCallback<V>(){

                    @Override
                    public void onSucess(V res) {
                        oldCallback.onSucess(res);
                        callback.onSucess(res);
                    }
                }, t);
            }
        }
        if (runImmediately != null) {
            runImmediately.onSucess(this.value);
        }
        return this;
    }

    public AsyncResource<V> ready(SuccessCallback<V> callback) {
        return this.ready(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResource<V> except(final SuccessCallback<Throwable> callback, EasyThread t) {
        AsyncCallback<Throwable> runImmediately = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.done && this.error != null) {
                runImmediately = new AsyncCallback<Throwable>(callback, t);
            } else if (this.errorCallback == null) {
                this.errorCallback = new AsyncCallback<Throwable>(callback, t);
            } else {
                final SuccessCallback<Throwable> oldErrorCallback = this.errorCallback;
                this.errorCallback = new AsyncCallback<Throwable>(new SuccessCallback<Throwable>(){

                    @Override
                    public void onSucess(Throwable res) {
                        oldErrorCallback.onSucess(res);
                        callback.onSucess(res);
                    }
                }, t);
            }
        }
        if (runImmediately != null) {
            runImmediately.onSucess(this.error);
        }
        return this;
    }

    public AsyncResource<V> except(SuccessCallback<Throwable> callback) {
        return this.except(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(V value) {
        SuccessCallback<V> cb = null;
        Object object = this.lock;
        synchronized (object) {
            this.value = value;
            this.done = true;
            if (this.successCallback != null) {
                cb = this.successCallback;
            }
        }
        this.setChanged();
        this.notifyObservers();
        if (cb != null) {
            cb.onSucess(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable t) {
        SuccessCallback<Throwable> cb = null;
        Object object = this.lock;
        synchronized (object) {
            this.error = t;
            this.done = true;
            if (this.errorCallback != null) {
                cb = this.errorCallback;
            }
        }
        this.setChanged();
        this.notifyObservers();
        if (cb != null) {
            cb.onSucess(this.error);
        }
    }

    public static AsyncResource<Boolean> all(AsyncResource<?> ... resources) {
        final AsyncResource<Boolean> out = new AsyncResource<Boolean>();
        final HashSet pending = new HashSet(Arrays.asList(resources));
        final boolean[] complete = new boolean[1];
        for (final AsyncResource<?> res : resources) {
            res.ready(new SuccessCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSucess(Object arg) {
                    boolean[] blArray = complete;
                    synchronized (complete) {
                        if (complete[0]) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        pending.remove(res);
                        if (!pending.isEmpty()) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        complete[0] = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        out.complete(true);
                        return;
                    }
                }
            });
            res.except(new SuccessCallback<Throwable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSucess(Throwable ex) {
                    boolean[] blArray = complete;
                    synchronized (complete) {
                        if (complete[0]) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        pending.remove(res);
                        complete[0] = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        out.error(ex);
                        return;
                    }
                }
            });
        }
        return out;
    }

    public static AsyncResource<Boolean> all(Collection<AsyncResource<?>> resources) {
        return AsyncResource.all(resources.toArray(new AsyncResource[resources.size()]));
    }

    public static void await(Collection<AsyncResource<?>> resources) throws AsyncExecutionException {
        AsyncResource.await(resources.toArray(new AsyncResource[resources.size()]));
    }

    public void await() throws AsyncExecutionException {
        AsyncResource.await(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void await(AsyncResource<?> ... resources) throws AsyncExecutionException {
        final boolean[] complete = new boolean[1];
        final Throwable[] t = new Throwable[1];
        AsyncResource.all(resources).ready(new SuccessCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSucess(Object arg) {
                boolean[] blArray = complete;
                synchronized (complete) {
                    complete[0] = true;
                    complete.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        }).except(new SuccessCallback<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSucess(Throwable ex) {
                boolean[] blArray = complete;
                synchronized (complete) {
                    t[0] = ex;
                    complete[0] = true;
                    complete.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        while (true) {
            if (complete[0]) {
                if (t[0] == null) return;
                throw new AsyncExecutionException(t[0]);
            }
            if (CN.isEdt()) {
                CN.invokeAndBlock(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray = complete;
                        synchronized (complete) {
                            if (!complete[0]) {
                                Util.wait(complete);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
                continue;
            }
            boolean[] blArray = complete;
            // MONITORENTER : complete
            if (!complete[0]) {
                Util.wait(complete);
            }
            // MONITOREXIT : blArray
        }
    }

    public void addListener(final AsyncResource<V> resource) {
        this.ready(new SuccessCallback<V>(){

            @Override
            public void onSucess(V value) {
                if (!resource.isDone()) {
                    resource.complete(value);
                }
            }
        }).except(new SuccessCallback<Throwable>(){

            @Override
            public void onSucess(Throwable value) {
                if (!resource.isDone()) {
                    resource.error(value);
                }
            }
        });
    }

    public void onResult(final AsyncResult<V> onResult) {
        this.ready(new SuccessCallback<V>(){

            @Override
            public void onSucess(V value) {
                onResult.onReady(value, null);
            }
        }).except(new SuccessCallback<Throwable>(){

            @Override
            public void onSucess(Throwable value) {
                onResult.onReady(null, value);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncCallback<T>
    implements SuccessCallback<T> {
        private SuccessCallback<T> cb;
        private EasyThread t;
        private boolean edt;

        AsyncCallback(SuccessCallback<T> cb, EasyThread t) {
            this.cb = cb;
            this.t = t;
            this.edt = t == null && CN.isEdt();
        }

        @Override
        public void onSucess(final T value) {
            if (this.edt && !CN.isEdt()) {
                CN.callSerially(new Runnable(){

                    public void run() {
                        AsyncCallback.this.onSucess(value);
                    }
                });
                return;
            }
            if (this.t != null && !this.t.isThisIt()) {
                this.t.run(new Runnable(){

                    public void run() {
                        AsyncCallback.this.onSucess(value);
                    }
                });
                return;
            }
            this.cb.onSucess(value);
        }
    }

    public static class CancellationException
    extends RuntimeException {
        public CancellationException() {
            super("Cancelled");
        }
    }

    public static class AsyncExecutionException
    extends RuntimeException {
        private Throwable cause;

        public AsyncExecutionException(Throwable cause) {
            super(cause.getMessage());
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public boolean isCancelled() {
            if (this.cause != null && this.cause.getClass() == CancellationException.class) {
                return true;
            }
            if (this.cause != null && this.cause instanceof AsyncExecutionException) {
                return ((AsyncExecutionException)this.cause).isCancelled();
            }
            return false;
        }
    }
}

