/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.properties.PropertyBusinessObject;
import com.codename1.properties.PropertyChangeListener;
import com.codename1.properties.PropertyIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBase<T, K> {
    private final String name;
    private Class genericType;
    private ArrayList<PropertyChangeListener<T, K>> listeners;
    PropertyIndex parent;
    private static PropertyChangeListener lastChangeListener;
    static PropertyChangeListener onGlobalGetProperty;
    static PropertyChangeListener onGlobalSetProperty;

    protected PropertyBase(String name) {
        this.name = name;
    }

    List<PropertyChangeListener<T, K>> getListeners() {
        return this.listeners;
    }

    void internalGet() {
        if (onGlobalGetProperty != null) {
            onGlobalGetProperty.propertyChanged(this);
        }
    }

    void internalSet() {
        if (onGlobalSetProperty != null) {
            onGlobalSetProperty.propertyChanged(this);
        }
    }

    public static void bindGlobalSetListener(PropertyChangeListener listener) {
        if (onGlobalSetProperty != null) {
            throw new RuntimeException("Set Listener already bound");
        }
        onGlobalSetProperty = listener;
    }

    public static void bindGlobalGetListener(PropertyChangeListener listener) {
        if (onGlobalGetProperty != null) {
            throw new RuntimeException("Get Listener already bound");
        }
        onGlobalGetProperty = listener;
    }

    protected PropertyBase(String name, Class genericType) {
        this.name = name;
        this.genericType = genericType;
    }

    public String getName() {
        return this.name;
    }

    protected void firePropertyChanged() {
        if (this.listeners != null) {
            Iterator<PropertyChangeListener<T, K>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                PropertyChangeListener<T, K> pl;
                lastChangeListener = pl = iterator.next();
                pl.propertyChanged(this);
                lastChangeListener = null;
            }
        }
    }

    public void stopListening() {
        this.removeChangeListener(lastChangeListener);
    }

    public void addChangeListener(PropertyChangeListener<T, K> pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(pl);
    }

    public void removeChangeListener(PropertyChangeListener<T, K> pl) {
        if (this.listeners != null) {
            this.listeners.remove(pl);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public void putClientProperty(String key, Object o) {
        this.parent.putMetaDataOfClass("cn1$field" + this.name + "-" + key, o);
    }

    public Object getClientProperty(String key) {
        return this.parent.getMetaDataOfClass("cn1$field" + this.name + "-" + key);
    }

    public boolean equals(Object obj) {
        PropertyBase other;
        return obj != null && obj.getClass() == this.getClass() && (other = (PropertyBase)obj).getName().equals(this.name);
    }

    T get() {
        return null;
    }

    void setImpl(Object val) {
    }

    public String toString() {
        T o = this.get();
        if (o == null) {
            return this.getName() + " = null";
        }
        return this.getName() + " = '" + o + "' : " + o.getClass().getName();
    }

    public Class getGenericType() {
        return this.genericType;
    }

    public void setLabel(String label) {
        this.putClientProperty("cn1PropertyLabel", label);
    }

    public String getLabel() {
        String l = (String)this.getClientProperty("cn1PropertyLabel");
        if (l == null) {
            return this.getName();
        }
        return l;
    }

    protected final void validateCollectionType(Class elementType) {
        if (elementType == null || !PropertyBusinessObject.class.isAssignableFrom(elementType)) {
            if (elementType == String.class || elementType == Integer.class || elementType == Long.class || elementType == Double.class || elementType == Byte.class || elementType == Float.class || elementType == Boolean.class || elementType == Character.class) {
                return;
            }
            throw new IllegalArgumentException("the element type class needs to be a subclass of PropertyBusinessObject");
        }
    }
}

