/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.components.SpanButton;
import com.codename1.components.SpanLabel;
import com.codename1.io.Util;
import com.codename1.ui.AnimationManager;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.IconHolder;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.Painter;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextField;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.animations.ComponentAnimation;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.FocusListener;
import com.codename1.ui.events.ScrollListener;
import com.codename1.ui.events.StyleListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import com.codename1.util.SuccessCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSelector
implements Iterable<Component>,
Set<Component> {
    private static final String PROPERTY_TAG = "com.codename1.ui.ComponentSelector#tags";
    private String name;
    private String uiid;
    private String[] tags;
    private String[] tagsNeedles;
    private String state;
    private ComponentSelector parent;
    private Set<ComponentSelector> aggregateSelectors;
    private final Set<Component> roots = new LinkedHashSet<Component>();
    private Set<Component> results;
    private boolean childrenOnly = false;
    private Style currentStyle = null;
    private int currentStyleType = 0;
    private static final int ALL_STYLES = 1;
    private static final int PRESSED_STYLE = 2;
    private static final int SELECTED_STYLE = 3;
    private static final int UNSELECTED_STYLE = 4;
    private static final int DISABLED_STYLE = 5;

    private Style currentStyle() {
        if (this.currentStyle == null) {
            switch (this.currentStyleType) {
                case 1: {
                    this.currentStyle = this.getAllStyles();
                    break;
                }
                case 2: {
                    this.currentStyle = this.getPressedStyle();
                    break;
                }
                case 3: {
                    this.currentStyle = this.getSelectedStyle();
                    break;
                }
                case 4: {
                    this.currentStyle = this.getUnselectedStyle();
                    break;
                }
                case 5: {
                    this.currentStyle = this.getDisabledStyle();
                    break;
                }
                default: {
                    this.currentStyle = this.getStyle();
                }
            }
        }
        return this.currentStyle;
    }

    public static ComponentSelector $(Component ... cmps) {
        return new ComponentSelector(cmps);
    }

    public static ComponentSelector select(Component ... cmps) {
        return ComponentSelector.$(cmps);
    }

    private void setDirty() {
        this.currentStyle = null;
    }

    public static ComponentSelector $(ActionEvent e) {
        Object src = e.getSource();
        if (src == null) {
            return new ComponentSelector(new Component[0]);
        }
        if (src instanceof Component) {
            return new ComponentSelector((Component)src);
        }
        return new ComponentSelector(new Component[0]);
    }

    public static ComponentSelector select(ActionEvent e) {
        return ComponentSelector.$(e);
    }

    public static ComponentSelector $(Runnable r) {
        Display.getInstance().callSerially(r);
        return new ComponentSelector(new Component[0]);
    }

    public static ComponentSelector select(Runnable r) {
        return ComponentSelector.$(r);
    }

    public ComponentSelector each(ComponentClosure closure) {
        for (Component c : this) {
            closure.call(c);
        }
        return this;
    }

    public ComponentSelector map(ComponentMapper mapper) {
        LinkedHashSet<Component> out = new LinkedHashSet<Component>();
        for (Component c : this) {
            Component res = mapper.map(c);
            if (res == null) continue;
            out.add(res);
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector filter(Filter filter) {
        LinkedHashSet<Component> out = new LinkedHashSet<Component>();
        for (Component c : this) {
            boolean res = filter.filter(c);
            if (!res) continue;
            out.add(c);
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector filter(String selector) {
        ComponentSelector matcher = new ComponentSelector(selector, new Label());
        LinkedHashSet<Component> matches = new LinkedHashSet<Component>();
        for (Component c : this) {
            if (!matcher.match(c)) continue;
            matches.add(c);
        }
        return matcher.addAll(matches, true);
    }

    public ComponentSelector parent(String selector) {
        ComponentSelector matcher = new ComponentSelector(selector, new Label());
        LinkedHashSet<Container> matches = new LinkedHashSet<Container>();
        for (Component c : this) {
            Container parent = c.getParent();
            if (parent == null || !matcher.match(parent)) continue;
            matches.add(parent);
        }
        return matcher.addAll(matches, true);
    }

    public ComponentSelector parents(String selector) {
        ComponentSelector matcher = new ComponentSelector(selector, new Label());
        LinkedHashSet<Container> matches = new LinkedHashSet<Container>();
        for (Component c : this) {
            for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                if (!matcher.match(parent)) continue;
                matches.add(parent);
            }
        }
        return matcher.addAll(matches, true);
    }

    public ComponentSelector closest(String selector) {
        ComponentSelector matcher = new ComponentSelector(selector, new Label());
        LinkedHashSet<Container> matches = new LinkedHashSet<Container>();
        block0: for (Component c : this) {
            for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                if (!matcher.match(parent)) continue;
                matches.add(parent);
                continue block0;
            }
        }
        return matcher.addAll(matches, true);
    }

    public ComponentSelector firstChild() {
        LinkedHashSet<Component> out = new LinkedHashSet<Component>();
        for (Component c : this) {
            Container cnt;
            if (!(c instanceof Container) || (cnt = (Container)c).getComponentCount() <= 0) continue;
            out.add(cnt.getComponentAt(0));
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector lastChild() {
        LinkedHashSet<Component> out = new LinkedHashSet<Component>();
        for (Component c : this) {
            Container cnt;
            if (!(c instanceof Container) || (cnt = (Container)c).getComponentCount() <= 0) continue;
            out.add(cnt.getComponentAt(cnt.getComponentCount() - 1));
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector nextSibling() {
        LinkedHashSet<Component> out = new LinkedHashSet<Component>();
        for (Component c : this) {
            int index;
            Container parent = c.getParent();
            if (parent == null || (index = parent.getComponentIndex(c)) >= parent.getComponentCount() - 1) continue;
            out.add(parent.getComponentAt(index + 1));
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector prevSibling() {
        LinkedHashSet<Component> out = new LinkedHashSet<Component>();
        for (Component c : this) {
            int index;
            Container parent = c.getParent();
            if (parent == null || (index = parent.getComponentIndex(c)) <= 0) continue;
            out.add(parent.getComponentAt(index - 1));
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector animateStyle(Style destStyle, int duration, final SuccessCallback<ComponentSelector> callback) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        AnimationManager mgr = null;
        for (Component c : this) {
            AnimationManager cmgr = c.getAnimationManager();
            if (cmgr == null) continue;
            mgr = cmgr;
            Style sourceStyle = c.getUnselectedStyle();
            destStyle.merge(sourceStyle);
            animations.add(c.createStyleAnimation(sourceStyle, destStyle, duration, null));
        }
        if (mgr != null) {
            ComponentAnimation anim = ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()]));
            mgr.addAnimation(anim, new Runnable(){

                public void run() {
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector fadeIn() {
        return this.fadeIn(500);
    }

    public ComponentSelector fadeIn(int duration) {
        return this.fadeIn(duration, null);
    }

    public ComponentSelector fadeIn(final int duration, final SuccessCallback<ComponentSelector> callback) {
        String placeholderProperty = "com.codename1.ui.ComponentSelector#fadeOutPlaceholder";
        AnimationManager mgr = null;
        ArrayList<ComponentAnimation> animations1 = new ArrayList<ComponentAnimation>();
        final ArrayList animations2 = new ArrayList();
        final ArrayList<Component> animatingComponents = new ArrayList<Component>();
        for (Component c : this) {
            AnimationManager cmgr;
            Container parent = c.getParent();
            if (parent == null || (cmgr = c.getAnimationManager()) == null) continue;
            mgr = cmgr;
            Container placeholder = new Container();
            c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", placeholder);
            Component.setSameHeight(placeholder, c);
            Component.setSameWidth(placeholder, c);
            ComponentSelector.$(placeholder).setMargin(c.getStyle().getMarginTop(), c.getStyle().getMarginRight(false), c.getStyle().getMarginBottom(), c.getStyle().getMarginLeft(false)).setPadding(c.getStyle().getPaddingTop(), c.getStyle().getPaddingRight(false), c.getStyle().getPaddingBottom(), c.getStyle().getPaddingLeft(false));
            ComponentAnimation a = parent.createReplaceTransition(c, placeholder, CommonTransitions.createEmpty());
            animations1.add(a);
            animatingComponents.add(c);
        }
        if (mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations1.toArray(new ComponentAnimation[animations1.size()])), new Runnable(){

                public void run() {
                    AnimationManager mgr = null;
                    for (Component c : animatingComponents) {
                        Container placeholder = (Container)c.getClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder");
                        if (placeholder == null) continue;
                        c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", null);
                        AnimationManager cmgr = placeholder.getAnimationManager();
                        if (cmgr == null) continue;
                        mgr = cmgr;
                        c.setVisible(true);
                        Container parent = placeholder.getParent();
                        if (parent == null) continue;
                        ComponentAnimation a = parent.createReplaceTransition(placeholder, c, CommonTransitions.createFade(duration));
                        animations2.add(a);
                    }
                    if (mgr != null) {
                        final AnimationManager fmgr = mgr;
                        ComponentSelector.$(new Runnable(){

                            public void run() {
                                fmgr.addAnimation(ComponentAnimation.compoundAnimation(animations2.toArray(new ComponentAnimation[animations2.size()])), new Runnable(){

                                    public void run() {
                                        if (callback != null) {
                                            callback.onSucess(ComponentSelector.this);
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector fadeInAndWait() {
        return this.fadeInAndWait(500);
    }

    public ComponentSelector fadeInAndWait(int duration) {
        ComponentAnimation a;
        AnimationManager cmgr;
        String placeholderProperty = "com.codename1.ui.ComponentSelector#fadeOutPlaceholder";
        AnimationManager mgr = null;
        ArrayList<ComponentAnimation> animations1 = new ArrayList<ComponentAnimation>();
        ArrayList<ComponentAnimation> animations2 = new ArrayList<ComponentAnimation>();
        ArrayList<Component> animatingComponents = new ArrayList<Component>();
        for (Component c : this) {
            Container parent = c.getParent();
            if (parent == null || (cmgr = c.getAnimationManager()) == null) continue;
            mgr = cmgr;
            Container placeholder = new Container();
            c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", placeholder);
            Component.setSameHeight(placeholder, c);
            Component.setSameWidth(placeholder, c);
            ComponentSelector.$(placeholder).setMargin(c.getStyle().getMarginTop(), c.getStyle().getMarginRight(false), c.getStyle().getMarginBottom(), c.getStyle().getMarginLeft(false)).setPadding(c.getStyle().getPaddingTop(), c.getStyle().getPaddingRight(false), c.getStyle().getPaddingBottom(), c.getStyle().getPaddingLeft(false));
            a = parent.createReplaceTransition(c, placeholder, CommonTransitions.createEmpty());
            animations1.add(a);
            animatingComponents.add(c);
        }
        if (mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations1.toArray(new ComponentAnimation[animations1.size()])));
            for (Component c : animatingComponents) {
                Container placeholder = (Container)c.getClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder");
                if (placeholder == null) continue;
                c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", null);
                cmgr = placeholder.getAnimationManager();
                if (cmgr == null) continue;
                mgr = cmgr;
                c.setVisible(true);
                Container parent = placeholder.getParent();
                if (parent == null) continue;
                a = parent.createReplaceTransition(placeholder, c, CommonTransitions.createFade(duration));
                animations2.add(a);
            }
            if (mgr != null) {
                mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations2.toArray(new ComponentAnimation[animations2.size()])));
            }
        }
        return this;
    }

    public boolean isVisible() {
        Iterator<Component> iterator = this.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c.isVisible();
        }
        return false;
    }

    public boolean isHidden() {
        Iterator<Component> iterator = this.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c.isHidden();
        }
        return false;
    }

    public ComponentSelector fadeOut() {
        return this.fadeOut(500);
    }

    public ComponentSelector fadeOut(int duration) {
        return this.fadeOut(duration, null);
    }

    public ComponentSelector fadeOut(int duration, final SuccessCallback<ComponentSelector> callback) {
        String placeholderProperty = "com.codename1.ui.ComponentSelector#fadeOutPlaceholder";
        AnimationManager mgr = null;
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        final ArrayList<Component> animatingComponents = new ArrayList<Component>();
        for (Component c : this) {
            AnimationManager cmgr;
            Container parent = c.getParent();
            if (parent == null || (cmgr = c.getAnimationManager()) == null) continue;
            mgr = cmgr;
            Container placeholder = new Container();
            c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", placeholder);
            Component.setSameHeight(placeholder, c);
            Component.setSameWidth(placeholder, c);
            ComponentSelector.$(placeholder).setMargin(c.getStyle().getMarginTop(), c.getStyle().getMarginRight(false), c.getStyle().getMarginBottom(), c.getStyle().getMarginLeft(false)).setPadding(c.getStyle().getPaddingTop(), c.getStyle().getPaddingRight(false), c.getStyle().getPaddingBottom(), c.getStyle().getPaddingLeft(false));
            ComponentAnimation a = parent.createReplaceTransition(c, placeholder, CommonTransitions.createFade(duration));
            animations.add(a);
            animatingComponents.add(c);
        }
        if (mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])), new Runnable(){

                public void run() {
                    for (Component c : animatingComponents) {
                        Container parent;
                        c.setVisible(false);
                        Container placeholder = (Container)c.getClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder");
                        c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", null);
                        if (placeholder == null || (parent = placeholder.getParent()) == null) continue;
                        parent.replace((Component)placeholder, c, CommonTransitions.createEmpty());
                    }
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector slideUp(int duration) {
        return this.slideUp(duration, null);
    }

    public ComponentSelector slideUp(int duration, final SuccessCallback<ComponentSelector> callback) {
        final ArrayList<Component> animatedComponents = new ArrayList<Component>();
        for (Component c : this) {
            c.setHeight(0);
            animatedComponents.add(c);
        }
        this.getParent().animateUnlayout(duration, 255, new SuccessCallback<ComponentSelector>(){

            @Override
            public void onSucess(ComponentSelector value) {
                for (Component c : animatedComponents) {
                    c.setVisible(false);
                }
                ComponentSelector.this.getParent().revalidate();
                if (callback != null) {
                    callback.onSucess(ComponentSelector.this);
                }
            }
        });
        return this;
    }

    public ComponentSelector slideUpAndWait(int duration) {
        for (Component c : this) {
            c.setHeight(0);
        }
        this.getParent().animateUnlayoutAndWait(duration, 255);
        return this;
    }

    public ComponentSelector slideDown() {
        return this.slideDown(500);
    }

    public ComponentSelector slideUp() {
        return this.slideUp(500);
    }

    public ComponentSelector slideDown(int duration) {
        return this.slideDown(duration, null);
    }

    public ComponentSelector slideDown(int duration, SuccessCallback<ComponentSelector> callback) {
        for (Component c : this) {
            c.setHeight(0);
            c.setVisible(true);
        }
        this.getParent().animateLayout(duration, callback);
        return this;
    }

    public ComponentSelector slideDownAndWait(int duration) {
        ArrayList<Component> animatedComponents = new ArrayList<Component>();
        for (Component c : this) {
            c.setHeight(0);
            c.setVisible(true);
            animatedComponents.add(c);
        }
        this.getParent().animateLayoutAndWait(duration);
        return this;
    }

    public ComponentSelector fadeOutAndWait(int duration) {
        String placeholderProperty = "com.codename1.ui.ComponentSelector#fadeOutPlaceholder";
        AnimationManager mgr = null;
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        ArrayList<Component> animatingComponents = new ArrayList<Component>();
        for (Component c : this) {
            AnimationManager cmgr;
            Container parent = c.getParent();
            if (parent == null || (cmgr = c.getAnimationManager()) == null) continue;
            mgr = cmgr;
            Container placeholder = new Container();
            c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", placeholder);
            Component.setSameHeight(placeholder, c);
            Component.setSameWidth(placeholder, c);
            ComponentSelector.$(placeholder).setMargin(c.getStyle().getMarginTop(), c.getStyle().getMarginRight(false), c.getStyle().getMarginBottom(), c.getStyle().getMarginLeft(false)).setPadding(c.getStyle().getPaddingTop(), c.getStyle().getPaddingRight(false), c.getStyle().getPaddingBottom(), c.getStyle().getPaddingLeft(false));
            ComponentAnimation a = parent.createReplaceTransition(c, placeholder, CommonTransitions.createFade(duration));
            animations.add(a);
            animatingComponents.add(c);
        }
        if (mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
            for (Component c : animatingComponents) {
                Container parent;
                c.setVisible(false);
                Container placeholder = (Container)c.getClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder");
                c.putClientProperty("com.codename1.ui.ComponentSelector#fadeOutPlaceholder", null);
                if (placeholder == null || (parent = placeholder.getParent()) == null) continue;
                parent.replace((Component)placeholder, c, CommonTransitions.createEmpty());
            }
        }
        return this;
    }

    public ComponentSelector replace(ComponentMapper mapper) {
        return this.replace(mapper, CommonTransitions.createEmpty());
    }

    public ComponentSelector replace(ComponentMapper mapper, Transition t) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        LinkedHashSet<Component> replacements = new LinkedHashSet<Component>();
        for (Component c : this) {
            Container parent = c.getParent();
            Component replacement = mapper.map(c);
            if (parent != null && replacement != c) {
                if (replacement != null) {
                    animations.add(parent.createReplaceTransition(c, replacement, t.copy(false)));
                } else {
                    c.remove();
                }
            }
            if (replacement == null) continue;
            replacements.add(replacement);
        }
        AnimationManager mgr = this.getAnimationManager();
        if (mgr != null && animations.size() > 0) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return new ComponentSelector(replacements);
    }

    public ComponentSelector replaceAndWait(ComponentMapper mapper, Transition t) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        LinkedHashSet<Component> replacements = new LinkedHashSet<Component>();
        for (Component c : this) {
            Container parent = c.getParent();
            Component replacement = mapper.map(c);
            if (parent != null && replacement != c) {
                if (replacement != null) {
                    animations.add(parent.createReplaceTransition(c, replacement, t.copy(false)));
                } else {
                    c.remove();
                }
            }
            if (replacement == null) continue;
            replacements.add(replacement);
        }
        AnimationManager mgr = this.getAnimationManager();
        if (mgr != null && animations.size() > 0) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return new ComponentSelector(replacements);
    }

    public ComponentSelector(Component ... cmps) {
        this.results = new LinkedHashSet<Component>();
        for (Component cmp : cmps) {
            this.results.add(cmp);
        }
    }

    public static ComponentSelector $(Set<Component> cmps) {
        return new ComponentSelector(cmps);
    }

    public static ComponentSelector select(Set<Component> cmps) {
        return ComponentSelector.$(cmps);
    }

    public ComponentSelector(Set<Component> cmps) {
        this.results = new LinkedHashSet<Component>();
        this.results.addAll(cmps);
    }

    public static ComponentSelector $(String selector) {
        return new ComponentSelector(selector);
    }

    public static ComponentSelector select(String selector) {
        return ComponentSelector.$(selector);
    }

    public ComponentSelector(String selector) {
        Form f = Display.getInstance().getCurrent();
        if (f == null) {
            throw new RuntimeException("Attempt to create selector on current form, but there is no current form.  Best practice is to explicitly provide a root for your ComponentSelector.");
        }
        this.roots.add(f);
        this.parse(selector);
    }

    public static ComponentSelector $(String selector, Component ... roots) {
        return new ComponentSelector(selector, roots);
    }

    public static ComponentSelector select(String selector, Component ... roots) {
        return ComponentSelector.$(selector, roots);
    }

    public ComponentSelector(String selector, Component ... roots) {
        for (Component root : roots) {
            this.roots.add(root);
        }
        this.parse(selector);
    }

    public static ComponentSelector $(String selector, Collection<Component> roots) {
        return new ComponentSelector(selector, roots);
    }

    public static ComponentSelector select(String selector, Collection<Component> roots) {
        return ComponentSelector.$(selector, roots);
    }

    public ComponentSelector(String selector, Collection<Component> roots) {
        this.roots.addAll(roots);
        this.parse(selector);
    }

    public ComponentSelector find(String selector) {
        return new ComponentSelector(selector, this.resultsImpl());
    }

    private void parse(String selector) {
        if ((selector = selector.trim()).indexOf(",") != -1) {
            String[] parts = Util.split(selector, ",");
            this.aggregateSelectors = new LinkedHashSet<ComponentSelector>();
            for (String part : parts) {
                if ((part = part.trim()).length() == 0) continue;
                this.aggregateSelectors.add(new ComponentSelector(part, this.roots));
            }
            return;
        }
        String[] parts = Util.split(selector, " ");
        int len = parts.length;
        if (len > 1) {
            StringBuilder parentSelector = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (">".equals(parts[i])) {
                    if (i < len - 1) {
                        parts[i] = ">" + parts[i + 1].trim();
                        for (int j = i + 1; j < len - 1; ++j) {
                            parts[j] = parts[j + 1];
                        }
                        parts[--len] = null;
                    } else {
                        throw new IllegalArgumentException("Failed to parse selector.  Selector cannot end with '>'");
                    }
                }
                if (i > 0 && i < len - 1) {
                    parentSelector.append(" ");
                }
                if (i < len - 1) {
                    parentSelector.append(parts[i]);
                }
                if (i != len - 1) continue;
                selector = parts[i];
            }
            if (parentSelector.length() > 0) {
                this.parent = new ComponentSelector(parentSelector.toString(), this.roots);
                this.roots.clear();
            }
        }
        if (selector.indexOf(">") == 0) {
            this.childrenOnly = true;
            selector = selector.substring(1).trim();
        }
        if (selector.indexOf(",") != -1) {
            throw new IllegalArgumentException("Invalid character in selector " + selector);
        }
        ComponentSelector out = this;
        int pos = (selector = selector.trim()).indexOf(":");
        if (pos != -1) {
            out.state = selector.substring(pos + 1);
            selector = selector.substring(0, pos);
        }
        if ((pos = selector.indexOf(".")) != -1) {
            out.tags = Util.split(selector.substring(pos + 1), ".");
            len = out.tags.length;
            String[] needles = out.tagsNeedles = new String[len];
            String[] tags = out.tags;
            for (int i = 0; i < len; ++i) {
                needles[i] = " " + tags[i] + " ";
            }
            selector = selector.substring(0, pos);
        }
        if ((pos = selector.indexOf("#")) >= 0) {
            out.name = selector.substring(pos + 1);
            selector = selector.substring(0, pos);
        }
        if (selector.length() > 0 && !"*".equals(selector)) {
            out.uiid = selector;
        }
        if (this.state != null) {
            if ("pressed".equals(this.state)) {
                this.currentStyleType = 2;
            } else if ("selected".equals(this.state)) {
                this.currentStyleType = 3;
            } else if ("unselected".equals(this.state)) {
                this.currentStyleType = 4;
            } else if ("disabled".equals(this.state)) {
                this.currentStyleType = 5;
            } else if ("all".equals(this.state) || "*".equals(this.state)) {
                this.currentStyleType = 1;
            }
        }
    }

    private boolean match(Component c) {
        if (this.name != null && !this.name.equals(c.getName())) {
            return false;
        }
        if (this.uiid != null && !this.uiid.equals(c.getUIID())) {
            return false;
        }
        if (this.tags != null) {
            String ctags = (String)c.getClientProperty(PROPERTY_TAG);
            if (ctags != null) {
                for (String ctag : this.tagsNeedles) {
                    if (ctags.indexOf(ctag) != -1) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<Component> iterator() {
        return this.resultsImpl().iterator();
    }

    private Set<Component> resultsImpl() {
        if (this.results == null) {
            this.results = new LinkedHashSet<Component>();
            if (this.aggregateSelectors != null) {
                for (ComponentSelector sel : this.aggregateSelectors) {
                    this.results.addAll(sel.resultsImpl());
                }
                return this.results;
            }
            if (this.parent != null) {
                this.roots.clear();
                this.roots.addAll(this.parent.resultsImpl());
            }
            for (Component root : this.roots) {
                Container cnt;
                if (this.childrenOnly) {
                    if (!(root instanceof Container)) continue;
                    cnt = (Container)root;
                    for (Component child : cnt) {
                        if (!this.match(child)) continue;
                        this.results.add(child);
                    }
                    continue;
                }
                if (!(root instanceof Container)) continue;
                cnt = (Container)root;
                for (Component child : cnt) {
                    this.resultsImpl(this.results, child);
                }
            }
        }
        return this.results;
    }

    private Set<Component> resultsImpl(Set<Component> out, Component root) {
        if (this.match(root)) {
            out.add(root);
        }
        if (root instanceof Container) {
            Container cnt = (Container)root;
            for (Component child : cnt) {
                this.resultsImpl(out, child);
            }
        }
        return out;
    }

    public Style getStyle() {
        HashSet<Style> out = new HashSet<Style>();
        for (Component c : this) {
            out.add(c.getStyle());
        }
        return Style.createProxyStyle(out.toArray(new Style[out.size()]));
    }

    public Style getStyle(Component component) {
        switch (this.currentStyleType) {
            case 3: {
                return component.getSelectedStyle();
            }
            case 4: {
                return component.getUnselectedStyle();
            }
            case 5: {
                return component.getDisabledStyle();
            }
            case 2: {
                return component.getPressedStyle();
            }
            case 1: {
                return component.getAllStyles();
            }
        }
        return component.getStyle();
    }

    public Style getSelectedStyle() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Component c : this) {
            styles.add(c.getSelectedStyle());
        }
        return Style.createProxyStyle(styles.toArray(new Style[styles.size()]));
    }

    public ComponentSelector selectSelectedStyle() {
        this.currentStyle = this.getSelectedStyle();
        this.currentStyleType = 3;
        return this;
    }

    public ComponentSelector selectUnselectedStyle() {
        this.currentStyle = this.getUnselectedStyle();
        this.currentStyleType = 4;
        return this;
    }

    public ComponentSelector selectPressedStyle() {
        this.currentStyle = this.getPressedStyle();
        this.currentStyleType = 2;
        return this;
    }

    public ComponentSelector selectDisabledStyle() {
        this.currentStyle = this.getDisabledStyle();
        this.currentStyleType = 5;
        return this;
    }

    public ComponentSelector selectAllStyles() {
        this.currentStyle = this.getAllStyles();
        this.currentStyleType = 1;
        return this;
    }

    public Style getUnselectedStyle() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Component c : this) {
            styles.add(c.getUnselectedStyle());
        }
        return Style.createProxyStyle(styles.toArray(new Style[styles.size()]));
    }

    public Style getPressedStyle() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Component c : this) {
            styles.add(c.getPressedStyle());
        }
        return Style.createProxyStyle(styles.toArray(new Style[styles.size()]));
    }

    public Style getDisabledStyle() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Component c : this) {
            styles.add(c.getDisabledStyle());
        }
        return Style.createProxyStyle(styles.toArray(new Style[styles.size()]));
    }

    public Style getAllStyles() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Component c : this) {
            styles.add(c.getAllStyles());
        }
        return Style.createProxyStyle(styles.toArray(new Style[styles.size()]));
    }

    @Override
    public int size() {
        return this.resultsImpl().size();
    }

    @Override
    public boolean isEmpty() {
        return this.resultsImpl().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.resultsImpl().contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.resultsImpl().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.resultsImpl().toArray(a);
    }

    @Override
    public boolean add(Component e) {
        this.setDirty();
        return this.resultsImpl().add(e);
    }

    public ComponentSelector append(Component child) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.add(child);
            return this;
        }
        return this;
    }

    public ComponentSelector append(Object constraint, Component child) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.add(constraint, child);
            return this;
        }
        return this;
    }

    public ComponentSelector append(ComponentMapper mapper) {
        for (Component c : this) {
            Component child;
            if (!(c instanceof Container) || (child = mapper.map(c)) == null) continue;
            ((Container)c).add(child);
        }
        return this;
    }

    public ComponentSelector append(Object constraint, ComponentMapper mapper) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Component child = mapper.map(c);
            ((Container)c).add(constraint, child);
        }
        return this;
    }

    public ComponentSelector add(Component e, boolean chain) {
        this.add(e);
        return this;
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        return this.resultsImpl().remove(o);
    }

    public ComponentSelector remove(Object o, boolean chain) {
        this.remove(o);
        return this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.resultsImpl().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Component> c) {
        this.setDirty();
        return this.resultsImpl().addAll(c);
    }

    public ComponentSelector addAll(Collection<? extends Component> c, boolean chain) {
        this.addAll(c);
        return this;
    }

    public Component asComponent() {
        Iterator<Component> iterator = this.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c;
        }
        return null;
    }

    public <T extends Component> T asComponent(Class<T> type) {
        return (T)this.asComponent();
    }

    public List<Component> asList() {
        ArrayList<Component> out = new ArrayList<Component>();
        out.addAll(this);
        return out;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.setDirty();
        return this.resultsImpl().retainAll(c);
    }

    public ComponentSelector retainAll(Collection<?> c, boolean chain) {
        this.retainAll(c);
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.setDirty();
        return this.resultsImpl().removeAll(c);
    }

    public ComponentSelector removeAll(Collection<?> c, boolean chain) {
        this.removeAll(c);
        return this;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.resultsImpl().clear();
    }

    public ComponentSelector clear(boolean chain) {
        this.clear();
        return this;
    }

    public String toString() {
        return "ComponentSelector{ name=" + this.name + ", uiid=" + this.uiid + ", tags=" + Arrays.toString(this.tags) + ", roots=" + this.roots + ", parent=" + this.parent + ", results = " + this.results + "}";
    }

    public ComponentSelector addTags(String ... tags) {
        for (Component c : this) {
            String existing = (String)c.getClientProperty(PROPERTY_TAG);
            if (existing == null) {
                existing = "";
            }
            for (String tag : tags) {
                if (existing.indexOf(" " + tag + " ") != -1) continue;
                existing = existing + " " + tag + " ";
            }
            c.putClientProperty(PROPERTY_TAG, existing);
        }
        return this;
    }

    public ComponentSelector removeTags(String ... tags) {
        for (Component c : this) {
            String existing = (String)c.getClientProperty(PROPERTY_TAG);
            if (existing == null) continue;
            HashSet<String> existingSet = new HashSet<String>();
            String[] existingStrs = Util.split(" ", existing);
            for (String existingStr : existingStrs) {
                if ((existingStr = existingStr.trim()).length() <= 0) continue;
                existingSet.add(existingStr);
            }
            for (String tag : tags) {
                existingSet.add(tag);
            }
            existing = "";
            if (existingSet.isEmpty()) {
                c.putClientProperty(PROPERTY_TAG, null);
                continue;
            }
            for (String tag : existingSet) {
                existing = existing + " " + tag + " ";
            }
            c.putClientProperty(PROPERTY_TAG, existing);
        }
        return this;
    }

    public ComponentSelector getParent() {
        HashSet<Component> parents = new HashSet<Component>();
        for (Component c : this) {
            Container parent = c.getParent();
            if (parent == null) continue;
            parents.add(parent);
        }
        return new ComponentSelector(parents);
    }

    public ComponentSelector setSameWidth() {
        Component.setSameWidth(this.toArray(new Component[this.size()]));
        return this;
    }

    public ComponentSelector setSameHeight() {
        Component.setSameHeight(this.toArray(new Component[this.size()]));
        return this;
    }

    public ComponentSelector clearClientProperties() {
        for (Component c : this) {
            c.clearClientProperties();
        }
        return this;
    }

    public ComponentSelector putClientProperty(String key, Object value) {
        for (Component c : this) {
            c.putClientProperty(key, value);
        }
        return this;
    }

    public Object getClientProperty(String key) {
        Iterator<Component> iterator = this.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c.getClientProperty(key);
        }
        return null;
    }

    public ComponentSelector setDirtyRegion(Rectangle rect) {
        for (Component c : this) {
            c.setDirtyRegion(rect);
        }
        return this;
    }

    public ComponentSelector setVisible(boolean visible) {
        for (Component c : this) {
            c.setVisible(visible);
        }
        return this;
    }

    public ComponentSelector setX(int x) {
        for (Component c : this) {
            c.setX(x);
        }
        return this;
    }

    public ComponentSelector setY(int y) {
        for (Component c : this) {
            c.setY(y);
        }
        return this;
    }

    public ComponentSelector setWidth(int width) {
        for (Component c : this) {
            c.setWidth(width);
        }
        return this;
    }

    public ComponentSelector setHeight(int height) {
        for (Component c : this) {
            c.setHeight(height);
        }
        return this;
    }

    public ComponentSelector setPreferredSize(Dimension dim) {
        for (Component c : this) {
            c.setPreferredSize(dim);
        }
        return this;
    }

    public ComponentSelector setPreferredH(int h) {
        for (Component c : this) {
            c.setPreferredH(h);
        }
        return this;
    }

    public ComponentSelector setPreferredW(int w) {
        for (Component c : this) {
            c.setPreferredW(w);
        }
        return this;
    }

    public ComponentSelector setScrollSize(Dimension size) {
        for (Component c : this) {
            c.setScrollSize(size);
        }
        return this;
    }

    public ComponentSelector setSize(Dimension size) {
        for (Component c : this) {
            c.setSize(size);
        }
        return this;
    }

    public ComponentSelector setUIID(String uiid) {
        for (Component c : this) {
            c.setUIID(uiid);
        }
        return this;
    }

    public ComponentSelector remove() {
        for (Component c : this) {
            c.remove();
        }
        return this;
    }

    public ComponentSelector addFocusListener(FocusListener l) {
        for (Component c : this) {
            c.addFocusListener(l);
        }
        return this;
    }

    public ComponentSelector removeFocusListener(FocusListener l) {
        for (Component c : this) {
            c.removeFocusListener(l);
        }
        return this;
    }

    public ComponentSelector addScrollListener(ScrollListener l) {
        for (Component c : this) {
            c.addScrollListener(l);
        }
        return this;
    }

    public ComponentSelector removeScrollListener(ScrollListener l) {
        for (Component c : this) {
            c.removeScrollListener(l);
        }
        return this;
    }

    public ComponentSelector setSelectCommandText(String text) {
        for (Component c : this) {
            c.setSelectCommandText(text);
        }
        return this;
    }

    public ComponentSelector setLabelForComponent(Label l) {
        for (Component c : this) {
            c.setLabelForComponent(l);
        }
        return this;
    }

    public ComponentSelector paintBackgrounds(Graphics g) {
        for (Component c : this) {
            c.paintBackgrounds(g);
        }
        return this;
    }

    public ComponentSelector paintComponent(Graphics g) {
        for (Component c : this) {
            c.paintComponent(g);
        }
        return this;
    }

    public ComponentSelector paint(Graphics g) {
        for (Component c : this) {
            c.paint(g);
        }
        return this;
    }

    public boolean contains(int x, int y) {
        for (Component c : this) {
            if (!c.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public ComponentSelector setFocusable(boolean focus) {
        for (Component c : this) {
            c.setFocusable(focus);
        }
        return this;
    }

    public ComponentSelector repaint() {
        for (Component c : this) {
            c.repaint();
        }
        return this;
    }

    public ComponentSelector repaint(int x, int y, int w, int h) {
        for (Component c : this) {
            c.repaint(x, y, w, h);
        }
        return this;
    }

    public ComponentSelector setScrollAnimationSpeed(int speed) {
        for (Component c : this) {
            c.setScrollAnimationSpeed(speed);
        }
        return this;
    }

    public ComponentSelector setSmoothScrolling(boolean smooth) {
        for (Component c : this) {
            c.setSmoothScrolling(smooth);
        }
        return this;
    }

    public ComponentSelector addDropListener(ActionListener l) {
        for (Component c : this) {
            c.addDropListener(l);
        }
        return this;
    }

    public ComponentSelector removeDropListener(ActionListener l) {
        for (Component c : this) {
            c.removeDropListener(l);
        }
        return this;
    }

    public ComponentSelector addDragOverListener(ActionListener l) {
        for (Component c : this) {
            c.addDragOverListener(l);
        }
        return this;
    }

    public ComponentSelector removeDragOverListener(ActionListener l) {
        for (Component c : this) {
            c.removeDragOverListener(l);
        }
        return this;
    }

    public ComponentSelector addPointerPressedListener(ActionListener l) {
        for (Component c : this) {
            c.addPointerPressedListener(l);
        }
        return this;
    }

    public ComponentSelector addLongPressListener(ActionListener l) {
        for (Component c : this) {
            c.addLongPressListener(l);
        }
        return this;
    }

    public ComponentSelector removePointerPressedListener(ActionListener l) {
        for (Component c : this) {
            c.removePointerPressedListener(l);
        }
        return this;
    }

    public ComponentSelector removeLongPressListener(ActionListener l) {
        for (Component c : this) {
            c.removeLongPressListener(l);
        }
        return this;
    }

    public ComponentSelector addPointerReleasedListener(ActionListener l) {
        for (Component c : this) {
            c.addPointerReleasedListener(l);
        }
        return this;
    }

    public ComponentSelector removePointerReleasedListener(ActionListener l) {
        for (Component c : this) {
            c.removePointerReleasedListener(l);
        }
        return this;
    }

    public ComponentSelector addPointerDraggedListener(ActionListener l) {
        for (Component c : this) {
            c.addPointerDraggedListener(l);
        }
        return this;
    }

    public ComponentSelector removePointerDraggedListener(ActionListener l) {
        for (Component c : this) {
            c.removePointerDraggedListener(l);
        }
        return this;
    }

    public ComponentSelector setPressedStyle(Style style) {
        for (Component c : this) {
            c.setPressedStyle(style);
        }
        return this;
    }

    public ComponentSelector setSelectedStyle(Style style) {
        for (Component c : this) {
            c.setSelectedStyle(style);
        }
        return this;
    }

    public ComponentSelector setDisabledStyle(Style style) {
        for (Component c : this) {
            c.setDisabledStyle(style);
        }
        return this;
    }

    public ComponentSelector setUnselectedStyle(Style style) {
        for (Component c : this) {
            c.setUnselectedStyle(style);
        }
        return this;
    }

    public ComponentSelector requestFocus() {
        Iterator<Component> iterator = this.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            c.requestFocus();
            return this;
        }
        return this;
    }

    public ComponentSelector refreshTheme() {
        for (Component c : this) {
            c.refreshTheme();
        }
        return this;
    }

    public ComponentSelector refreshTheme(boolean merge) {
        for (Component c : this) {
            c.refreshTheme(merge);
        }
        return this;
    }

    public ComponentSelector setCellRenderer(boolean cell) {
        for (Component c : this) {
            c.setCellRenderer(cell);
        }
        return this;
    }

    public ComponentSelector setScrollVisible(boolean vis) {
        for (Component c : this) {
            c.setScrollVisible(vis);
        }
        return this;
    }

    public ComponentSelector setEnabled(boolean enabled) {
        for (Component c : this) {
            c.setEnabled(enabled);
        }
        return this;
    }

    public ComponentSelector setName(String name) {
        for (Component c : this) {
            c.setName(name);
        }
        return this;
    }

    public ComponentSelector setRTL(boolean rtl) {
        for (Component c : this) {
            c.setRTL(rtl);
        }
        return this;
    }

    public ComponentSelector setTactileTouch(boolean t) {
        for (Component c : this) {
            c.setTactileTouch(t);
        }
        return this;
    }

    public ComponentSelector setPropertyValue(String key, Object value) {
        for (Component c : this) {
            c.setPropertyValue(key, value);
        }
        return this;
    }

    public ComponentSelector paintLockRelease() {
        for (Component c : this) {
            c.paintLockRelease();
        }
        return this;
    }

    public ComponentSelector setSnapToGrid(boolean s) {
        for (Component c : this) {
            c.setSnapToGrid(s);
        }
        return this;
    }

    public ComponentSelector setIgnorePointerEvents(boolean ignore) {
        for (Component c : this) {
            c.setIgnorePointerEvents(ignore);
        }
        return this;
    }

    public boolean isIgnorePointerEvents() {
        Iterator<Component> iterator = this.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c.isIgnorePointerEvents();
        }
        return false;
    }

    public ComponentSelector setFlatten(boolean f) {
        for (Component c : this) {
            c.setFlatten(f);
        }
        return this;
    }

    public ComponentSelector setTensileLength(int len) {
        for (Component c : this) {
            c.setTensileLength(len);
        }
        return this;
    }

    public ComponentSelector setGrabsPointerEvents(boolean g) {
        for (Component c : this) {
            c.setGrabsPointerEvents(g);
        }
        return this;
    }

    public ComponentSelector setScrollOpacityChangeSpeed(int scrollOpacityChangeSpeed) {
        for (Component c : this) {
            c.setScrollOpacityChangeSpeed(scrollOpacityChangeSpeed);
        }
        return this;
    }

    public ComponentSelector growShrink(int duration) {
        for (Component c : this) {
            c.growShrink(duration);
        }
        return this;
    }

    public ComponentSelector setDraggable(boolean draggable) {
        for (Component c : this) {
            c.setDraggable(draggable);
        }
        return this;
    }

    public ComponentSelector setDropTarget(boolean target) {
        for (Component c : this) {
            c.setDropTarget(target);
        }
        return this;
    }

    public ComponentSelector setHideInPortait(boolean hide) {
        for (Component c : this) {
            c.setHideInPortrait(hide);
        }
        return this;
    }

    public ComponentSelector setHidden(boolean b, boolean changeMargin) {
        for (Component c : this) {
            c.setHidden(b, changeMargin);
        }
        return this;
    }

    public ComponentSelector setHidden(boolean b) {
        for (Component c : this) {
            c.setHidden(b);
        }
        return this;
    }

    public ComponentSelector setComponentState(Object state) {
        for (Component c : this) {
            c.setComponentState(state);
        }
        return this;
    }

    public ComponentSelector setLeadComponent(Component lead) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.setLeadComponent(lead);
        }
        return this;
    }

    public ComponentSelector setLayout(Layout layout) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.setLayout(layout);
        }
        return this;
    }

    public ComponentSelector invalidate() {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.invalidate();
        }
        return this;
    }

    public ComponentSelector setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.setShouldCalcPreferredSize(shouldCalcPreferredSize);
        }
        return this;
    }

    public ComponentSelector applyRTL(boolean rtl) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            Container cnt = (Container)c;
            cnt.applyRTL(rtl);
        }
        return this;
    }

    public ComponentSelector removeAll() {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).removeAll();
        }
        return this;
    }

    public ComponentSelector revalidate() {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).revalidate();
        }
        return this;
    }

    public ComponentSelector forceRevalidate() {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).forceRevalidate();
        }
        return this;
    }

    public ComponentSelector layoutContainer() {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).layoutContainer();
        }
        return this;
    }

    public ComponentSelector getComponentAt(int index) {
        HashSet<Component> out = new HashSet<Component>();
        for (Component c : this) {
            Container cnt;
            if (!(c instanceof Container) || (cnt = (Container)c).getComponentCount() <= index) continue;
            out.add(cnt.getComponentAt(index));
        }
        return new ComponentSelector(out);
    }

    public boolean containsInSubtree(Component cmp) {
        for (Component c : this) {
            if (!(c instanceof Container) || !((Container)c).contains(cmp)) continue;
            return true;
        }
        return false;
    }

    public ComponentSelector scrollComponentToVisible(Component cmp) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).scrollComponentToVisible(cmp);
        }
        return this;
    }

    public ComponentSelector getComponentAt(int x, int y) {
        HashSet<Component> out = new HashSet<Component>();
        for (Component c : this) {
            Component match;
            if (!(c instanceof Container) || (match = ((Container)c).getComponentAt(x, y)) == null) continue;
            out.add(match);
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector setScrollableX(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).setScrollableX(b);
        }
        return this;
    }

    public ComponentSelector setScrollableY(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).setScrollableY(b);
        }
        return this;
    }

    public ComponentSelector setScrollIncrement(int b) {
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            ((Container)c).setScrollIncrement(b);
        }
        return this;
    }

    public ComponentSelector findFirstFocusable() {
        HashSet<Component> out = new HashSet<Component>();
        for (Component c : this) {
            Component match;
            if (!(c instanceof Container) || (match = ((Container)c).findFirstFocusable()) == null) continue;
            out.add(match);
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector animateHierarchyAndWait(int duration) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateHierarchy(duration));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return this;
    }

    public ComponentSelector animateHierarchy(int duration) {
        return this.animateHierarchy(duration, null);
    }

    public ComponentSelector animateHierarchy(int duration, final SuccessCallback<ComponentSelector> callback) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateHierarchy(duration));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])), new Runnable(){

                public void run() {
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector animateHierarchyFadeAndWait(int duration, int startingOpacity) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateHierarchyFade(duration, startingOpacity));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return this;
    }

    public ComponentSelector animateHierarchyFade(int duration, int startingOpacity) {
        return this.animateHierarchyFade(duration, startingOpacity, null);
    }

    public ComponentSelector animateHierarchyFade(int duration, int startingOpacity, final SuccessCallback<ComponentSelector> callback) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateHierarchyFade(duration, startingOpacity));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])), new Runnable(){

                public void run() {
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector animateLayoutFadeAndWait(int duration, int startingOpacity) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateLayoutFade(duration, startingOpacity));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return this;
    }

    public ComponentSelector animateLayoutFade(int duration, int startingOpacity) {
        return this.animateLayoutFade(duration, startingOpacity, null);
    }

    public ComponentSelector animateLayoutFade(int duration, int startingOpacity, final SuccessCallback<ComponentSelector> callback) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateLayoutFade(duration, startingOpacity));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])), new Runnable(){

                public void run() {
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector animateLayout(int duration) {
        return this.animateLayout(duration, null);
    }

    public ComponentSelector animateLayout(int duration, final SuccessCallback<ComponentSelector> callback) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateLayout(duration));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])), new Runnable(){

                public void run() {
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector animateLayoutAndWait(int duration) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateLayout(duration));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return this;
    }

    public ComponentSelector animateUnlayout(int duration, int opacity) {
        return this.animateUnlayout(duration, opacity, null);
    }

    public ComponentSelector animateUnlayout(int duration, int opacity, final SuccessCallback<ComponentSelector> callback) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateUnlayout(duration, opacity, null));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimation(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])), new Runnable(){

                public void run() {
                    if (callback != null) {
                        callback.onSucess(ComponentSelector.this);
                    }
                }
            });
        }
        return this;
    }

    public ComponentSelector animateUnlayoutAndWait(int duration, int opacity) {
        ArrayList<ComponentAnimation> animations = new ArrayList<ComponentAnimation>();
        for (Component c : this) {
            if (!(c instanceof Container)) continue;
            animations.add(((Container)c).createAnimateUnlayout(duration, opacity, null));
        }
        AnimationManager mgr = this.getAnimationManager();
        if (animations.size() > 0 && mgr != null) {
            mgr.addAnimationAndBlock(ComponentAnimation.compoundAnimation(animations.toArray(new ComponentAnimation[animations.size()])));
        }
        return this;
    }

    public AnimationManager getAnimationManager() {
        for (Component c : this) {
            AnimationManager mgr = c.getAnimationManager();
            if (mgr == null) continue;
            return mgr;
        }
        return null;
    }

    public ComponentSelector setText(String text) {
        for (Component c : this) {
            if (c instanceof Label) {
                ((Label)c).setText(text);
                continue;
            }
            if (c instanceof TextArea) {
                ((TextArea)c).setText(text);
                continue;
            }
            if (c instanceof SpanLabel) {
                ((SpanLabel)c).setText(text);
                continue;
            }
            if (!(c instanceof SpanButton)) continue;
            ((SpanButton)c).setText(text);
        }
        return this;
    }

    public String getText() {
        for (Component c : this) {
            if (c instanceof Label) {
                return ((Label)c).getText();
            }
            if (c instanceof TextArea) {
                return ((TextArea)c).getText();
            }
            if (c instanceof SpanLabel) {
                return ((SpanLabel)c).getText();
            }
            if (!(c instanceof SpanButton)) continue;
            return ((SpanButton)c).getText();
        }
        return null;
    }

    public ComponentSelector setIcon(Image icon) {
        for (Component c : this) {
            if (!(c instanceof IconHolder)) continue;
            ((IconHolder)((Object)c)).setIcon(icon);
        }
        return this;
    }

    public ComponentSelector setIcon(char materialIcon, Style style, float size) {
        FontImage img = FontImage.createMaterial(materialIcon, style, size);
        return this.setIcon(img);
    }

    public ComponentSelector setIcon(char materialIcon, float size) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            Label l = (Label)c;
            Style style = new Style();
            Style cStyle = c.getUnselectedStyle();
            style.setBgTransparency(0);
            style.setFgColor(cStyle.getFgColor());
            l.setIcon(FontImage.createMaterial(materialIcon, style, size));
            if (!(c instanceof Button)) continue;
            Button b = (Button)c;
            style = new Style();
            cStyle = c.getPressedStyle();
            style.setBgTransparency(0);
            style.setFgColor(cStyle.getFgColor());
            b.setPressedIcon(FontImage.createMaterial(materialIcon, style, size));
        }
        return this;
    }

    public ComponentSelector setIcon(char materialIcon) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            Label l = (Label)c;
            Style style = new Style();
            Style cStyle = c.getUnselectedStyle();
            style.setBgTransparency(0);
            style.setFgColor(cStyle.getFgColor());
            l.setIcon(FontImage.createMaterial(materialIcon, style, 3.0f));
            if (!(c instanceof Button)) continue;
            Button b = (Button)c;
            style = new Style();
            cStyle = c.getPressedStyle();
            style.setBgTransparency(0);
            style.setFgColor(cStyle.getFgColor());
            b.setPressedIcon(FontImage.createMaterial(materialIcon, style, 3.0f));
        }
        return this;
    }

    public ComponentSelector getComponentForm() {
        HashSet<Component> out = new HashSet<Component>();
        for (Component c : this) {
            out.add(c.getComponentForm());
        }
        return new ComponentSelector(out);
    }

    public ComponentSelector setVerticalAlignment(int valign) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setVerticalAlignment(valign);
        }
        return this;
    }

    public ComponentSelector setTextPosition(int pos) {
        for (Component c : this) {
            if (!(c instanceof IconHolder)) continue;
            ((IconHolder)((Object)c)).setTextPosition(pos);
        }
        return this;
    }

    public ComponentSelector setIconUIID(String uiid) {
        for (Component c : this) {
            if (!(c instanceof IconHolder)) continue;
            ((IconHolder)((Object)c)).setIconUIID(uiid);
        }
        return this;
    }

    public ComponentSelector setGap(int gap) {
        for (Component c : this) {
            if (!(c instanceof IconHolder)) continue;
            ((IconHolder)((Object)c)).setGap(gap);
        }
        return this;
    }

    public ComponentSelector setShiftText(int shift) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setShiftText(shift);
        }
        return this;
    }

    public ComponentSelector startTicker(long delay, boolean rightToLeft) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).startTicker(delay, rightToLeft);
        }
        return this;
    }

    public ComponentSelector stopTicker() {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).stopTicker();
        }
        return this;
    }

    public ComponentSelector setTickerEnabled(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setTickerEnabled(b);
        }
        return this;
    }

    public ComponentSelector setEndsWith3Points(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setEndsWith3Points(b);
        }
        return this;
    }

    public ComponentSelector setMask(Object mask) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setMask(mask);
        }
        return this;
    }

    public ComponentSelector setMaskName(String name) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setMaskName(name);
        }
        return this;
    }

    public ComponentSelector setShouldLocalize(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setShouldLocalize(b);
        }
        return this;
    }

    public ComponentSelector setShiftMillimeters(int b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setShiftMillimeters(b);
        }
        return this;
    }

    public ComponentSelector setShowEvenIfBlank(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setShowEvenIfBlank(b);
        }
        return this;
    }

    public ComponentSelector setLegacyRenderer(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setLegacyRenderer(b);
        }
        return this;
    }

    public ComponentSelector setAutoSizeMode(boolean b) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            ((Label)c).setAutoSizeMode(b);
        }
        return this;
    }

    public ComponentSelector setCommand(Command cmd) {
        for (Component c : this) {
            if (!(c instanceof Button)) continue;
            ((Button)c).setCommand(cmd);
        }
        return this;
    }

    public ComponentSelector setRolloverPressedIcon(Image icon) {
        for (Component c : this) {
            if (!(c instanceof Button)) continue;
            ((Button)c).setRolloverPressedIcon(icon);
        }
        return this;
    }

    public ComponentSelector setRolloverIcon(Image icon) {
        for (Component c : this) {
            if (!(c instanceof Button)) continue;
            ((Button)c).setRolloverIcon(icon);
        }
        return this;
    }

    public ComponentSelector setPressedIcon(Image icon) {
        for (Component c : this) {
            if (!(c instanceof Button)) continue;
            ((Button)c).setPressedIcon(icon);
        }
        return this;
    }

    public ComponentSelector setDisabledIcon(Image icon) {
        for (Component c : this) {
            if (!(c instanceof Button)) continue;
            ((Button)c).setDisabledIcon(icon);
        }
        return this;
    }

    public ComponentSelector addActionListener(ActionListener l) {
        for (Component c : this) {
            if (!(c instanceof ActionSource)) continue;
            ((ActionSource)((Object)c)).addActionListener(l);
        }
        return this;
    }

    public ComponentSelector removeActionListener(ActionListener l) {
        for (Component c : this) {
            if (!(c instanceof ActionSource)) continue;
            ((ActionSource)((Object)c)).removeActionListener(l);
        }
        return this;
    }

    public ComponentSelector setEditable(boolean b) {
        for (Component c : this) {
            if (!(c instanceof TextArea)) continue;
            ((TextArea)c).setEditable(b);
        }
        return this;
    }

    public ComponentSelector addDataChangedListener(DataChangedListener l) {
        for (Component c : this) {
            if (!(c instanceof TextField)) continue;
            ((TextField)c).addDataChangedListener(l);
        }
        return this;
    }

    public ComponentSelector removeDataChangedListener(DataChangedListener l) {
        for (Component c : this) {
            if (!(c instanceof TextField)) continue;
            ((TextField)c).removeDataChangedListener(l);
        }
        return this;
    }

    public ComponentSelector setDoneListener(ActionListener l) {
        for (Component c : this) {
            if (!(c instanceof TextField)) continue;
            ((TextField)c).setDoneListener(l);
        }
        return this;
    }

    private static int dip2px(float dips) {
        return Display.getInstance().convertToPixels(dips);
    }

    public ComponentSelector setPadding(int padding) {
        return this.setPadding(padding, padding, padding, padding);
    }

    public ComponentSelector stripMarginAndPadding() {
        Style s = this.currentStyle();
        s.stripMarginAndPadding();
        return this;
    }

    public ComponentSelector setPadding(int top, int right, int bottom, int left) {
        Style s = this.currentStyle();
        s.setPaddingUnit(0, 0, 0, 0);
        s.setPadding(top, bottom, left, right);
        return this;
    }

    public ComponentSelector setPaddingMillimeters(float top, float right, float bottom, float left) {
        return this.setPadding(ComponentSelector.dip2px(top), ComponentSelector.dip2px(right), ComponentSelector.dip2px(bottom), ComponentSelector.dip2px(left));
    }

    public ComponentSelector setPaddingMillimeters(float topBottom, float leftRight) {
        return this.setPaddingMillimeters(topBottom, leftRight, topBottom, leftRight);
    }

    public ComponentSelector setPaddingMillimeters(float padding) {
        return this.setPaddingMillimeters(padding, padding);
    }

    public ComponentSelector setPadding(int topBottom, int leftRight) {
        return this.setPadding(topBottom, leftRight, topBottom, leftRight);
    }

    private int percentHeight(double percentage, Component parent) {
        return (int)Math.round((double)parent.getHeight() * percentage / 100.0);
    }

    private int percentWidth(double percentage, Component parent) {
        return (int)Math.round((double)parent.getWidth() * percentage / 100.0);
    }

    public ComponentSelector setPaddingPercent(double padding) {
        return this.setPaddingPercent(padding, padding, padding, padding);
    }

    public ComponentSelector setPaddingPercent(double topBottom, double leftRight) {
        return this.setPaddingPercent(topBottom, leftRight, topBottom, leftRight);
    }

    public ComponentSelector setPaddingPercent(double top, double right, double bottom, double left) {
        for (Component c : this) {
            Container parent = c.getParent();
            if (parent == null) continue;
            Style s = this.getStyle(c);
            s.setPaddingUnit(0, 0, 0, 0);
            s.setPadding(this.percentHeight(top, parent), this.percentHeight(bottom, parent), this.percentWidth(left, parent), this.percentWidth(right, parent));
        }
        return this;
    }

    public ComponentSelector setMargin(int margin) {
        return this.setMargin(margin, margin, margin, margin);
    }

    public ComponentSelector setMargin(int top, int right, int bottom, int left) {
        Style s = this.currentStyle();
        s.setMarginUnit(0, 0, 0, 0);
        s.setMargin(top, bottom, left, right);
        return this;
    }

    public ComponentSelector setMargin(int topBottom, int leftRight) {
        return this.setMargin(topBottom, leftRight, topBottom, leftRight);
    }

    public ComponentSelector setMarginPercent(double margin) {
        return this.setMarginPercent(margin, margin, margin, margin);
    }

    public ComponentSelector setMarginPercent(double topBottom, double leftRight) {
        return this.setMarginPercent(topBottom, leftRight, topBottom, leftRight);
    }

    public ComponentSelector setMarginPercent(double top, double right, double bottom, double left) {
        for (Component c : this) {
            Container parent = c.getParent();
            if (parent == null) continue;
            Style s = this.getStyle(c);
            s.setMarginUnit(0, 0, 0, 0);
            s.setMargin(this.percentHeight(top, parent), this.percentHeight(bottom, parent), this.percentWidth(left, parent), this.percentWidth(right, parent));
        }
        return this;
    }

    public ComponentSelector setMarginMillimeters(float top, float right, float bottom, float left) {
        return this.setMargin(ComponentSelector.dip2px(top), ComponentSelector.dip2px(right), ComponentSelector.dip2px(bottom), ComponentSelector.dip2px(left));
    }

    public ComponentSelector setMarginMillimeters(float topBottom, float leftRight) {
        return this.setMarginMillimeters(topBottom, leftRight, topBottom, leftRight);
    }

    public ComponentSelector setMarginMillimeters(float margin) {
        return this.setMarginMillimeters(margin, margin);
    }

    public Style createProxyStyle() {
        HashSet<Style> styles = new HashSet<Style>();
        for (Component c : this) {
            styles.add(this.getStyle(c));
        }
        return Style.createProxyStyle(styles.toArray(new Style[styles.size()]));
    }

    public ComponentSelector merge(Style style) {
        for (Component c : this) {
            this.getStyle(c).merge(style);
        }
        return this;
    }

    public ComponentSelector setBgColor(int bgColor) {
        this.currentStyle().setBgColor(bgColor);
        return this;
    }

    public ComponentSelector setAlignment(int alignment) {
        this.currentStyle().setAlignment(alignment);
        return this;
    }

    public ComponentSelector setBgImage(Image bgImage) {
        this.currentStyle().setBgImage(bgImage);
        return this;
    }

    public ComponentSelector setBackgroundType(byte backgroundType) {
        this.currentStyle().setBackgroundType(backgroundType);
        return this;
    }

    public ComponentSelector setBackgroundGradientStartColor(int startColor) {
        this.currentStyle().setBackgroundGradientStartColor(startColor);
        return this;
    }

    public ComponentSelector setBackgroundGradientEndColor(int endColor) {
        this.currentStyle().setBackgroundGradientEndColor(endColor);
        return this;
    }

    public ComponentSelector setBackgroundGradientRelativeX(float x) {
        this.currentStyle().setBackgroundGradientRelativeX(x);
        return this;
    }

    public ComponentSelector setBackgroundGradientRelativeY(float y) {
        this.currentStyle().setBackgroundGradientRelativeY(y);
        return this;
    }

    public ComponentSelector setBackgroundGradientRelativeSize(float size) {
        this.currentStyle().setBackgroundGradientRelativeSize(size);
        return this;
    }

    public ComponentSelector setFgColor(int color) {
        this.currentStyle().setFgColor(color);
        return this;
    }

    public ComponentSelector setFont(Font f) {
        this.currentStyle().setFont(f);
        return this;
    }

    public ComponentSelector setUnderline(boolean b) {
        this.currentStyle().setUnderline(b);
        return this;
    }

    public ComponentSelector set3DText(boolean t, boolean raised) {
        this.currentStyle().set3DText(t, raised);
        return this;
    }

    public ComponentSelector set3DTextNorth(boolean north) {
        this.currentStyle().set3DTextNorth(north);
        return this;
    }

    public ComponentSelector setOverline(boolean b) {
        this.currentStyle().setOverline(b);
        return this;
    }

    public ComponentSelector setStrikeThru(boolean b) {
        this.currentStyle().setStrikeThru(b);
        return this;
    }

    public ComponentSelector setTextDecoration(int textDecoration) {
        this.currentStyle().setTextDecoration(textDecoration);
        return this;
    }

    public ComponentSelector setBgTransparency(int bgTransparency) {
        this.currentStyle().setBgTransparency(bgTransparency);
        return this;
    }

    public ComponentSelector setOpacity(int opacity) {
        this.currentStyle().setOpacity(opacity);
        return this;
    }

    public ComponentSelector addStyleListener(StyleListener l) {
        this.currentStyle().addStyleListener(l);
        return this;
    }

    public ComponentSelector removeStyleListener(StyleListener l) {
        this.currentStyle().removeStyleListener(l);
        return this;
    }

    public ComponentSelector removeStyleListeners() {
        this.currentStyle().removeListeners();
        return this;
    }

    public ComponentSelector setBorder(Border b) {
        this.currentStyle().setBorder(b);
        return this;
    }

    public ComponentSelector setBgPainter(Painter bgPainter) {
        this.currentStyle().setBgPainter(bgPainter);
        return this;
    }

    private float getEffectiveFontSize(Component c) {
        Font f = c.getStyle().getFont();
        while (f == null && c != null) {
            if ((c = c.getParent()) == null) continue;
            f = c.getStyle().getFont();
        }
        if (f != null) {
            return f.getPixelSize();
        }
        return (float)Font.getDefaultFont().getHeight() * 1.6f;
    }

    public ComponentSelector setFontSize(float size) {
        for (Component c : this) {
            Style style = this.getStyle(c);
            Font curr = style.getFont();
            if (curr == null || !curr.isTTFNativeFont()) {
                curr = c.getStyle().getFont();
            }
            if (curr == null || !curr.isTTFNativeFont()) {
                for (Container parent = c.getParent(); !(parent == null || curr != null && curr.isTTFNativeFont()); parent = parent.getParent()) {
                    curr = parent.getStyle().getFont();
                }
            }
            if (curr == null || !curr.isTTFNativeFont()) {
                curr = Font.create("native:MainRegular");
            }
            if (curr == null || !curr.isTTFNativeFont()) continue;
            curr = curr.derive(size, 0);
            style.setFont(curr);
        }
        return this;
    }

    public ComponentSelector setMaterialIcon(char icon, float size) {
        for (Component c : this) {
            if (!(c instanceof Label)) continue;
            FontImage.setMaterialIcon((Label)c, icon, size);
        }
        return this;
    }

    public ComponentSelector setCursor(int cursor) {
        for (Component c : this) {
            c.setCursor(cursor);
        }
        return this;
    }

    public ComponentSelector setFontSizeMillimeters(float sizeMM) {
        return this.setFontSize(ComponentSelector.dip2px(sizeMM));
    }

    public ComponentSelector setFontSizePercent(double sizePercentage) {
        for (Component c : this) {
            Container parent = c.getParent();
            if (parent == null) continue;
            float size = (float)((double)this.getEffectiveFontSize(parent) * sizePercentage / 100.0);
            Style style = this.getStyle(c);
            Font curr = style.getFont();
            if (curr == null || !curr.isTTFNativeFont()) {
                curr = c.getStyle().getFont();
            }
            if (curr == null || !curr.isTTFNativeFont()) {
                for (parent = c.getParent(); !(parent == null || curr != null && curr.isTTFNativeFont()); parent = parent.getParent()) {
                    curr = parent.getStyle().getFont();
                }
            }
            if (curr == null || !curr.isTTFNativeFont()) {
                curr = Font.create("native:MainRegular");
            }
            if (curr == null || !curr.isTTFNativeFont()) continue;
            curr = curr.derive(size, 0);
            style.setFont(curr);
        }
        return this;
    }

    public ComponentSelector first() {
        if (!this.isEmpty()) {
            return new ComponentSelector(this.results.iterator().next());
        }
        return new ComponentSelector(new Component[0]);
    }

    public static interface Filter {
        public boolean filter(Component var1);
    }

    public static interface ComponentMapper {
        public Component map(Component var1);
    }

    public static interface ComponentClosure {
        public void call(Component var1);
    }
}

