/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.FontImage;
import com.codename1.ui.Label;
import com.codename1.ui.TextArea;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;

public class ClearableTextField
extends Container {
    private ClearableTextField() {
        super(new BorderLayout());
    }

    public static ClearableTextField wrap(final TextArea tf, float iconSize) {
        ClearableTextField cf = new ClearableTextField();
        Button b = new Button("", tf.getUIID());
        if (iconSize > 0.0f) {
            FontImage.setMaterialIcon((Label)b, '\ue14c', iconSize);
        } else {
            FontImage.setMaterialIcon(b, '\ue14c');
        }
        ClearableTextField.removeCmpBackground(tf);
        ClearableTextField.removeCmpBackground(b);
        cf.setUIID(tf.getUIID());
        cf.add((Object)"Center", tf);
        cf.add((Object)"East", b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                tf.stopEditing();
                tf.setText("");
                tf.startEditingAsync();
            }
        });
        return cf;
    }

    public static ClearableTextField wrap(TextArea tf) {
        return ClearableTextField.wrap(tf, -1.0f);
    }

    private static void removeCmpBackground(Component cmp) {
        Style s = cmp.getAllStyles();
        s.setBorder(Border.createEmpty());
        s.setBackgroundType((byte)0);
        s.setBgTransparency(0);
    }
}

