/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

import com.codename1.maps.Coord;
import java.util.Vector;

public class BoundingBox {
    private final Coord _southWest;
    private final Coord _northEast;

    public BoundingBox(Coord c, double rLat, double rLng) {
        this._southWest = new Coord(c.getLatitude() - rLat, c.getLongitude() - rLng);
        this._northEast = new Coord(c.getLatitude() + rLat, c.getLongitude() + rLng);
    }

    public BoundingBox(Coord southWest, Coord northEast) {
        this._southWest = southWest;
        this._northEast = northEast;
    }

    public Coord getSouthWest() {
        return this._southWest;
    }

    public Coord getNorthEast() {
        return this._northEast;
    }

    public String toString() {
        return "SW: " + this._southWest + " NE: " + this._northEast;
    }

    public double latitudeDifference() {
        return this._northEast.getLatitude() - this._southWest.getLatitude();
    }

    public double longitudeDifference() {
        return this._northEast.getLongitude() - this._southWest.getLongitude();
    }

    public boolean contains(Coord cur) {
        double latitude = cur.getLatitude();
        if (latitude > this.getNorthEast().getLatitude() || latitude < this.getSouthWest().getLatitude()) {
            return false;
        }
        double longitude = cur.getLongitude();
        return !(longitude < this.getSouthWest().getLongitude()) && !(longitude > this.getNorthEast().getLongitude());
    }

    public boolean equals(Object other) {
        if (!(other instanceof BoundingBox)) {
            return false;
        }
        BoundingBox o = (BoundingBox)other;
        return this._southWest.equals(o._southWest) && this._northEast.equals(o._northEast);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + this._southWest.hashCode();
        hash = 29 * hash + this._northEast.hashCode();
        return hash;
    }

    public static BoundingBox create(Coord[] coords) {
        if (coords.length <= 0) {
            throw new RuntimeException("There must be at least 1 coordinate.");
        }
        double north = coords[0].getLatitude();
        double south = coords[0].getLatitude();
        double east = coords[0].getLongitude();
        double west = coords[0].getLongitude();
        boolean projected = true;
        for (Coord c : coords) {
            projected = c.isProjected();
            north = Math.max(north, c.getLatitude());
            east = Math.max(east, c.getLongitude());
            south = Math.min(south, c.getLatitude());
            west = Math.min(west, c.getLongitude());
        }
        return new BoundingBox(new Coord(south, west, projected), new Coord(north, east, projected));
    }

    public static BoundingBox create(Vector coords) {
        int length = coords.size();
        if (length <= 0) {
            throw new RuntimeException("There must be at least 1 coordinate.");
        }
        Object[] coordsArray = new Coord[length];
        coords.copyInto(coordsArray);
        return BoundingBox.create((Coord[])coordsArray);
    }

    public BoundingBox extend(BoundingBox other) {
        double north = Math.max(this.getNorthEast().getLatitude(), other.getNorthEast().getLatitude());
        double east = Math.max(this.getNorthEast().getLongitude(), other.getNorthEast().getLongitude());
        double south = Math.min(this.getSouthWest().getLatitude(), other.getSouthWest().getLatitude());
        double west = Math.min(this.getSouthWest().getLongitude(), other.getSouthWest().getLongitude());
        return new BoundingBox(new Coord(south, west, this.projected()), new Coord(north, east, this.projected()));
    }

    public boolean projected() {
        return this._southWest.isProjected();
    }
}

