/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.share.EmailShare;
import com.codename1.share.FacebookShare;
import com.codename1.share.SMSShare;
import com.codename1.share.ShareService;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.List;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import java.util.Vector;

public class ShareButton
extends Button
implements ActionListener {
    private String textToShare;
    private String imageToShare;
    private String imageMimeType;
    private Vector shareServices = new Vector();

    public ShareButton() {
        this.setUIID("ShareButton");
        FontImage.setMaterialIcon(this, '\ue80d');
        this.addActionListener((ActionListener)this);
        this.shareServices.addElement(new SMSShare());
        this.shareServices.addElement(new EmailShare());
        this.shareServices.addElement(new FacebookShare());
    }

    public void setTextToShare(String textToShare) {
        this.textToShare = textToShare;
    }

    public String getTextToShare() {
        return this.textToShare;
    }

    public void setImageToShare(String imagePath, String imageMimeType) {
        this.imageToShare = imagePath;
        this.imageMimeType = imageMimeType;
    }

    public String getImagePathToShare() {
        return this.imageToShare;
    }

    public void addShareService(ShareService share) {
        this.shareServices.addElement(share);
    }

    public void actionPerformed(ActionEvent evt) {
        Display.getInstance().callSerially(new Runnable(){

            public void run() {
                ShareService share;
                int i;
                Vector sharing;
                if (Display.getInstance().isNativeShareSupported()) {
                    Display.getInstance().share(ShareButton.this.textToShare, ShareButton.this.imageToShare, ShareButton.this.imageMimeType, new Rectangle(ShareButton.this.getAbsoluteX(), ShareButton.this.getAbsoluteY(), ShareButton.this.getWidth(), ShareButton.this.getHeight()));
                    return;
                }
                if (ShareButton.this.imageToShare != null) {
                    sharing = new Vector();
                    for (i = 0; i < ShareButton.this.shareServices.size(); ++i) {
                        share = (ShareService)ShareButton.this.shareServices.elementAt(i);
                        if (!share.canShareImage()) continue;
                        sharing.add(share);
                    }
                } else {
                    sharing = ShareButton.this.shareServices;
                }
                for (i = 0; i < sharing.size(); ++i) {
                    share = (ShareService)sharing.elementAt(i);
                    share.setMessage(ShareButton.this.textToShare);
                    share.setImage(ShareButton.this.imageToShare, ShareButton.this.imageMimeType);
                    share.setOriginalForm(ShareButton.this.getComponentForm());
                }
                List l = new List(sharing);
                l.setCommandList(true);
                final Dialog dialog = new Dialog("Share");
                dialog.setLayout(new BorderLayout());
                dialog.addComponent("Center", l);
                dialog.placeButtonCommands(new Command[]{new Command("Cancel")});
                l.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        dialog.dispose();
                    }
                });
                dialog.show();
            }
        });
    }

    public String[] getPropertyNames() {
        return new String[]{"textToShare"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("textToShare")) {
            return this.getTextToShare();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("textToShare")) {
            this.setTextToShare((String)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }
}

