/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.handle.FileHandle;
import java.io.IOException;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public class ClientlibFile
implements ClientlibElement {
    public final FileHandle handle;
    private final Clientlib.Type type;
    private final ClientlibRef ref;
    public final Map<String, String> properties;

    public ClientlibFile(ClientlibRef ref, Clientlib.Type type, Resource resource, Map<String, String> properties) {
        if (null == resource) {
            throw new IllegalArgumentException("path is null");
        }
        this.type = type;
        this.handle = new FileHandle(resource);
        this.properties = properties;
        this.ref = null != ref ? ref : new ClientlibRef(type, this.handle.getPath(), false, properties);
    }

    @Override
    public void accept(ClientlibVisitor visitor, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        visitor.visit(this, mode, parent);
    }

    public static boolean isFile(Resource resource) {
        return resource.isResourceType("nt:file") || resource.isResourceType("nt:linkedFile");
    }

    @Override
    public ClientlibLink makeLink() {
        return new ClientlibLink(this.type, ClientlibLink.Kind.FILE, this.handle.getPath(), this.properties);
    }

    @Override
    public ClientlibRef getRef() {
        return this.ref;
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + this.handle.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientlibFile)) {
            return false;
        }
        ClientlibFile that = (ClientlibFile)o;
        if (this.handle.getPath() != null ? !this.handle.getPath().equals(that.handle.getPath()) : that.handle.getPath() != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.handle != null && this.handle.getPath() != null ? this.handle.getPath().hashCode() : 0;
        result = 92821 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public Clientlib.Type getType() {
        return this.type;
    }
}

