/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.processor.RendererContext;
import com.composum.sling.clientlibs.servlet.ClientlibCategoryServlet;
import com.composum.sling.clientlibs.servlet.ClientlibServlet;
import com.composum.sling.core.util.LinkUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.api.SlingHttpServletRequest;

public class ClientlibLink {
    public static final String PROP_REL = "rel";
    public static final String[] LINK_PROPERTIES = new String[]{"rel"};
    public final String path;
    public final Clientlib.Type type;
    public final Kind kind;
    public final Map<String, String> properties;
    public final String hash;

    protected ClientlibLink(Clientlib.Type type, Kind kind, String path, Map<String, String> properties, String hash) {
        this.path = path;
        this.type = type;
        this.kind = kind;
        this.properties = Collections.unmodifiableMap(properties != null ? new HashMap<String, String>(properties) : new HashMap());
        this.hash = hash;
    }

    public ClientlibLink(Clientlib.Type type, Kind kind, String path, Map<String, String> properties) {
        this(type, kind, path, properties, null);
    }

    public ClientlibLink withHash(String newHash) {
        return new ClientlibLink(this.type, this.kind, this.path, this.properties, newHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientlibLink)) {
            return false;
        }
        ClientlibLink that = (ClientlibLink)o;
        if (!Objects.equals((Object)this.kind, (Object)that.kind)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 92821 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 92821 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 92821 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 92821 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public static ClientlibLink forCategory(Clientlib.Type type, String category) {
        return new ClientlibLink(type, Kind.CATEGORY, category, null);
    }

    boolean isCategory() {
        return Kind.CATEGORY == this.kind;
    }

    boolean isExternalUri() {
        return Kind.EXTERNALURI == this.kind;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append((Object)this.type).append(":");
        if (Kind.CATEGORY == this.kind) {
            builder.append("category:");
        }
        builder.append(this.path);
        if (null != this.hash) {
            builder.append("@").append(this.hash);
        }
        if (null != this.properties && !this.properties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                builder.append(";").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public String getUrl(SlingHttpServletRequest request, RendererContext context) {
        String uri;
        switch (this.kind) {
            case FILE: 
            case EXTERNALURI: {
                uri = this.path;
                break;
            }
            case CLIENTLIB: {
                uri = ClientlibServlet.makePath(this.path, this.type, context.useMinifiedFiles(), this.hash);
                break;
            }
            case CATEGORY: {
                uri = ClientlibCategoryServlet.makePath(this.path, this.type, context.useMinifiedFiles(), this.hash);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Bug - impossible.");
            }
        }
        String url = context.mapClientlibURLs() ? LinkUtil.getUrl(request, uri) : LinkUtil.getUnmappedUrl(request, uri);
        return url;
    }

    public static enum Kind {
        CATEGORY,
        CLIENTLIB,
        FILE,
        EXTERNALURI;

    }
}

