/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorContext {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorContext.class);
    public static final String CONTEXT_KEY = ProcessorContext.class.getName() + ".instance";
    protected final SlingHttpServletRequest request;
    protected final ResourceResolver resolver;
    protected final ExecutorService executorService;
    protected final Map<String, Object> hints = Collections.synchronizedMap(new HashMap());
    protected final boolean mapClientlibURLs;
    protected final boolean useMinifiedFiles;

    public ProcessorContext(SlingHttpServletRequest request, ResourceResolver resolver, ExecutorService executorService, boolean mapClientlibURLs, boolean useMinifiedFiles) {
        this.request = request;
        this.resolver = resolver;
        this.executorService = executorService;
        this.mapClientlibURLs = mapClientlibURLs;
        this.useMinifiedFiles = useMinifiedFiles;
        request.setAttribute(CONTEXT_KEY, (Object)this);
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public boolean mapClientlibURLs() {
        return this.mapClientlibURLs;
    }

    public boolean useMinifiedFiles() {
        return this.useMinifiedFiles;
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executorService.submit(callable);
    }

    public void hint(String key, Object value) {
        this.hints.put(key, value);
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }
}

