/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibCategory;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibExternalUri;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.processor.AbstractClientlibVisitor;
import com.composum.sling.clientlibs.processor.RendererContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingVisitor
extends AbstractClientlibVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RenderingVisitor.class);
    protected final RendererContext context;
    protected final List<ClientlibLink> linksToRender;
    protected final boolean ownerWasAlreadyRendered;

    public RenderingVisitor(ClientlibElement owner, RendererContext context) {
        this(owner, context, null, null);
    }

    protected RenderingVisitor(ClientlibElement owner, RendererContext context, List<ClientlibLink> linksToRender, LinkedHashSet<ClientlibLink> processedElements) {
        super(owner, context.getClientlibService(), context.getResolver(), processedElements);
        this.context = context;
        this.linksToRender = linksToRender != null ? linksToRender : new ArrayList();
        this.ownerWasAlreadyRendered = context.isClientlibRendered(owner.getRef());
    }

    @Override
    public RenderingVisitor execute() throws IOException, RepositoryException {
        super.execute();
        return this;
    }

    @Override
    protected ClientlibVisitor createVisitorFor(ClientlibElement element) {
        return new RenderingVisitor(element, this.context, this.linksToRender, (LinkedHashSet<ClientlibLink>)this.processedElements);
    }

    @Override
    public void action(ClientlibCategory clientlibCategory, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        if (this.hasEmbeddedFiles && !this.context.getConfiguration().debug()) {
            this.render(mode, clientlibCategory, parent);
        } else {
            this.context.registerClientlibLink(clientlibCategory.makeLink(), parent);
        }
    }

    @Override
    public void action(Clientlib clientlib, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        if (this.hasEmbeddedFiles && !this.context.getConfiguration().debug()) {
            this.render(mode, clientlib, parent);
        } else {
            this.context.registerClientlibLink(clientlib.makeLink(), parent);
        }
    }

    @Override
    public void action(ClientlibFile file, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        this.render(mode, file, parent);
    }

    protected void render(ClientlibVisitor.VisitorMode mode, ClientlibElement element, ClientlibResourceFolder parent) {
        if (this.ownerWasAlreadyRendered) {
            return;
        }
        ClientlibLink link = element.makeLink();
        if (this.owner == element) {
            link = link.withHash(this.getHash());
        }
        if (this.context.isClientlibRendered(element.getRef())) {
            if (ClientlibVisitor.VisitorMode.EMBEDDED == mode) {
                LOG.error("Already rendered / embedded file is also embedded in clientlib {} and thus included twice: {}", (Object)this.owner, (Object)link);
            }
        } else {
            if (ClientlibVisitor.VisitorMode.DEPENDS == mode || this.context.getConfiguration().debug()) {
                this.linksToRender.add(link);
            }
            this.context.registerClientlibLink(link, parent);
        }
    }

    @Override
    public void action(ClientlibExternalUri externalUri, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        LOG.trace(">>> {} {}", (Object)mode, (Object)externalUri);
        if (!this.context.isClientlibRendered(externalUri.getRef())) {
            ClientlibLink link = externalUri.makeLink();
            this.linksToRender.add(link);
            this.context.registerClientlibLink(link, parent);
        }
        LOG.trace("<<< {} {}", (Object)mode, (Object)externalUri);
    }

    public List<ClientlibLink> getLinksToRender() {
        return this.linksToRender;
    }

    @Override
    protected void notPresent(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        if (StringUtils.contains((CharSequence)ref.path, (CharSequence)",")) {
            LOG.warn("Not present and contains , - should probably be a multi string: {} references {}", (Object)parent, (Object)ref);
        } else if (StringUtils.contains((CharSequence)ref.category, (CharSequence)",")) {
            LOG.warn("Not present and contains , - should probably be a multi string: {} references {}", (Object)parent, (Object)ref);
        } else if (ref.optional) {
            LOG.debug("Not present: opt. {} referenced from {}", (Object)ref, (Object)parent);
        } else {
            LOG.warn("Not present: mand. {} referenced from {}", (Object)ref, (Object)parent);
        }
    }
}

