/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.clientlibs.servlet.AbstractClientlibServlet;
import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/bin/public/clientlibs", "sling.servlet.methods=HEAD", "sling.servlet.methods=GET", "sling.servlet.extensions=css", "sling.servlet.extensions=js"})
public class ClientlibCategoryServlet
extends AbstractClientlibServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ClientlibCategoryServlet.class);
    @Reference
    protected ClientlibService service;
    @Reference
    protected ClientlibConfiguration configuration;
    public static final String PATH = "/bin/public/clientlibs";
    protected static final Pattern HASHSUFFIX_PATTERN = Pattern.compile("/?([0-9a-zA-Z_-]++)?/([a-zA-Z0-9._-]+)[.][a-z]+");

    @Override
    protected ClientlibService getClientlibService() {
        return this.service;
    }

    @Override
    protected ClientlibConfiguration.Config getConfig() {
        return this.configuration.getConfig();
    }

    public static String makePath(String category, Clientlib.Type type, boolean minified, String hash) {
        StringBuilder buf = new StringBuilder(PATH);
        if (minified) {
            buf.append(".min");
        }
        buf.append(".").append(type.name());
        if (null != hash) {
            buf.append("/").append(hash);
        }
        buf.append("/").append(Clientlib.sanitizeCategory(category));
        buf.append(".").append(type.name());
        return buf.toString();
    }

    @Override
    protected String makeUri(boolean minified, ClientlibLink link) {
        return ClientlibCategoryServlet.makePath(link.path, link.type, minified, link.hash);
    }

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        this.serve(true, request, response);
    }

    protected void doHead(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        this.serve(false, request, response);
    }

    private void serve(boolean get, @Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws IOException, ServletException {
        if (this.usefulRequest(request, response)) {
            try {
                RequestPathInfo pathInfo = request.getRequestPathInfo();
                String extension = pathInfo.getExtension();
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    String selectors = pathInfo.getSelectorString();
                    Clientlib.Type type = Clientlib.Type.valueOf(extension.toLowerCase());
                    Pair<String, String> categoryAndHash = ClientlibCategoryServlet.parseCategoryAndHashFromSuffix(XSS.filter(pathInfo.getSuffix()));
                    ClientlibRef ref = ClientlibRef.forCategory(type, (String)categoryAndHash.getLeft(), false, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("deliver: {} ({})", (Object)ref.category, (Object)request.getRequestURI());
                    }
                    this.deliverClientlib(get, request, response, ref, (String)categoryAndHash.getRight(), this.isMinified(selectors));
                }
                LOG.error("no extension found ({})", (Object)request.getRequestURL().toString());
            }
            catch (RepositoryException ex) {
                throw new ServletException((Throwable)ex);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("dropped: {}", (Object)request.getRequestURI());
        }
    }

    public static Pair<String, String> parseCategoryAndHashFromSuffix(String suffix) {
        Matcher matcher = HASHSUFFIX_PATTERN.matcher(suffix);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse suffix " + suffix);
        }
        return Pair.of((Object)matcher.group(2), (Object)matcher.group(1));
    }
}

