/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.SlingBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Adaptable(adaptableClass=BeanContext.class, adapters={@Adapter(condition="If the context contains an entity of the requested type", value={Resource.class, ResourceResolver.class, SlingHttpServletRequest.class, SlingHttpServletResponse.class})})
public interface BeanContext
extends org.apache.sling.api.adapter.Adaptable {
    public static final String ATTR_RESOURCE = "resource";
    public static final String ATTR_RESOLVER = "resourceResolver";
    public static final String ATTR_REQUEST = "request";
    public static final String ATTR_RESPONSE = "response";
    public static final String ATTR_LOCALE = "locale";

    public Resource getResource();

    public ResourceResolver getResolver();

    public SlingHttpServletRequest getRequest();

    public SlingHttpServletResponse getResponse();

    public Locale getLocale();

    public <T> T getAttribute(String var1, Class<T> var2);

    public void setAttribute(String var1, Object var2, Scope var3);

    public <T> T getService(Class<T> var1);

    public <T> T[] getServices(Class<T> var1, String var2) throws InvalidSyntaxException;

    public Class<?> getType(String var1) throws ClassNotFoundException;

    public <AdapterType> AdapterType adaptTo(@Nonnull Class<AdapterType> var1);

    public BeanContext withResource(Resource var1);

    public BeanContext withLocale(Locale var1);

    public static class Wrapper
    implements BeanContext {
        protected BeanContext beanContext;
        protected final ResourceResolver resolver;
        protected final Resource resource;
        private transient SlingHttpServletRequest request;

        public Wrapper(BeanContext beanContext) {
            this(beanContext, beanContext.getResolver());
        }

        public Wrapper(BeanContext beanContext, ResourceResolver resolverToUse) {
            this(beanContext, resolverToUse, null);
        }

        public Wrapper(BeanContext beanContext, Resource resourceToUse) {
            this(beanContext, null, resourceToUse);
        }

        public Wrapper(BeanContext beanContext, ResourceResolver resolverToUse, Resource resourceToUse) {
            this.beanContext = beanContext;
            this.resolver = resolverToUse;
            this.resource = resourceToUse;
        }

        @Override
        public Resource getResource() {
            return this.resource != null ? this.resource : this.beanContext.getResource();
        }

        @Override
        public ResourceResolver getResolver() {
            return this.resolver != null ? this.resolver : this.beanContext.getResolver();
        }

        @Override
        public SlingHttpServletRequest getRequest() {
            SlingHttpServletRequest beanRequest;
            if (this.request == null && (beanRequest = this.beanContext.getRequest()) != null) {
                this.request = new ContextRequest(beanRequest);
            }
            return this.request;
        }

        @Override
        public SlingHttpServletResponse getResponse() {
            return this.beanContext.getResponse();
        }

        @Override
        public Locale getLocale() {
            return this.beanContext.getLocale();
        }

        @Override
        public <T> T getAttribute(String name, Class<T> T) {
            return this.beanContext.getAttribute(name, T);
        }

        @Override
        public void setAttribute(String name, Object value, Scope scope) {
            this.beanContext.setAttribute(name, value, scope);
        }

        @Override
        public <T> T getService(Class<T> type) {
            return this.beanContext.getService(type);
        }

        @Override
        public <T> T[] getServices(Class<T> serviceType, String filter) throws InvalidSyntaxException {
            return this.beanContext.getServices(serviceType, filter);
        }

        @Override
        public Class<?> getType(String className) throws ClassNotFoundException {
            return this.beanContext.getType(className);
        }

        @Override
        public <AdapterType> AdapterType adaptTo(@Nonnull Class<AdapterType> type) {
            return this.beanContext.adaptTo(type);
        }

        @Override
        public BeanContext withResource(Resource resource) {
            return this.beanContext.withResource(resource);
        }

        @Override
        public BeanContext withLocale(Locale locale) {
            return this.beanContext.withLocale(locale);
        }

        class ContextRequest
        extends SlingHttpServletRequestWrapper {
            public ContextRequest(SlingHttpServletRequest request) {
                super(request);
            }

            public ResourceResolver getResourceResolver() {
                return Wrapper.this.resolver;
            }
        }
    }

    public static class Servlet
    extends AbstractContext {
        private ServletContext servletContext;
        protected BundleContext bundleContext;
        private SlingHttpServletRequest request;
        private SlingHttpServletResponse response;
        private transient Resource resource;
        private transient ResourceResolver resolver;

        public Servlet(ServletContext servletContext, BundleContext bundleContext, SlingHttpServletRequest request, SlingHttpServletResponse response) {
            this.servletContext = servletContext;
            this.bundleContext = bundleContext;
            this.request = request;
            this.response = response;
        }

        public Servlet(ServletContext servletContext, BundleContext bundleContext, SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) {
            this(servletContext, bundleContext, request, response);
            this.resource = resource;
        }

        @Override
        public Resource getResource() {
            if (this.resource == null) {
                this.resource = this.request.getResource();
            }
            return this.resource;
        }

        @Override
        public ResourceResolver getResolver() {
            if (this.resolver == null) {
                this.resolver = this.getRequest().getResourceResolver();
            }
            return this.resolver;
        }

        @Override
        public SlingHttpServletRequest getRequest() {
            return this.request;
        }

        @Override
        public SlingHttpServletResponse getResponse() {
            return this.response;
        }

        @Override
        public <T> T getAttribute(String name, Class<T> T) {
            Object attribute = null;
            if (StringUtils.isNotBlank((CharSequence)name) && (attribute = this.request.getAttribute(name)) == null) {
                HttpSession session = this.request.getSession();
                if (session != null) {
                    attribute = session.getAttribute(name);
                }
                if (attribute == null && this.servletContext != null) {
                    attribute = this.servletContext.getAttribute(name);
                }
            }
            return (T)attribute;
        }

        @Override
        public void setAttribute(String name, Object value, Scope scope) {
            switch (scope) {
                case application: {
                    if (this.servletContext != null) {
                        this.servletContext.setAttribute(name, value);
                        break;
                    }
                }
                case session: {
                    HttpSession session = this.request.getSession();
                    if (session != null) {
                        session.setAttribute(name, value);
                        break;
                    }
                }
                default: {
                    this.request.setAttribute(name, value);
                }
            }
        }

        @Override
        public <T> T retrieveService(Class<T> type) {
            ServiceReference reference = this.bundleContext.getServiceReference(type);
            return (T)this.bundleContext.getService(reference);
        }

        @Override
        public <T> T[] getServices(Class<T> type, String filter) throws InvalidSyntaxException {
            ArrayList<Object> services = new ArrayList<Object>();
            Collection references = this.bundleContext.getServiceReferences(type, filter);
            for (ServiceReference reference : references) {
                services.add(this.bundleContext.getService(reference));
            }
            return services.toArray();
        }

        @Override
        public <AdapterType> AdapterType adaptTo(@Nonnull Class<AdapterType> type) {
            if (this.typeFits(type, ServletContext.class, this.servletContext, ServletContext.class)) {
                return type.cast(this.servletContext);
            }
            if (this.typeFits(type, BundleContext.class, this.bundleContext, BundleContext.class)) {
                return type.cast(this.servletContext);
            }
            return super.adaptTo(type);
        }

        @Override
        public Servlet withResource(Resource resource) {
            if (this.getResource() == resource) {
                return this;
            }
            Servlet copy = (Servlet)this.cloneContext();
            copy.resource = resource;
            if (null == this.getResolver() && null != resource) {
                this.resolver = resource.getResourceResolver();
            }
            return copy;
        }
    }

    public static class Page
    extends AbstractScriptContext {
        private PageContext pageContext;
        private transient Resource resource;
        private transient ResourceResolver resolver;

        public Page(PageContext pageContext) {
            this.pageContext = pageContext;
        }

        public PageContext getPageContext() {
            return this.pageContext;
        }

        @Override
        public Resource getResource() {
            if (this.resource == null) {
                this.resource = this.getAttribute(BeanContext.ATTR_RESOURCE, Resource.class);
            }
            return this.resource;
        }

        @Override
        public ResourceResolver getResolver() {
            if (this.resolver == null) {
                this.resolver = this.getRequest().getResourceResolver();
            }
            return this.resolver;
        }

        @Override
        public SlingHttpServletRequest getRequest() {
            return (SlingHttpServletRequest)this.pageContext.getRequest();
        }

        @Override
        public SlingHttpServletResponse getResponse() {
            return (SlingHttpServletResponse)this.pageContext.getResponse();
        }

        @Override
        public <T> T getAttribute(String name, Class<T> T) {
            Object attribute = null;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                attribute = this.pageContext.findAttribute(name);
            }
            return (T)attribute;
        }

        @Override
        public void setAttribute(String name, Object value, Scope scope) {
            this.pageContext.setAttribute(name, value, scope.value);
        }

        @Override
        public <AdapterType> AdapterType adaptTo(@Nonnull Class<AdapterType> type) {
            if (this.typeFits(type, PageContext.class, this.pageContext, PageContext.class)) {
                return type.cast(this.pageContext);
            }
            return super.adaptTo(type);
        }

        @Override
        public BeanContext withResource(Resource resource) {
            if (this.getResource() == resource) {
                return this;
            }
            Page copy = (Page)this.cloneContext();
            copy.resource = resource;
            if (null == this.getResolver() && null != resource) {
                this.resolver = resource.getResourceResolver();
            }
            return copy;
        }
    }

    public static class Service
    extends Map {
        private static final Logger LOG = LoggerFactory.getLogger(Service.class);
        private transient BundleContext bundleContext;

        public Service() {
        }

        public Service(ResourceResolver resolver) {
            this.resolver = resolver;
            this.setAttribute(BeanContext.ATTR_RESOLVER, this.resolver, Scope.request);
        }

        public Service(SlingHttpServletRequest request, SlingHttpServletResponse response) {
            this(request, response, request.getResource());
        }

        public Service(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) {
            this(request, response, resource, request.getResourceResolver());
        }

        public Service(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, ResourceResolver resolver) {
            this.request = request;
            this.setAttribute(BeanContext.ATTR_REQUEST, this.request, Scope.request);
            this.setAttribute(BeanContext.ATTR_RESPONSE, response, Scope.request);
            this.resolver = resolver;
            this.setAttribute(BeanContext.ATTR_RESOLVER, this.resolver, Scope.request);
            this.resource = resource;
            this.setAttribute(BeanContext.ATTR_RESOURCE, this.resource, Scope.request);
        }

        @Override
        public Service withResource(Resource resource) {
            if (this.getResource() == resource) {
                return this;
            }
            Service copy = (Service)this.cloneContext();
            copy.resource = resource;
            if (null == this.getResolver() && null != resource) {
                this.resolver = resource.getResourceResolver();
            }
            return copy;
        }

        @Override
        public <T> T retrieveService(Class<T> type) {
            BundleContext bundleContext = this.getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(type);
            return serviceReference != null ? (T)type.cast(bundleContext.getService(serviceReference)) : null;
        }

        @Override
        public <T> T[] getServices(Class<T> serviceType, String filter) {
            ArrayList<Object> result = new ArrayList<Object>();
            try {
                ServiceReference[] serviceReferences;
                BundleContext bundleContext = this.getBundleContext();
                for (ServiceReference serviceReference : serviceReferences = bundleContext.getServiceReferences(serviceType.getName(), filter)) {
                    result.add(bundleContext.getService(serviceReference));
                }
            }
            catch (InvalidSyntaxException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
            return result.toArray();
        }

        protected BundleContext getBundleContext() {
            if (this.bundleContext == null) {
                this.bundleContext = FrameworkUtil.getBundle(BeanContext.class).getBundleContext();
            }
            return this.bundleContext;
        }
    }

    public static class Map
    extends AbstractScriptContext {
        private final java.util.Map<String, Object> pageScopeMap;
        private final java.util.Map<String, Object> requestScopeMap;
        private final java.util.Map<String, Object> sessionScopeMap;
        protected transient SlingHttpServletRequest request;
        protected transient Resource resource;
        protected transient ResourceResolver resolver;

        public Map() {
            this(new HashMap<String, Object>());
        }

        public Map(java.util.Map<String, Object> pageScopeMap) {
            this(pageScopeMap, new HashMap<String, Object>());
        }

        public Map(java.util.Map<String, Object> pageScopeMap, java.util.Map<String, Object> requestScopeMap) {
            this(pageScopeMap, requestScopeMap, new HashMap<String, Object>());
        }

        public Map(java.util.Map<String, Object> pageScopeMap, SlingHttpServletRequest request) {
            this(pageScopeMap, null, new HashMap<String, Object>());
            this.request = request;
        }

        public Map(java.util.Map<String, Object> pageScopeMap, java.util.Map<String, Object> requestScopeMap, java.util.Map<String, Object> sessionScopeMap) {
            this.pageScopeMap = pageScopeMap;
            this.requestScopeMap = requestScopeMap;
            this.sessionScopeMap = sessionScopeMap;
        }

        @Override
        public Resource getResource() {
            if (this.resource == null) {
                this.resource = this.getAttribute(BeanContext.ATTR_RESOURCE, Resource.class);
            }
            return this.resource;
        }

        @Override
        public ResourceResolver getResolver() {
            if (this.resolver == null) {
                this.resolver = this.getAttribute(BeanContext.ATTR_RESOLVER, ResourceResolver.class);
            }
            return this.resolver;
        }

        @Override
        public SlingHttpServletRequest getRequest() {
            if (this.request == null) {
                this.request = this.getAttribute(BeanContext.ATTR_REQUEST, SlingHttpServletRequest.class);
            }
            return this.request;
        }

        @Override
        public SlingHttpServletResponse getResponse() {
            return this.getAttribute(BeanContext.ATTR_RESPONSE, SlingHttpServletResponse.class);
        }

        @Override
        public <T> T getAttribute(String name, Class<T> T) {
            Object attribute = null;
            if (StringUtils.isNotBlank((CharSequence)name) && (attribute = this.pageScopeMap.get(name)) == null) {
                SlingHttpServletRequest request;
                if (!BeanContext.ATTR_REQUEST.equals(name) && (request = this.getRequest()) != null) {
                    attribute = request.getAttribute(name);
                }
                if (attribute == null) {
                    attribute = this.requestScopeMap.get(name);
                }
                if (attribute == null) {
                    HttpSession session;
                    if (this.request != null && (session = this.request.getSession()) != null) {
                        attribute = session.getAttribute(name);
                    }
                    if (attribute == null) {
                        attribute = this.sessionScopeMap.get(name);
                    }
                }
            }
            return (T)attribute;
        }

        @Override
        public void setAttribute(String name, Object value, Scope scope) {
            if (scope == Scope.page) {
                this.pageScopeMap.put(name, value);
            } else {
                SlingHttpServletRequest request;
                if (BeanContext.ATTR_REQUEST.equals(name)) {
                    this.requestScopeMap.put(name, value);
                }
                if ((request = this.getRequest()) != null) {
                    if (scope == Scope.request) {
                        request.setAttribute(name, value);
                    } else {
                        HttpSession session = request.getSession();
                        if (session != null) {
                            session.setAttribute(name, value);
                        } else {
                            this.sessionScopeMap.put(name, value);
                        }
                    }
                } else if (scope == Scope.request) {
                    this.requestScopeMap.put(name, value);
                } else {
                    this.sessionScopeMap.put(name, value);
                }
            }
        }

        @Override
        public Map withResource(Resource resource) {
            if (this.getResource() == resource) {
                return this;
            }
            Map copy = (Map)this.cloneContext();
            copy.resource = resource;
            if (null == this.getResolver() && null != resource) {
                this.resolver = resource.getResourceResolver();
            }
            return copy;
        }
    }

    public static abstract class AbstractScriptContext
    extends AbstractContext {
        protected SlingBindings slingBindings;
        protected SlingScriptHelper scriptHelper;

        protected AbstractScriptContext() {
        }

        @Override
        public <T> T retrieveService(Class<T> type) {
            return (T)this.getScriptHelper().getService(type);
        }

        @Override
        public <T> T[] getServices(Class<T> serviceType, String filter) {
            return this.getScriptHelper().getServices(serviceType, filter);
        }

        public SlingScriptHelper getScriptHelper() {
            if (this.scriptHelper == null) {
                this.scriptHelper = this.getSlingBindings().getSling();
            }
            return this.scriptHelper;
        }

        public SlingBindings getSlingBindings() {
            if (this.slingBindings == null) {
                this.slingBindings = (SlingBindings)this.getAttribute(SlingBindings.class.getName(), SlingBindings.class);
            }
            return this.slingBindings;
        }
    }

    public static abstract class AbstractContext
    extends SlingAdaptable
    implements BeanContext,
    Cloneable {
        private static final Logger LOG = LoggerFactory.getLogger(AbstractContext.class);
        protected transient Locale locale;

        protected AbstractContext() {
        }

        protected Object cloneContext() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Impossible: clone didn't work", e);
            }
        }

        protected abstract <T> T retrieveService(Class<T> var1);

        @Override
        public Locale getLocale() {
            if (null == this.locale) {
                this.locale = (Locale)this.getAttribute(BeanContext.ATTR_LOCALE, Locale.class);
            }
            return this.locale;
        }

        @Override
        public BeanContext withLocale(Locale locale) {
            if (ObjectUtils.equals((Object)this.getLocale(), (Object)locale)) {
                return this;
            }
            AbstractContext cloned = (AbstractContext)this.cloneContext();
            cloned.locale = locale;
            return cloned;
        }

        @Override
        public <T> T getService(Class<T> type) {
            String typeKey = type.getName();
            Object service = this.getAttribute(typeKey, type);
            if (service == null) {
                service = this.retrieveService(type);
                this.setAttribute(typeKey, service, Scope.request);
            }
            return (T)service;
        }

        @Override
        public Class<?> getType(String className) throws ClassNotFoundException {
            Class<?> type = null;
            DynamicClassLoaderManager dclm = this.getService(DynamicClassLoaderManager.class);
            if (dclm != null) {
                type = dclm.getDynamicClassLoader().loadClass(className);
            }
            if (type == null) {
                type = Class.forName(className);
            }
            return type;
        }

        @Override
        public <AdapterType> AdapterType adaptTo(@Nonnull Class<AdapterType> type) {
            if (this.typeFits(type, BeanContext.class, this, BeanContext.class)) {
                return type.cast(this);
            }
            if (this.typeFits(type, ServletRequest.class, this.getRequest(), SlingHttpServletRequest.class)) {
                return type.cast(this.getRequest());
            }
            if (this.typeFits(type, ServletResponse.class, this.getResponse(), SlingHttpServletResponse.class)) {
                return type.cast(this.getResponse());
            }
            if (this.typeFits(type, ResourceResolver.class, this.getResolver(), ResourceResolver.class)) {
                return type.cast(this.getResolver());
            }
            if (this.typeFits(type, Resource.class, this.getResource(), Resource.class)) {
                return type.cast(this.getResource());
            }
            if (ValueMap.class.equals(type)) {
                return null != this.getResource() ? (AdapterType)type.cast(this.getResource().getValueMap()) : null;
            }
            if (Locale.class.equals(type)) {
                return type.cast(this.getLocale());
            }
            Object slingAdaption = super.adaptTo(type);
            if (null != slingAdaption) {
                return (AdapterType)slingAdaption;
            }
            return this.tryToInstantiateSlingBean(type);
        }

        protected <AdapterType> AdapterType tryToInstantiateSlingBean(Class<AdapterType> type) {
            if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers()) && SlingBean.class.isAssignableFrom(type)) {
                boolean isSlingModelsModel = false;
                for (Annotation annotation : type.getAnnotations()) {
                    isSlingModelsModel = isSlingModelsModel || annotation.annotationType().getName().equals("org.apache.sling.models.annotations.Model");
                }
                if (!isSlingModelsModel) {
                    try {
                        SlingBean slingBean = (SlingBean)type.newInstance();
                        slingBean.initialize(this);
                        return type.cast(slingBean);
                    }
                    catch (IllegalAccessException | InstantiationException | RuntimeException e) {
                        LOG.error("Couldn't instantiate " + type, (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected <AdapterType> boolean typeFits(Class<?> type, Class<?> upperbound, AdapterType object, Class<AdapterType> defaultclass) {
            if (!upperbound.isAssignableFrom(type)) {
                return false;
            }
            return null != object && type.isAssignableFrom(object.getClass()) || type.isAssignableFrom(defaultclass);
        }
    }

    public static enum Scope {
        page(1),
        request(2),
        session(3),
        application(4);

        public final int value;

        private Scope(int value) {
            this.value = value;
        }
    }
}

