/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.AbstractSlingBean;
import com.composum.sling.core.BeanContext;
import com.composum.sling.core.util.PropertyUtil;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class ResourceModel
extends AbstractSlingBean {
    private transient ValueMap propertyMap;
    private transient ValueMap values;

    public ResourceModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public ResourceModel(BeanContext context) {
        super(context);
    }

    public ResourceModel() {
    }

    @Override
    public <T> T getProperty(String name, T defaultValue) {
        Class<T> type = PropertyUtil.getType(defaultValue);
        T value = this.getProperty(name, type);
        return value != null ? value : defaultValue;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return (T)this.getValues().get(name, type);
    }

    public ValueMap getValues() {
        if (this.values == null) {
            this.values = this.resource.getValueMap();
        }
        return this.values;
    }

    @Nonnull
    public ValueMap getProperty() {
        if (this.propertyMap == null) {
            this.propertyMap = new GenericProperty();
        }
        return this.propertyMap;
    }

    public class GenericProperty
    extends GenericMap {
        @Override
        @Nullable
        public <T> T getValue(String key, @Nonnull Class<T> type) {
            return ResourceModel.this.getProperty(key, type);
        }
    }

    public abstract class GenericMap
    extends HashMap<String, Object>
    implements ValueMap {
        public static final String UNDEFINED = "<undefined>";

        @Override
        @Nullable
        public Object get(@Nonnull Object key) {
            return this.get((String)key, (Object)Object.class);
        }

        public <T> T get(@Nonnull String name, @Nonnull Class<T> type) {
            Object value;
            if (name.startsWith("_jcr_")) {
                name = "jcr:" + name.substring(5);
            }
            if ((value = super.get(name)) == null) {
                value = this.getValue(name, type);
                super.put(name, value != null ? value : UNDEFINED);
            }
            return (T)(value != UNDEFINED ? value : null);
        }

        @Nonnull
        public <Type> Type get(@Nonnull String name, @Nonnull Type defaultValue) {
            Class<?> value = this.get(name, (Type)defaultValue.getClass());
            return (Type)(value != null ? value : defaultValue);
        }

        protected abstract <T> T getValue(String var1, @Nonnull Class<T> var2);
    }
}

