/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import com.composum.sling.core.concurrent.JobFacade;
import com.composum.sling.core.concurrent.JobUtil;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;

public abstract class JobMonitor
implements Callable<Boolean> {
    public static final long DELAY = 100L;
    public final JobManager jobManager;
    public final ResourceResolver resolver;
    public final String jobId;
    protected Boolean isActive = false;
    protected Boolean wasActive = false;
    protected Job.JobState currentState;
    protected Job.JobState finalState;
    protected boolean running = false;
    protected boolean done = false;
    protected long timeout;

    public boolean started() {
        return this.wasActive;
    }

    public boolean succeeded() {
        return Job.JobState.SUCCEEDED == this.finalState;
    }

    public boolean stopped() {
        return Job.JobState.STOPPED == this.finalState;
    }

    public boolean error() {
        return this.finalState != null && !this.succeeded() && !this.stopped();
    }

    public boolean done() {
        return this.finalState != null;
    }

    protected abstract boolean goalReached();

    protected JobMonitor(JobManager jobManager, ResourceResolver resolver, String jobId, Long timeout) {
        this.jobManager = jobManager;
        this.resolver = resolver;
        this.jobId = jobId;
        if (timeout != null) {
            this.timeout = timeout;
        }
    }

    @Override
    public Boolean call() {
        this.running = true;
        while (!this.goalReached() && !this.done() && this.timeout > 0L) {
            this.checkJobState();
            try {
                if (this.goalReached() || this.done()) continue;
                Thread.sleep(100L);
                this.timeout -= 100L;
            }
            catch (InterruptedException iex) {
                // empty catch block
                break;
            }
        }
        this.checkJobState();
        this.running = false;
        this.done = true;
        return this.goalReached();
    }

    @Nullable
    public JobFacade getJob() {
        return JobUtil.getJobById(this.jobManager, this.resolver, this.jobId);
    }

    protected void checkJobState() {
        JobFacade job = JobUtil.getJobById(this.jobManager, this.resolver, this.jobId);
        if (job != null) {
            this.currentState = job.getJobState();
        }
        switch (this.currentState) {
            case ACTIVE: {
                this.isActive = true;
                this.wasActive = true;
                break;
            }
            case SUCCEEDED: 
            case GIVEN_UP: 
            case STOPPED: {
                this.wasActive = true;
            }
            case ERROR: 
            case DROPPED: {
                this.finalState = this.currentState;
                this.isActive = false;
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("jobId", (Object)this.jobId).append("isActive", (Object)this.isActive).append("wasActive", (Object)this.wasActive).append("currentState", (Object)this.currentState).append("finalState", (Object)this.finalState).append("running", this.running).append("done", this.done).append("timeout", this.timeout).toString();
    }

    public static class IsDone
    extends JobMonitor {
        public IsDone(JobManager jobManager, ResourceResolver resolver, String jobId, long timeout) {
            super(jobManager, resolver, jobId, timeout);
        }

        @Override
        protected boolean goalReached() {
            return this.done();
        }
    }

    public static class IsStarted
    extends JobMonitor {
        public IsStarted(JobManager jobManager, ResourceResolver resolver, String jobId, long timeout) {
            super(jobManager, resolver, jobId, timeout);
        }

        @Override
        protected boolean goalReached() {
            return this.started();
        }
    }
}

