/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import com.composum.sling.core.concurrent.SequencerService;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SemaphoreSequencer
implements SequencerService<Token> {
    private static final Logger LOG = LoggerFactory.getLogger(SemaphoreSequencer.class);
    volatile WeakHashMap<Token, WeakReference<Token>> activeTokens;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Token acquire(String key) {
        Semaphore semaphore;
        Token token;
        SemaphoreSequencer semaphoreSequencer = this;
        synchronized (semaphoreSequencer) {
            WeakReference<Token> ref = this.activeTokens.get(new Token(key, null));
            Token token2 = token = ref != null ? (Token)ref.get() : null;
            if (token == null) {
                semaphore = new Semaphore(1);
                token = new Token(key, semaphore);
                this.activeTokens.put(token, new WeakReference<Token>(token));
            } else {
                semaphore = token.semaphore;
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException("Can't acquire lock since our thread is interrupted.");
        }
        try {
            LOG.debug("acquiring (" + key + ")");
            semaphore.tryAcquire(1L, TimeUnit.HOURS);
            LOG.debug("acquired (" + key + ")");
        }
        catch (InterruptedException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            if (!Thread.currentThread().isInterrupted()) {
                LOG.error("Unlocking semaphore for {} since we've been waiting for an hour. There must be something broken.", (Object)key);
                semaphore.release();
                while (semaphore.hasQueuedThreads()) {
                    Thread.yield();
                    semaphore.release();
                }
            }
            throw new IllegalStateException("Could not acquive lock for a loong time, or we have been interrupted.", ex);
        }
        semaphoreSequencer = this;
        synchronized (semaphoreSequencer) {
            token = new Token(key, semaphore);
            this.activeTokens.put(token, new WeakReference<Token>(token));
        }
        return token;
    }

    @Override
    public void release(Token token) {
        if (token != null) {
            LOG.debug("release (" + token.key + ")");
            token.semaphore.release();
        } else {
            LOG.warn("release called with a null token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        WeakHashMap<Token, WeakReference<Token>> oldTokens;
        SemaphoreSequencer semaphoreSequencer = this;
        synchronized (semaphoreSequencer) {
            oldTokens = this.activeTokens;
            this.activeTokens = new WeakHashMap();
        }
        this.cleanOldSemaphores(oldTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        WeakHashMap<Token, WeakReference<Token>> semaphoresToClear = null;
        SemaphoreSequencer semaphoreSequencer = this;
        synchronized (semaphoreSequencer) {
            if (this.activeTokens != null) {
                semaphoresToClear = this.activeTokens;
                this.activeTokens = null;
            }
        }
        this.cleanOldSemaphores(semaphoresToClear);
    }

    protected void cleanOldSemaphores(Map<Token, WeakReference<Token>> tokensToClear) {
        if (tokensToClear == null || tokensToClear.isEmpty()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            for (Token token : tokensToClear.keySet()) {
                while (token.semaphore.hasQueuedThreads()) {
                    token.semaphore.release();
                    Thread.yield();
                }
            }
        }
    }

    public static final class Token
    implements SequencerService.Token {
        @Nonnull
        protected final String key;
        protected final Semaphore semaphore;

        protected Token(@Nonnull String key, Semaphore semaphore) {
            this.key = key;
            this.semaphore = semaphore;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Token token = (Token)o;
            return this.key.equals(token.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

