/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.mapping.json;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import com.composum.sling.core.mapping.json.StringFilterTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFilterTypeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(StringFilterTypeAdapter.class);
    public static final GsonBuilder GSON_BUILDER = ResourceFilterTypeAdapter.registerTypeAdapters(new GsonBuilder());
    public static final Gson GSON = GSON_BUILDER.create();

    public static GsonBuilder registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.FilterSet.class), new FilterSetAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.TypeFilter.class), new TypeFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.NameFilter.class), new PatternFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.PathFilter.class), new PatternFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.PrimaryTypeFilter.class), new PatternFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.NodeTypeFilter.class), new PatternFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.ResourceTypeFilter.class), new PatternFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.MimeTypeFilter.class), new PatternFilterAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.FolderFilter.class), new PredefinedFilterAdapter(ResourceFilter.FOLDER));
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.AllFilter.class), new PredefinedFilterAdapter(ResourceFilter.ALL));
        builder.registerTypeAdapter((Type)((Object)ResourceFilter.class), new GeneralAdapter());
        builder = StringFilterTypeAdapter.registerTypeAdapters(builder);
        return builder;
    }

    public static class FilterSetAdapter
    extends GeneralAdapter {
        protected transient ResourceFilter.FilterSet.Rule rule = null;
        protected transient List<ResourceFilter> set = null;

        @Override
        protected void writeValues(JsonWriter writer, ResourceFilter value) throws IOException {
            super.writeValues(writer, value);
            writer.name(JsonValues.rule.name()).value(((ResourceFilter.FilterSet)value).getRule().name());
            writer.name(JsonValues.set.name());
            List<ResourceFilter> set = ((ResourceFilter.FilterSet)value).getSet();
            GSON.toJson(set, set.getClass(), writer);
        }

        @Override
        protected ResourceFilter createInstance(Class<? extends ResourceFilter> type) throws Exception {
            ResourceFilter result = type.getConstructor(ResourceFilter.FilterSet.Rule.class, List.class).newInstance(new Object[]{this.rule, this.set});
            return result;
        }

        @Override
        protected Object parseValue(JsonReader reader, String name) throws IOException {
            switch (JsonValues.valueOf(name)) {
                case rule: {
                    this.rule = ResourceFilter.FilterSet.Rule.valueOf(reader.nextString());
                    return this.rule;
                }
                case set: {
                    this.set = new ArrayList<ResourceFilter>();
                    Gson gson = ResourceFilterTypeAdapter.registerTypeAdapters(new GsonBuilder()).create();
                    reader.beginArray();
                    while (reader.peek() != JsonToken.END_ARRAY) {
                        ResourceFilter filter = (ResourceFilter)gson.fromJson(reader, (Type)((Object)ResourceFilter.class));
                        this.set.add(filter);
                    }
                    reader.endArray();
                    return this.set;
                }
            }
            return super.parseValue(reader, name);
        }

        static enum JsonValues {
            type,
            rule,
            set;

        }
    }

    public static class PatternFilterAdapter
    extends GeneralAdapter {
        protected transient StringFilter filter = null;

        @Override
        protected void writeValues(JsonWriter writer, ResourceFilter value) throws IOException {
            super.writeValues(writer, value);
            writer.name(JsonValues.filter.name());
            StringFilter filter = ((ResourceFilter.PatternFilter)value).getFilter();
            GSON.toJson((Object)filter, filter.getClass(), writer);
        }

        @Override
        protected ResourceFilter createInstance(Class<? extends ResourceFilter> type) throws Exception {
            ResourceFilter result = this.filter != null ? type.getConstructor(StringFilter.class).newInstance(this.filter) : super.createInstance(type);
            return result;
        }

        @Override
        protected Object parseValue(JsonReader reader, String name) throws IOException {
            switch (JsonValues.valueOf(name)) {
                case filter: {
                    this.filter = (StringFilter)GSON.fromJson(reader, (Type)((Object)StringFilter.class));
                    return this.filter;
                }
            }
            return super.parseValue(reader, name);
        }

        static enum JsonValues {
            type,
            filter;

        }
    }

    public static class TypeFilterAdapter
    extends GeneralAdapter {
        protected transient String filter = null;

        @Override
        protected void writeValues(JsonWriter writer, ResourceFilter value) throws IOException {
            ResourceFilter.TypeFilter typeFilter = (ResourceFilter.TypeFilter)value;
            super.writeValues(writer, value);
            writer.name(JsonValues.filter.name());
            StringBuilder buf = new StringBuilder();
            typeFilter.typeNamesToString(buf);
            writer.value(buf.toString());
        }

        @Override
        protected ResourceFilter createInstance(Class<? extends ResourceFilter> type) throws Exception {
            ResourceFilter result = this.filter != null ? type.getConstructor(String.class).newInstance(this.filter) : super.createInstance(type);
            return result;
        }

        @Override
        protected Object parseValue(JsonReader reader, String name) throws IOException {
            switch (JsonValues.valueOf(name)) {
                case filter: {
                    this.filter = reader.nextString();
                    return this.filter;
                }
            }
            return super.parseValue(reader, name);
        }

        static enum JsonValues {
            type,
            filter,
            restriction;

        }
    }

    public static class PredefinedFilterAdapter
    extends GeneralAdapter {
        private final ResourceFilter instance;

        public PredefinedFilterAdapter(ResourceFilter instance) {
            this.instance = instance;
        }

        @Override
        protected ResourceFilter createInstance(Class<? extends ResourceFilter> type) throws Exception {
            return this.instance;
        }
    }

    public static class GeneralAdapter
    extends TypeAdapter<ResourceFilter> {
        protected transient Class<? extends ResourceFilter> type = null;
        protected transient GeneralAdapter delegate = null;

        protected void writeValues(JsonWriter writer, ResourceFilter value) throws IOException {
            String typeName = ResourceFilterMapping.getTypeName(value);
            writer.name(JsonValues.type.name()).value(typeName);
        }

        @Override
        public void write(JsonWriter writer, ResourceFilter value) throws IOException {
            writer.beginObject();
            this.writeValues(writer, value);
            writer.endObject();
        }

        protected ResourceFilter createInstance(Class<? extends ResourceFilter> type) throws Exception {
            ResourceFilter result = type.newInstance();
            return result;
        }

        protected Object parseValue(JsonReader reader, String name) throws IOException {
            switch (JsonValues.valueOf(name)) {
                case type: {
                    TypeAdapter<? extends ResourceFilter> adapter;
                    try {
                        this.type = ResourceFilterMapping.getType(reader.nextString());
                    }
                    catch (Exception ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                        throw new IOException(ex);
                    }
                    if (this.type != null && (adapter = GSON.getAdapter(this.type)) instanceof GeneralAdapter) {
                        this.delegate = (GeneralAdapter)adapter;
                    }
                    return this.type;
                }
            }
            return null;
        }

        @Override
        public ResourceFilter read(JsonReader reader) throws IOException {
            ResourceFilter result = null;
            this.type = null;
            this.delegate = null;
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                if (this.delegate != null) {
                    this.delegate.parseValue(reader, name);
                    continue;
                }
                this.parseValue(reader, name);
            }
            reader.endObject();
            if (this.type != null) {
                try {
                    result = this.delegate != null ? this.delegate.createInstance(this.type) : this.createInstance(this.type);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    throw new IOException(ex.toString());
                }
            }
            return result;
        }

        static enum JsonValues {
            type,
            filter;

        }
    }
}

