/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.script;

import com.composum.sling.core.util.ResourceUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.transform.ThreadInterrupt;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.QueryManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyRunner {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyRunner.class);
    public static final String DEFAULT_SETUP_SCRIPT = "script/setup.groovy";
    public static final String JAVA_RESOURCE_BASE = "/com/composum/sling/core/";
    public static final String ENCODING = "UTF-8";
    protected BundleContext bundleContext;
    protected ResourceResolverFactory resourceResolverFactory;
    protected ResourceResolver resourceResolver;
    protected Session session;
    protected Workspace workspace;
    protected QueryManager queryManager;
    protected PrintWriter out;
    protected Map<String, Object> generalBindings = new HashMap<String, Object>();
    protected String setupScript;

    public GroovyRunner(Session session, PrintWriter out) {
        this(session, out, DEFAULT_SETUP_SCRIPT);
    }

    public GroovyRunner(Session session, PrintWriter out, String setupScript) {
        this.out = out;
        this.session = session;
        this.setupScript = setupScript;
        if (session != null) {
            this.bundleContext = this.getBundleContext();
            this.resourceResolverFactory = this.getResourceResolverFactory();
            this.resourceResolver = this.getResolver();
            this.workspace = session.getWorkspace();
            this.queryManager = this.getQueryManager(this.workspace);
        }
        this.generalBindings.put("out", out);
        this.generalBindings.put("log", LOG);
        this.generalBindings.put("bundleContext", this.bundleContext);
        this.generalBindings.put("resourceResolverFactory", this.resourceResolverFactory);
        this.generalBindings.put("resourceResolver", this.resourceResolver);
        this.generalBindings.put("session", session);
        this.generalBindings.put("workspace", this.workspace);
        this.generalBindings.put("queryManager", this.queryManager);
    }

    public Object run(String path, Map<String, Object> variables) throws InterruptedException {
        Object result = null;
        try (Reader reader = this.getScriptResource(path);){
            if (reader != null) {
                result = this.run(reader, variables, path.substring(path.lastIndexOf(47) + 1));
            }
        }
        catch (IOException ioex) {
            LOG.error(ioex.getMessage(), (Throwable)ioex);
        }
        return result;
    }

    public Object run(Reader scriptReader, Map<String, Object> variables) throws InterruptedException {
        return this.run(scriptReader, variables, null);
    }

    public Object run(Reader scriptReader, Map<String, Object> variables, String name) throws InterruptedException {
        Script script = this.getScript(scriptReader, variables, name);
        Object setupVariables = this.setup(script);
        this.extendBinding(script, setupVariables);
        this.extendBinding(script, this.generalBindings);
        Object result = script.run();
        return result;
    }

    protected Script getScript(Reader scriptReader, Map<String, Object> variables, String name) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(ThreadInterrupt.class)});
        Binding binding = new Binding(variables);
        GroovyShell shell = new GroovyShell(binding, compilerConfig);
        if (name == null) {
            return shell.parse(scriptReader);
        }
        return shell.parse(scriptReader, name);
    }

    protected void extendBinding(Script script, Object variables) {
        this.extendBinding(script.getBinding(), variables);
    }

    protected void extendBinding(Binding binding, Object variables) {
        if (variables instanceof Map) {
            for (Map.Entry entry : ((Map)variables).entrySet()) {
                String name = (String)entry.getKey();
                try {
                    if (binding.getVariable(name) != null) continue;
                    binding.setVariable(name, entry.getValue());
                }
                catch (MissingPropertyException mpex) {
                    binding.setVariable(name, entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object setup(Script script) {
        Object result = null;
        Reader reader = this.getScriptResource(this.setupScript);
        if (reader != null) {
            try {
                try {
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put("script", script);
                    variables.put("log", LOG);
                    variables.put("out", this.out);
                    Script setupScript = this.getScript(reader, variables, this.setupScript.substring(this.setupScript.lastIndexOf(47) + 1));
                    this.extendBinding(setupScript, this.generalBindings);
                    result = setupScript.run();
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ioex) {
                LOG.error(ioex.getMessage(), (Throwable)ioex);
            }
        }
        return result;
    }

    protected Reader getScriptResource(String path) {
        InputStream stream;
        Binary binary;
        Resource scriptResource;
        InputStreamReader reader = null;
        if (this.resourceResolver != null && (scriptResource = this.resourceResolver.getResource(path)) != null && (binary = ResourceUtil.getBinaryData(scriptResource)) != null) {
            try {
                InputStream inputStream = binary.getStream();
                if (inputStream != null) {
                    reader = new InputStreamReader(inputStream, ENCODING);
                }
            }
            catch (UnsupportedEncodingException | RepositoryException ueex) {
                LOG.error(ueex.getMessage(), ueex);
            }
        }
        if (reader == null && (stream = this.getClass().getResourceAsStream(JAVA_RESOURCE_BASE + path)) != null) {
            try {
                reader = new InputStreamReader(stream, ENCODING);
            }
            catch (UnsupportedEncodingException ueex) {
                LOG.error(ueex.getMessage(), (Throwable)ueex);
            }
        }
        return reader;
    }

    protected BundleContext getBundleContext() {
        Bundle resourceResolverBundle = FrameworkUtil.getBundle(ResourceResolverFactory.class);
        BundleContext bundleContext = resourceResolverBundle.getBundleContext();
        return bundleContext;
    }

    protected ResourceResolverFactory getResourceResolverFactory() {
        ServiceReference resourceResolverFactoryReference = this.bundleContext.getServiceReference(ResourceResolverFactory.class);
        ResourceResolverFactory resourceResolverFactory = (ResourceResolverFactory)this.bundleContext.getService(resourceResolverFactoryReference);
        return resourceResolverFactory;
    }

    protected ResourceResolver getResolver() {
        ResourceResolver resolver = null;
        HashMap<String, Session> authMap = new HashMap<String, Session>();
        authMap.put("user.jcr.session", this.session);
        try {
            resolver = this.resourceResolverFactory.getResourceResolver(authMap);
        }
        catch (LoginException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return resolver;
    }

    protected QueryManager getQueryManager(Workspace workspace) {
        QueryManager queryManager = null;
        try {
            queryManager = workspace.getQueryManager();
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return queryManager;
    }
}

