/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service.impl;

import com.composum.sling.core.service.PermissionsService;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composum Nodes Permissions Service"})
public class CorePermissionsService
implements PermissionsService {
    private static final Logger LOG = LoggerFactory.getLogger(CorePermissionsService.class);

    @Override
    public String isMemberOfOne(Session session, String ... authorizableIds) {
        try {
            UserManager userManager = ((JackrabbitSession)session).getUserManager();
            Authorizable user = userManager.getAuthorizable(session.getUserID());
            for (String authorizableId : authorizableIds) {
                Authorizable authorizable = userManager.getAuthorizable(authorizableId);
                if (!(authorizable instanceof Group) || !((Group)authorizable).isMember(user)) continue;
                return authorizableId;
            }
            if (user instanceof User && ((User)user).isAdmin()) {
                return "";
            }
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @Override
    public boolean isMemberOfAll(Session session, String ... authorizableIds) {
        try {
            UserManager userManager = ((JackrabbitSession)session).getUserManager();
            Authorizable user = userManager.getAuthorizable(session.getUserID());
            if (user instanceof User && ((User)user).isAdmin()) {
                return true;
            }
            for (String authorizableId : authorizableIds) {
                Authorizable authorizable = userManager.getAuthorizable(authorizableId);
                if (authorizable instanceof Group && ((Group)authorizable).isMember(user)) continue;
                return false;
            }
            return true;
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public String hasOneOfPrivileges(Session session, String path, String ... privilegeKeys) {
        try {
            Privilege[] privileges;
            AccessControlManager acManager = session.getAccessControlManager();
            for (Privilege privilege : privileges = AccessControlUtils.privilegesFromNames((AccessControlManager)acManager, (String[])privilegeKeys)) {
                if (!acManager.hasPrivileges(path, new Privilege[]{privilege})) continue;
                return privilege.getName();
            }
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @Override
    public boolean hasAllPrivileges(Session session, String path, String ... privilegeKeys) {
        try {
            AccessControlManager acManager = session.getAccessControlManager();
            Privilege[] privileges = AccessControlUtils.privilegesFromNames((AccessControlManager)acManager, (String[])privilegeKeys);
            return acManager.hasPrivileges(path, privileges);
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

