/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service.impl;

import com.composum.sling.core.service.RepositorySetupService;
import com.composum.sling.core.util.ValueEmbeddingReader;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

@Component(property={"service.description=Composum Nodes Security Service"})
public class CoreRepositorySetupService
implements RepositorySetupService {
    private static final Logger LOG = LoggerFactory.getLogger(CoreRepositorySetupService.class);
    public static final ThreadLocal<Tracker> TRACKER = new ThreadLocal();

    @Override
    public void addJsonAcl(@Nonnull Session session, @Nonnull String jsonFilePath, @Nullable Map<String, Object> values) throws RepositoryException, IOException {
        block25: {
            Node jsonFileNode = session.getNode(jsonFilePath);
            if (jsonFileNode != null) {
                Property property = jsonFileNode.getNode("jcr:content").getProperty("jcr:data");
                try (InputStream stream = property.getBinary().getStream();
                     InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    this.addJsonAcl(session, streamReader, values);
                    break block25;
                }
            }
            throw new IOException("configuration file node not found (" + jsonFilePath + ")");
        }
    }

    @Override
    public void addJsonAcl(@Nonnull Session session, @Nonnull Reader reader, @Nullable Map<String, Object> values) throws RepositoryException, IOException {
        try (JsonReader jsonReader = new JsonReader(values != null ? new ValueEmbeddingReader(reader, values) : reader);){
            if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                jsonReader.beginArray();
                while (jsonReader.peek() != JsonToken.END_ARRAY) {
                    this.addAclObject(session, jsonReader);
                }
                jsonReader.endArray();
            } else {
                this.addAclObject(session, jsonReader);
            }
        }
    }

    @Override
    public void removeJsonAcl(@Nonnull Session session, @Nonnull String jsonFilePath, @Nullable Map<String, Object> values) throws RepositoryException, IOException {
        block25: {
            Node jsonFileNode = session.getNode(jsonFilePath);
            if (jsonFileNode != null) {
                Property property = jsonFileNode.getNode("jcr:content").getProperty("jcr:data");
                try (InputStream stream = property.getBinary().getStream();
                     InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    this.removeJsonAcl(session, streamReader, values);
                    break block25;
                }
            }
            throw new IOException("configuration file node not found (" + jsonFilePath + ")");
        }
    }

    @Override
    public void removeJsonAcl(@Nonnull Session session, @Nonnull Reader reader, @Nullable Map<String, Object> values) throws RepositoryException, IOException {
        try (JsonReader jsonReader = new JsonReader(values != null ? new ValueEmbeddingReader(reader, values) : reader);){
            if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                jsonReader.beginArray();
                while (jsonReader.peek() != JsonToken.END_ARRAY) {
                    this.removeAclObject(session, jsonReader);
                }
                jsonReader.endArray();
            } else {
                this.removeAclObject(session, jsonReader);
            }
        }
    }

    protected void addAclObject(@Nonnull Session session, @Nonnull JsonReader reader) throws RepositoryException {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(reader, (Type)((Object)Map.class));
        Object location = map.get("path");
        if (location != null) {
            String primaryType = (String)map.get("jcr:primaryType");
            Object acl = map.get("acl");
            Boolean reset = (Boolean)map.get("reset");
            List<String> paths = location instanceof List ? (List<String>)location : Collections.singletonList(location.toString());
            for (String path : paths) {
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                LOG.debug("addAclObject({})...", (Object)path);
                if (StringUtils.isNotBlank((CharSequence)primaryType)) {
                    this.makeNodeAvailable(session, path, primaryType);
                }
                if (acl != null) {
                    if (reset != null && reset.booleanValue()) {
                        this.info("reset ACL({})...", path);
                        this.removeAcRule(session, path, null);
                    }
                    this.addAcList(session, path, acl instanceof List ? (List<Map<String, Object>>)acl : Collections.singletonList((Map)acl));
                    continue;
                }
                this.info("remove ACL({})...", path);
                this.removeAcRule(session, path, null);
            }
        }
    }

    protected void removeAclObject(@Nonnull Session session, @Nonnull JsonReader reader) throws RepositoryException {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(reader, (Type)((Object)Map.class));
        Object location = map.get("path");
        if (location != null) {
            String primaryType = (String)map.get("jcr:primaryType");
            List acl = (List)map.get("acl");
            List<String> paths = location instanceof List ? (List<String>)location : Collections.singletonList(location.toString());
            for (String path : paths) {
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                LOG.debug("removeAclObject({})...", (Object)path);
                if (acl != null) {
                    this.removeAcList(session, path, acl);
                } else {
                    this.removeAcRule(session, path, null);
                }
                if (!StringUtils.isNotBlank((CharSequence)primaryType)) continue;
                this.removeNode(session, path);
            }
        }
    }

    protected void addAcList(@Nonnull Session session, @Nonnull String path, @Nonnull List<Map<String, Object>> list) throws RepositoryException {
        this.info("addAcList({})...", path);
        for (Map map : list) {
            Object principalRule = map.get("principal");
            if (principalRule == null) continue;
            String groupPath = (String)map.get("groupPath");
            List memberOf = (List)map.get("memberOf");
            Boolean reset = (Boolean)map.get("reset");
            Object ruleSet = map.get("rule");
            if (ruleSet == null && (ruleSet = map.get("rules")) == null && (ruleSet = map.get("acl")) == null) {
                reset = true;
            }
            for (String principal : principalRule instanceof List ? (List<String>)principalRule : Collections.singletonList(principalRule.toString())) {
                if (!StringUtils.isNotBlank((CharSequence)principal)) continue;
                if (reset != null && reset.booleanValue()) {
                    this.info("reset ACL({},{})...", path, principal);
                    this.removeAcRule(session, path, principal);
                }
                if (StringUtils.isNotBlank((CharSequence)groupPath)) {
                    this.makeGroupAvailable(session, principal, groupPath);
                }
                if (memberOf != null) {
                    this.makeMemberAvailable(session, principal, memberOf);
                }
                List<Map> rules = ruleSet instanceof List ? (List<Map>)ruleSet : Collections.singletonList(ruleSet != null ? (Map)ruleSet : map);
                for (Map rule : rules) {
                    boolean grant = true;
                    Object object = rule.get("grant");
                    if (object == null) {
                        object = rule.get("deny");
                        if (object != null) {
                            grant = false;
                        } else {
                            object = rule.get("privileges");
                            Object allow = rule.get("allow");
                            grant = allow == null || allow instanceof Boolean && (Boolean)allow != false;
                        }
                    }
                    String[] privileges = null;
                    if (object instanceof List) {
                        List privList = (List)object;
                        privileges = privList.toArray(new String[0]);
                    } else if (object instanceof String) {
                        privileges = new String[]{(String)object};
                    }
                    if (privileges == null) continue;
                    object = rule.get("restrictions");
                    if (object != null) {
                        if (object instanceof List) {
                            for (Map restrictions : (List)object) {
                                this.addAcRule(session, path, principal, grant, privileges, restrictions);
                            }
                            continue;
                        }
                        this.addAcRule(session, path, principal, grant, privileges, (Map)object);
                        continue;
                    }
                    this.addAcRule(session, path, principal, grant, privileges, Collections.EMPTY_MAP);
                }
            }
        }
    }

    protected void removeAcList(@Nonnull Session session, @Nonnull String path, @Nonnull List<Map<String, Object>> list) throws RepositoryException {
        this.info("delAcList({})...", path);
        for (Map<String, Object> map : list) {
            String groupPath;
            String principal = (String)map.get("principal");
            if (!StringUtils.isNotBlank((CharSequence)principal)) continue;
            List acl = (List)map.get("acl");
            this.removeAcRule(session, path, principal);
            List memberOf = (List)map.get("memberOf");
            if (memberOf != null) {
                this.removeMember(session, principal, memberOf);
            }
            if (!StringUtils.isNotBlank((CharSequence)(groupPath = (String)map.get("groupPath")))) continue;
            this.removeGroup(session, principal);
        }
    }

    protected void addAcRule(@Nonnull Session session, @Nonnull String path, @Nonnull String principalName, boolean allow, @Nonnull String[] privilegeKeys, @Nonnull Map<String, Object> restrictionKeys) throws RepositoryException {
        try {
            AccessControlManager acManager = session.getAccessControlManager();
            PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
            JackrabbitAccessControlList policies = AccessControlUtils.getAccessControlList((AccessControlManager)acManager, (String)path);
            Principal principal = principalManager.getPrincipal(principalName);
            Privilege[] privileges = AccessControlUtils.privilegesFromNames((AccessControlManager)acManager, (String[])privilegeKeys);
            HashMap<String, Value> restrictions = new HashMap<String, Value>();
            ValueFactory valueFactory = session.getValueFactory();
            for (String key : restrictionKeys.keySet()) {
                restrictions.put(key, valueFactory.createValue((String)restrictionKeys.get(key), policies.getRestrictionType(key)));
            }
            policies.addEntry(principal, privileges, allow, restrictions);
            this.info("addAcRule({},{},{},{})", principalName, allow ? "grant" : "deny", Arrays.toString(privilegeKeys), restrictionKeys);
            acManager.setPolicy(path, (AccessControlPolicy)policies);
        }
        catch (Exception e) {
            this.error("Error in addAcRule({},{},{},{}, {}) : {}", path, principalName, allow, Arrays.asList(privilegeKeys), restrictionKeys, e.toString());
            throw e;
        }
    }

    protected void removeAcRule(@Nonnull Session session, @Nonnull String path, @Nullable String principal) throws RepositoryException {
        try {
            AccessControlManager acManager = session.getAccessControlManager();
            JackrabbitAccessControlList policy = null;
            try {
                policy = AccessControlUtils.getAccessControlList((AccessControlManager)acManager, (String)path);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (policy != null) {
                for (AccessControlEntry entry : policy.getAccessControlEntries()) {
                    JackrabbitAccessControlEntry jrEntry = (JackrabbitAccessControlEntry)entry;
                    if (principal != null && !principal.equals(jrEntry.getPrincipal().getName())) continue;
                    this.info("delAcRule({},{},{})", entry.getPrincipal().getName(), jrEntry.isAllow() ? "grant" : "deny", Arrays.toString(entry.getPrivileges()));
                    policy.removeAccessControlEntry(entry);
                }
                acManager.setPolicy(path, (AccessControlPolicy)policy);
                if (policy.isEmpty()) {
                    acManager.removePolicy(path, (AccessControlPolicy)policy);
                }
            }
        }
        catch (RepositoryException e) {
            this.error("Error in removeAcl({},{}) : {}", path, principal, e.toString());
            throw e;
        }
    }

    protected Node makeNodeAvailable(@Nonnull Session session, @Nonnull String path, @Nonnull String primaryType) throws RepositoryException {
        Node node;
        try {
            node = session.getNode(StringUtils.isNotBlank((CharSequence)path) ? path : "/");
        }
        catch (PathNotFoundException nf) {
            this.info("createNode({},{})", path, primaryType);
            Node parent = this.makeNodeAvailable(session, StringUtils.substringBeforeLast((String)path, (String)"/"), primaryType);
            node = parent.addNode(StringUtils.substringAfterLast((String)path, (String)"/"), primaryType);
        }
        catch (RepositoryException e) {
            this.error("Error in makeNodeAvailable({},{}) : {}", path, primaryType, e.toString());
            throw e;
        }
        return node;
    }

    protected void removeNode(@Nonnull Session session, @Nonnull String path) throws RepositoryException {
        try {
            Node node = session.getNode(path);
            this.info("removeNode({})", path);
            node.remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException e) {
            this.error("Error in removeNode({}) : {}", path, e.toString());
            throw e;
        }
    }

    protected Authorizable makeGroupAvailable(@Nonnull Session session, @Nonnull String id, @Nonnull String intermediatePath) throws RepositoryException {
        UserManager userManager = ((JackrabbitSession)session).getUserManager();
        Authorizable authorizable = userManager.getAuthorizable(id);
        if (authorizable != null) {
            if (authorizable.isGroup()) {
                return authorizable;
            }
            throw new RepositoryException("'" + id + "' exists but is not a group");
        }
        this.info("addGroup({},{})", id, intermediatePath);
        try {
            authorizable = userManager.createGroup(() -> id, intermediatePath);
            session.save();
        }
        catch (RepositoryException e) {
            this.error("Error in makeGroupAvailable({},{}) : {}", id, intermediatePath, e.toString());
            throw e;
        }
        return authorizable;
    }

    protected void removeGroup(@Nonnull Session session, @Nonnull String id) throws RepositoryException {
        try {
            UserManager userManager = ((JackrabbitSession)session).getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(id);
            if (authorizable != null && authorizable.isGroup()) {
                this.info("removeGroup({})", id);
                authorizable.remove();
            }
        }
        catch (RepositoryException e) {
            this.error("Error in removeGroup({}): {}", id, e.toString());
            throw e;
        }
    }

    protected void makeMemberAvailable(@Nonnull Session session, @Nonnull String memberId, @Nonnull List<String> groupIds) throws RepositoryException {
        try {
            UserManager userManager = ((JackrabbitSession)session).getUserManager();
            Authorizable member = userManager.getAuthorizable(memberId);
            if (member != null) {
                for (String groupId : groupIds) {
                    Group group;
                    Authorizable authorizable = userManager.getAuthorizable(groupId);
                    if (authorizable == null || !authorizable.isGroup() || (group = (Group)authorizable).isMember(member)) continue;
                    this.info("addMember({},{})", memberId, groupId);
                    group.addMember(member);
                    session.save();
                }
            }
        }
        catch (RepositoryException e) {
            this.error("Error in makeMemberAvailable({},{}) : {}", memberId, groupIds, e.toString());
            throw e;
        }
    }

    protected void removeMember(@Nonnull Session session, @Nonnull String memberId, @Nonnull List<String> groupIds) throws RepositoryException {
        try {
            UserManager userManager = ((JackrabbitSession)session).getUserManager();
            Authorizable member = userManager.getAuthorizable(memberId);
            if (member != null) {
                for (String groupId : groupIds) {
                    Group group;
                    Authorizable authorizable = userManager.getAuthorizable(groupId);
                    if (authorizable == null || !authorizable.isGroup() || !(group = (Group)authorizable).isMember(member)) continue;
                    this.info("removeMember({},{})", memberId, groupId);
                    group.removeMember(member);
                    session.save();
                }
            }
        }
        catch (RepositoryException e) {
            this.error("Error in removeMember({},{}) : {}", memberId, groupIds, e.toString());
            throw e;
        }
    }

    protected void info(String pattern, Object ... args) {
        LOG.info(pattern, args);
        Tracker tracker = TRACKER.get();
        if (tracker != null) {
            tracker.info(MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage());
        }
    }

    protected void warn(String pattern, Object ... args) {
        LOG.warn(pattern, args);
        Tracker tracker = TRACKER.get();
        if (tracker != null) {
            tracker.warn(MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage());
        }
    }

    protected void error(String pattern, Object ... args) {
        LOG.error(pattern, args);
        Tracker tracker = TRACKER.get();
        if (tracker != null) {
            tracker.error(MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage());
        }
    }

    public static interface Tracker {
        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);
    }
}

