/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.service.PermissionsService;
import com.composum.sling.core.util.XSS;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Core Permissions Servlet", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.selectors=cpm.permissions", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public class CorePermissionsServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CorePermissionsServlet.class);
    @Reference
    private PermissionsService permissionsService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Boolean checkResult = null;
        String userId = null;
        String path = null;
        ArrayList<String> memberOf = new ArrayList<String>();
        ArrayList<String> privilege = new ArrayList<String>();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (session != null) {
            String[] privilegeValues;
            userId = session.getUserID();
            RequestPathInfo pathInfo = request.getRequestPathInfo();
            List<String> selectors = Arrays.asList(pathInfo.getSelectors());
            String[] memberValues = XSS.filter(request.getParameterValues("member"));
            if (memberValues != null) {
                for (String members : memberValues) {
                    String found;
                    if (checkResult != null && !checkResult.booleanValue() || !(checkResult = Boolean.valueOf((found = this.permissionsService.isMemberOfOne(session, StringUtils.split((String)members, (String)","))) != null)).booleanValue()) continue;
                    memberOf.add(found);
                }
            }
            if ((checkResult == null || checkResult.booleanValue()) && (privilegeValues = XSS.filter(request.getParameterValues("privilege"))) != null) {
                Resource resource;
                path = XSS.filter(request.getParameter("path"));
                if (StringUtils.isBlank((CharSequence)path)) {
                    path = XSS.filter(pathInfo.getSuffix());
                }
                if (StringUtils.isBlank((CharSequence)path) && (resource = request.getResource()) != null) {
                    path = resource.getPath();
                }
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    for (String privileges : privilegeValues) {
                        String found;
                        if (checkResult != null && !checkResult.booleanValue() || !(checkResult = Boolean.valueOf((found = this.permissionsService.hasOneOfPrivileges(session, path, StringUtils.split((String)privileges, (String)","))) != null)).booleanValue()) continue;
                        privilege.add(found);
                    }
                }
            }
        }
        response.setStatus(200);
        response.setContentType("application/json; charset=UTF-8");
        JsonWriter writer = new JsonWriter(response.getWriter());
        writer.beginObject();
        writer.name("result").value(checkResult != null && checkResult != false);
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            writer.name("userId").value(userId);
        }
        if (StringUtils.isNotBlank(path)) {
            writer.name("path").value(path);
        }
        if (memberOf.size() > 0) {
            writer.name("memberOf").beginArray();
            for (String value : memberOf) {
                writer.value(value);
            }
            writer.endArray();
        }
        if (privilege.size() > 0) {
            writer.name("privilege").beginArray();
            for (String value : privilege) {
                writer.value(value);
            }
            writer.endArray();
        }
        writer.endObject();
    }
}

