/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.service.RepositorySetupService;
import com.composum.sling.core.service.impl.CoreRepositorySetupService;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Setup Servlet", "sling.servlet.paths=/bin/cpm/nodes/setup", "sling.servlet.methods=POST", "sling.auth.requirements=/bin/cpm/nodes/setup"})
public class SetupServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SetupServlet.class);
    public static final String SERVLET_PATH = "/bin/cpm/nodes/setup";
    public static final String PN_WARNINGS = "warnings";
    public static final String PN_ERRORS = "errors";
    @Reference
    private CoreConfiguration coreConfig;
    @Reference
    private RepositorySetupService setupService;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet(Extension.txt);

    @Override
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    @Override
    protected boolean isEnabled() {
        return this.coreConfig.isEnabled(this);
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.txt, Operation.run, new RunSetupScripts());
    }

    public class RunSetupScripts
    implements ServletOperation {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doIt(@Nonnull SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            int sumWarnings;
            int sumErrors;
            PrintWriter writer;
            block6: {
                response.setContentType("text/plain;charset=utf-8");
                writer = response.getWriter();
                sumErrors = 0;
                sumWarnings = 0;
                try {
                    ResourceResolver resolver;
                    Session session;
                    String[] scripts = request.getParameterValues("script");
                    if (scripts == null || (session = (Session)(resolver = request.getResourceResolver()).adaptTo(Session.class)) == null) break block6;
                    for (String script : scripts) {
                        writer.println("running script '" + script + "'...");
                        final HashMap<String, Object> status = new HashMap<String, Object>(){
                            {
                                this.put(SetupServlet.PN_WARNINGS, 0);
                                this.put(SetupServlet.PN_ERRORS, 0);
                            }
                        };
                        try {
                            CoreRepositorySetupService.TRACKER.set(new CoreRepositorySetupService.Tracker(){

                                @Override
                                public void info(String message) {
                                    writer.println("I " + message);
                                }

                                @Override
                                public void warn(String message) {
                                    status.put(SetupServlet.PN_WARNINGS, (Integer)status.get(SetupServlet.PN_WARNINGS) + 1);
                                    writer.println("W " + message);
                                }

                                @Override
                                public void error(String message) {
                                    status.put(SetupServlet.PN_ERRORS, (Integer)status.get(SetupServlet.PN_ERRORS) + 1);
                                    writer.println("E " + message);
                                }
                            });
                            SetupServlet.this.setupService.addJsonAcl(session, script, null);
                        }
                        finally {
                            CoreRepositorySetupService.TRACKER.set(null);
                        }
                        int warnings = (Integer)status.get(SetupServlet.PN_WARNINGS);
                        int errors = (Integer)status.get(SetupServlet.PN_ERRORS);
                        sumWarnings += warnings;
                        sumErrors += errors;
                        writer.println("done script '" + script + "' (warnings: " + warnings + ", errors: " + errors + ").");
                    }
                }
                catch (Exception ex) {
                    ++sumErrors;
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    writer.println("ERROR: " + ex.toString());
                }
            }
            writer.println("finished (warnings: " + sumWarnings + ", errors: " + sumErrors + ").");
            writer.flush();
        }
    }

    public static enum Operation {
        run;

    }

    public static enum Extension {
        txt;

    }
}

