/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.exception.PropertyValueFormatException;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.PropertyUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.UrlCodec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtil.class);
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder();
    protected static final Gson GSON = GSON_BUILDER.create();

    public static Map<String, Object> jsonMap(JsonReader reader) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        reader.beginObject();
        while (reader.hasNext() && reader.peek() == JsonToken.NAME) {
            String name = reader.nextName();
            Object value = JsonUtil.jsonValue(reader);
            if (value == null) continue;
            map.put(name, value);
        }
        reader.endObject();
        return map;
    }

    public static Object jsonValue(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case STRING: {
                return reader.nextString();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NUMBER: {
                try {
                    return reader.nextLong();
                }
                catch (NumberFormatException nfex) {
                    return reader.nextDouble();
                }
            }
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.peek() != JsonToken.END_ARRAY) {
                    list.add(JsonUtil.jsonValue(reader));
                }
                reader.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                return JsonUtil.jsonMap(reader);
            }
        }
        reader.skipValue();
        return null;
    }

    public static void jsonMap(@Nonnull JsonWriter writer, @Nullable Map<String, Object> map) throws IOException {
        if (map != null) {
            writer.beginObject();
            JsonUtil.jsonMapEntries(writer, map);
            writer.endObject();
        }
    }

    public static void jsonMapEntries(@Nonnull JsonWriter writer, @Nullable Map<String, Object> map) throws IOException {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                writer.name(entry.getKey());
                JsonUtil.jsonValue(writer, entry.getValue());
            }
        }
    }

    public static void jsonValue(@Nonnull JsonWriter writer, @Nullable Object value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else if (value instanceof Map) {
            JsonUtil.jsonMap(writer, (Map)value);
        } else if (value instanceof Collection) {
            writer.beginArray();
            for (Object val : (Collection)value) {
                JsonUtil.jsonValue(writer, val);
            }
            writer.endArray();
        } else if (value instanceof Object[]) {
            writer.beginArray();
            for (Object val : (Object[])value) {
                JsonUtil.jsonValue(writer, val);
            }
            writer.endArray();
        } else if (value instanceof Boolean) {
            writer.value((Boolean)value);
        } else if (value instanceof Long) {
            writer.value((Long)value);
        } else if (value instanceof Double) {
            writer.value((Double)value);
        } else if (value instanceof Number) {
            writer.value((Number)value);
        } else {
            writer.value(value.toString());
        }
    }

    public static void exportJson(@Nonnull JsonWriter writer, @Nonnull Resource resource) throws RepositoryException, IOException {
        JsonUtil.exportJson(writer, resource, MappingRules.getDefaultMappingRules());
    }

    public static void exportJson(@Nonnull JsonWriter writer, @Nonnull Resource resource, MappingRules mapping) throws RepositoryException, IOException {
        JsonUtil.exportJson(writer, resource, mapping, 1);
    }

    public static void exportJson(JsonWriter writer, Resource resource, MappingRules mapping, int depth) throws RepositoryException, IOException {
        if (resource != null) {
            writer.beginObject();
            JsonUtil.exportProperties(writer, resource, mapping);
            if (mapping.maxDepth == 0 || depth < mapping.maxDepth) {
                ++depth;
                for (Resource child : resource.getChildren()) {
                    if (!mapping.resourceFilter.accept(child)) continue;
                    writer.name(child.getName());
                    JsonUtil.exportJson(writer, child, mapping, depth);
                }
            }
            writer.endObject();
        }
    }

    public static void exportProperties(@Nonnull JsonWriter writer, @Nonnull Resource resource, MappingRules mapping) throws RepositoryException, IOException {
        String path = resource.getPath();
        Node node = (Node)resource.adaptTo(Node.class);
        TreeMap<String, Object> propertiesSet = new TreeMap<String, Object>();
        if (node != null) {
            PropertyIterator iterator = node.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                propertiesSet.put(property.getName(), property);
            }
        } else {
            ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
            for (Map.Entry entry : properties.entrySet()) {
                propertiesSet.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (mapping.propertyFormat.scope != MappingRules.PropertyFormat.Scope.value) {
            writer.name("_properties_");
            writer.beginArray();
        }
        for (Map.Entry entry : propertiesSet.entrySet()) {
            String name = (String)entry.getKey();
            if (!mapping.exportPropertyFilter.accept(name)) continue;
            Object value = entry.getValue();
            if (value instanceof Property) {
                Property property = (Property)value;
                JsonUtil.writeJsonProperty(resource, writer, property, mapping);
                continue;
            }
            JsonUtil.writeJsonProperty(resource, writer, name, value, mapping);
        }
        if (mapping.propertyFormat.scope != MappingRules.PropertyFormat.Scope.value) {
            writer.endArray();
        }
    }

    public static void exportChildOrderProperty(JsonWriter writer, Resource resource) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        Iterable children = resource.getChildren();
        for (Resource child : children) {
            String name = child.getName();
            if ("jcr:content".equals(name)) continue;
            names.add(name);
        }
        if (names.size() > 0) {
            writer.name("_child_order_");
            writer.beginArray();
            for (String name : names) {
                if ("jcr:content".equals(name)) continue;
                writer.value(name);
            }
            writer.endArray();
        }
    }

    public static Resource importJson(JsonReader reader, ResourceResolver resolver, String path) throws RepositoryException, IOException {
        return JsonUtil.importJson(reader, resolver, path, MappingRules.getDefaultMappingRules());
    }

    public static Resource importJson(JsonReader reader, ResourceResolver resolver, String path, MappingRules mapping) throws RepositoryException, IOException {
        Node node;
        Session session = (Session)Objects.requireNonNull(resolver.adaptTo(Session.class));
        ValueFactory factory = session.getValueFactory();
        Resource resource = resolver.getResource(path);
        ArrayList<String> childrenSet = new ArrayList<String>();
        HashMap<String, JsonProperty> propertiesSet = new HashMap<String, JsonProperty>();
        reader.beginObject();
        while (reader.hasNext()) {
            JsonProperty property;
            JsonToken token;
            String name = reader.nextName();
            if ("_properties_".equals(name)) {
                reader.beginArray();
                while ((token = reader.peek()) != JsonToken.END_ARRAY) {
                    switch (token) {
                        case BEGIN_OBJECT: {
                            property = (JsonProperty)GSON.fromJson(reader, (Type)((Object)JsonProperty.class));
                            if (resource != null) {
                                if (!JsonUtil.importJsonProperty(factory, resource, property, mapping)) break;
                                propertiesSet.put(property.name, property);
                                break;
                            }
                            propertiesSet.put(property.name, property);
                        }
                    }
                }
                reader.endArray();
                continue;
            }
            property = null;
            token = reader.peek();
            switch (token) {
                case BEGIN_OBJECT: {
                    try {
                        if (resource == null) {
                            resource = JsonUtil.createResource(resolver, path, propertiesSet, factory, mapping);
                        }
                        JsonUtil.importJson(reader, resolver, path + "/" + name, mapping);
                    }
                    catch (ConstraintViolationException cvex) {
                        LOG.error(cvex.getMessage() + " (" + path + "/" + name + ")", (Throwable)cvex);
                    }
                    childrenSet.add(name);
                    break;
                }
                case BEGIN_ARRAY: {
                    reader.beginArray();
                    if (reader.peek() != JsonToken.END_ARRAY) {
                        if (!"_child_order_".equals(name)) {
                            property = JsonUtil.parseJsonProperty(reader, name);
                            ArrayList<Object> values = new ArrayList<Object>();
                            values.add(property.value);
                            while ((token = reader.peek()) != JsonToken.END_ARRAY) {
                                switch (token) {
                                    case BOOLEAN: {
                                        values.add(reader.nextBoolean());
                                        break;
                                    }
                                    case NUMBER: {
                                        values.add(reader.nextLong());
                                        break;
                                    }
                                    case STRING: {
                                        values.add(JsonUtil.parseJsonString(reader, property));
                                        break;
                                    }
                                    case NULL: {
                                        reader.nextNull();
                                    }
                                }
                            }
                            property.value = values.toArray();
                            property.multi = true;
                        } else {
                            while (reader.peek() != JsonToken.END_ARRAY) {
                                reader.nextString();
                            }
                        }
                    }
                    reader.endArray();
                    break;
                }
                default: {
                    property = JsonUtil.parseJsonProperty(reader, name);
                }
            }
            if (property == null) continue;
            if (resource != null) {
                if (!JsonUtil.importJsonProperty(factory, resource, property, mapping)) continue;
                propertiesSet.put(property.name, property);
                continue;
            }
            propertiesSet.put(property.name, property);
        }
        reader.endObject();
        if (resource == null) {
            resource = JsonUtil.createResource(resolver, path, propertiesSet, factory, mapping);
        }
        if (mapping.changeRule == MappingRules.ChangeRule.update && (node = (Node)resource.adaptTo(Node.class)) != null && !node.isNew()) {
            PropertyIterator iterator = node.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String propertyName = property.getName();
                if (propertiesSet.get(propertyName) != null || !mapping.importPropertyFilter.accept(propertyName)) continue;
                try {
                    node.setProperty(propertyName, (Value)null);
                }
                catch (ValueFormatException vfex) {
                    node.setProperty(propertyName, (Value[])null);
                }
            }
            for (Resource child : resource.getChildren()) {
                Node childNode;
                String childName = child.getName();
                if (childrenSet.contains(childName) || !mapping.resourceFilter.accept(child) || (childNode = (Node)child.adaptTo(Node.class)) == null) continue;
                childNode.remove();
            }
        }
        return resource;
    }

    public static Resource createResource(ResourceResolver resolver, String path, Map<String, JsonProperty> propertiesSet, ValueFactory factory, MappingRules mapping) throws RepositoryException {
        JsonProperty primaryType = propertiesSet.get("jcr:primaryType");
        Resource resource = ResourceUtil.getOrCreateResource(resolver, path, primaryType != null ? (String)primaryType.value : null);
        if (resource != null) {
            JsonProperty mixinTypes = propertiesSet.get("jcr:mixinTypes");
            if (mixinTypes != null && !JsonUtil.importJsonProperty(factory, resource, mixinTypes, mapping)) {
                propertiesSet.remove("jcr:mixinTypes");
            }
            for (Map.Entry<String, JsonProperty> entry : propertiesSet.entrySet()) {
                JsonProperty property = entry.getValue();
                if ("jcr:primaryType".equals(property.name) || "jcr:mixinTypes".equals(property.name) || JsonUtil.importJsonProperty(factory, resource, property, mapping)) continue;
                entry.setValue(null);
            }
        }
        return resource;
    }

    public static JsonProperty parseJsonProperty(JsonReader reader, String name) throws IOException {
        JsonToken token = reader.peek();
        JsonProperty property = new JsonProperty();
        property.name = name;
        switch (token) {
            case BOOLEAN: {
                property.type = PropertyType.nameFromValue((int)6);
                property.value = reader.nextBoolean();
                break;
            }
            case NUMBER: {
                property.type = PropertyType.nameFromValue((int)3);
                property.value = reader.nextLong();
                break;
            }
            case STRING: {
                JsonUtil.parseJsonString(reader, property);
                break;
            }
            case NULL: {
                reader.nextNull();
            }
        }
        return property;
    }

    public static String parseJsonString(JsonReader reader, JsonProperty property) throws IOException {
        String string;
        Matcher matcher;
        if (property.type == null) {
            property.type = PropertyType.nameFromValue((int)1);
        }
        if ((matcher = MappingRules.TYPED_PROPERTY_STRING.matcher(string = reader.nextString())).matches()) {
            try {
                property.type = PropertyType.nameFromValue((int)PropertyType.valueFromName((String)matcher.group(1)));
                string = matcher.group(2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        property.value = string;
        return string;
    }

    public static boolean importJsonProperty(ValueFactory factory, Resource resource, JsonProperty property, MappingRules mapping) throws RepositoryException {
        Node node;
        if (resource != null && (node = (Node)resource.adaptTo(Node.class)) != null && (mapping.changeRule != MappingRules.ChangeRule.extend || node.getProperty(property.name) == null) && mapping.importPropertyFilter.accept(property.name)) {
            try {
                JsonUtil.setJsonProperty(node, property, mapping);
                return true;
            }
            catch (ConstraintViolationException cvex) {
                LOG.info(cvex.toString() + " (" + node.getPath() + "@" + property.name + ")");
            }
        }
        return false;
    }

    public static void writeJsonProperties(@Nonnull Resource resource, @Nonnull JsonWriter writer, @Nonnull StringFilter filter, @Nullable Node node, @Nonnull MappingRules mapping) throws RepositoryException, IOException {
        if (node != null) {
            TreeMap<String, Property> sortedProperties = new TreeMap<String, Property>();
            PropertyIterator iterator = node.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String name = property.getName();
                if (!filter.accept(name)) continue;
                sortedProperties.put(name, property);
            }
            if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
                writer.beginObject();
            } else {
                writer.beginArray();
            }
            for (Map.Entry entry : sortedProperties.entrySet()) {
                JsonUtil.writeJsonProperty(resource, writer, (Property)entry.getValue(), mapping);
            }
            if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
                writer.endObject();
            } else {
                writer.endArray();
            }
        }
    }

    public static void writeJsonValueMap(@Nonnull Resource resource, @Nonnull JsonWriter writer, @Nonnull StringFilter filter, @Nullable ValueMap values, @Nonnull MappingRules mapping) throws RepositoryException, IOException {
        if (values != null) {
            TreeMap sortedProperties = new TreeMap();
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                if (!filter.accept(key)) continue;
                sortedProperties.put(key, entry.getValue());
            }
            if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
                writer.beginObject();
            } else {
                writer.beginArray();
            }
            for (Map.Entry entry : sortedProperties.entrySet()) {
                JsonUtil.writeJsonProperty(resource, writer, (String)entry.getKey(), entry.getValue(), mapping);
            }
            if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
                writer.endObject();
            } else {
                writer.endArray();
            }
        }
    }

    public static void writeJsonProperty(@Nonnull Resource resource, @Nonnull JsonWriter writer, @Nullable Property property, @Nonnull MappingRules mapping) throws RepositoryException, IOException {
        if (property != null && (2 != property.getType() || mapping.propertyFormat.binary != MappingRules.PropertyFormat.Binary.skip)) {
            StringBuilder valueString;
            String name = property.getName();
            int type = property.getType();
            if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
                writer.name(name);
            } else {
                writer.beginObject();
                writer.name("name").value(name);
                writer.name("value");
            }
            StringBuilder stringBuilder = valueString = 1 == type ? new StringBuilder() : null;
            if (property.isMultiple()) {
                writer.beginArray();
                for (Value value : property.getValues()) {
                    JsonUtil.writeJsonValue(resource, writer, name, value, type, mapping);
                    if (valueString == null) continue;
                    if (valueString.length() > 0) {
                        valueString.append(',');
                    }
                    valueString.append(value.getString());
                }
                writer.endArray();
            } else {
                Value value = property.getValue();
                JsonUtil.writeJsonValue(resource, writer, name, value, type, mapping);
                if (valueString != null) {
                    valueString.append(value.getString());
                }
            }
            if (mapping.propertyFormat.scope != MappingRules.PropertyFormat.Scope.value) {
                writer.name("type").value(PropertyType.nameFromValue((int)type));
                writer.name("multi").value(property.isMultiple());
                if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.definition) {
                    PropertyDefinition definition = property.getDefinition();
                    writer.name("auto").value(definition.isAutoCreated());
                    writer.name("protected").value(definition.isProtected());
                    if (valueString != null) {
                        writer.name("subtype").value(PropertyUtil.getStringSubtype(valueString.toString()).name());
                    }
                }
                if (!property.isMultiple()) {
                    String target = null;
                    switch (type) {
                        case 1: 
                        case 8: 
                        case 9: 
                        case 10: {
                            target = JsonUtil.getValueTarget(resource, name, property.getString());
                        }
                    }
                    if (StringUtils.isNotBlank(target)) {
                        writer.name("target").value(target);
                    }
                }
                writer.endObject();
            }
        }
    }

    public static void writeJsonProperty(@Nonnull Resource resource, @Nonnull JsonWriter writer, @Nullable String name, @Nullable Object value, @Nonnull MappingRules mapping) throws RepositoryException, IOException {
        if (name != null && value != null) {
            int type = 1;
            if (value instanceof Boolean) {
                type = 6;
            } else if (value instanceof Long || value instanceof Integer) {
                type = 3;
            } else if (value instanceof Double || value instanceof Float) {
                type = 4;
            } else if (value instanceof BigDecimal) {
                type = 12;
            } else if (value instanceof Calendar) {
                type = 5;
            } else if (value instanceof InputStream) {
                type = 2;
            }
            if (mapping.propertyFormat.scope != MappingRules.PropertyFormat.Scope.value) {
                writer.beginObject();
            }
            if (mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
                writer.name(name);
            } else {
                writer.name("name").value(name);
                writer.name("value");
            }
            boolean isMultiple = value instanceof Object[];
            if (isMultiple) {
                writer.beginArray();
                for (Object val : (Object[])value) {
                    JsonUtil.writeJsonValue(resource, writer, name, val, type, mapping);
                }
                writer.endArray();
            } else {
                JsonUtil.writeJsonValue(resource, writer, name, value, type, mapping);
            }
            if (mapping.propertyFormat.scope != MappingRules.PropertyFormat.Scope.value) {
                String target;
                writer.name("type").value(PropertyType.nameFromValue((int)type));
                writer.name("multi").value(isMultiple);
                if (!isMultiple && type == 1 && StringUtils.isNotBlank((CharSequence)(target = JsonUtil.getValueTarget(resource, name, value.toString())))) {
                    writer.name("target").value(target);
                }
                writer.endObject();
            }
        }
    }

    public static String getValueTarget(@Nullable Resource resource, @Nullable String name, @Nullable String value) {
        if (resource != null && StringUtils.isNotBlank((CharSequence)value)) {
            Resource target;
            ResourceResolver resolver = resource.getResourceResolver();
            if (value.startsWith("/") && (target = resolver.getResource(value)) != null) {
                return target.getPath();
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                switch (name) {
                    case "sling:resourceType": 
                    case "sling:resourceSuperType": {
                        if (value.startsWith("/")) break;
                        for (String root : resolver.getSearchPath()) {
                            target = resolver.getResource(root + value);
                            if (target == null) continue;
                            return target.getPath();
                        }
                        break;
                    }
                    case "jcr:uuid": {
                        break;
                    }
                    default: {
                        Session session = (Session)resolver.adaptTo(Session.class);
                        if (session == null) break;
                        try {
                            Node node = session.getNodeByIdentifier(value);
                            return node.getPath();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }

    public static void writeJsonValue(@Nonnull Resource resource, @Nonnull JsonWriter writer, @Nonnull String name, @Nonnull Object value, @Nonnull Integer type, @Nonnull MappingRules mapping) throws RepositoryException, IOException {
        Value jcrValue = value instanceof Value ? (Value)value : null;
        switch (type) {
            case 2: {
                if (mapping.propertyFormat.binary == MappingRules.PropertyFormat.Binary.link) {
                    String uri = "/bin/cpm/nodes/property.bin" + LinkUtil.encodePath(resource.getPath()) + "?name=" + UrlCodec.QUERYPART.encode(name);
                    boolean htmlSafe = writer.isHtmlSafe();
                    writer.setHtmlSafe(false);
                    writer.value(uri);
                    writer.setHtmlSafe(htmlSafe);
                    break;
                }
                if (mapping.propertyFormat.binary == MappingRules.PropertyFormat.Binary.base64) {
                    byte[] buffer = null;
                    if (jcrValue != null) {
                        Binary binary = jcrValue.getBinary();
                        buffer = IOUtils.toByteArray((InputStream)binary.getStream());
                    } else if (value instanceof InputStream) {
                        buffer = IOUtils.toByteArray((InputStream)((InputStream)value));
                    }
                    String encoded = Base64.encodeBase64String((byte[])(buffer != null ? buffer : new byte[]{}));
                    writer.value(JsonUtil.getValueString(encoded, type, mapping));
                    break;
                }
                writer.nullValue();
                break;
            }
            case 6: {
                writer.value(jcrValue != null ? jcrValue.getBoolean() : (value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString())));
                break;
            }
            case 5: {
                Calendar cal;
                Calendar calendar = jcrValue != null ? jcrValue.getDate() : (cal = value instanceof Calendar ? (Calendar)value : null);
                if (cal == null) break;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateFormat.setTimeZone(cal.getTimeZone());
                writer.value(JsonUtil.getValueString(dateFormat.format(cal.getTime()), type, mapping));
                break;
            }
            case 12: {
                writer.value(JsonUtil.getValueString(jcrValue != null ? jcrValue.getDecimal() : (value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString())), type, mapping));
                break;
            }
            case 4: {
                writer.value(JsonUtil.getValueString(jcrValue != null ? jcrValue.getDouble() : (value instanceof Double ? (Double)value : Double.valueOf(value.toString())).doubleValue(), type, mapping));
                break;
            }
            case 3: {
                writer.value(jcrValue != null ? jcrValue.getLong() : (value instanceof Long ? (Long)value : Long.valueOf(value.toString())).longValue());
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                writer.value(JsonUtil.getValueString(jcrValue != null ? jcrValue.getString() : value.toString(), type, mapping));
                break;
            }
            case 0: {
                writer.nullValue();
            }
        }
    }

    public static void writeValue(JsonWriter writer, String name, String value) throws IOException {
        writer.name(name).value(value);
    }

    public static void writeValue(JsonWriter writer, String name, boolean value) throws IOException {
        writer.name(name).value(value);
    }

    public static void writeValue(JsonWriter writer, String name, double value) throws IOException {
        writer.name(name).value(value);
    }

    public static void writeValue(JsonWriter writer, String name, long value) throws IOException {
        writer.name(name).value(value);
    }

    public static void writeValue(JsonWriter writer, String name, Number value) throws IOException {
        writer.name(name).value(value);
    }

    public static String getValueString(Object value, int type, MappingRules mapping) {
        String string = value.toString();
        if (type != 1 && mapping.propertyFormat.embedType && mapping.propertyFormat.scope == MappingRules.PropertyFormat.Scope.value) {
            string = "{" + PropertyType.nameFromValue((int)type) + "}" + string;
        }
        return string;
    }

    public static void writeJsonArray(JsonWriter writer, String[] values) throws IOException {
        if (values != null) {
            writer.beginArray();
            for (String value : values) {
                writer.value(value);
            }
            writer.endArray();
        }
    }

    public static void writeJsonArray(JsonWriter writer, Iterator<String> values) throws IOException {
        if (values != null) {
            writer.beginArray();
            while (values.hasNext()) {
                writer.value(values.next());
            }
            writer.endArray();
        }
    }

    public static <T> void writeJsonArray(JsonWriter writer, Iterator<T> values, ElementCallback<T> elementCallback) throws IOException {
        if (values != null) {
            writer.beginArray();
            while (values.hasNext()) {
                try {
                    String extractedValue = elementCallback.doWithElement(values.next());
                    writer.value(extractedValue);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            writer.endArray();
        }
    }

    public static <T> void writeJsonArray(JsonWriter writer, String name, Iterator<T> values, ElementCallback<T> elementCallback) throws IOException {
        writer.name(name);
        JsonUtil.writeJsonArray(writer, values, elementCallback);
    }

    public static boolean setJsonProperty(Node node, JsonProperty property, MappingRules mapping) throws RepositoryException {
        if (property != null) {
            Value value;
            int type = StringUtils.isNotBlank((CharSequence)property.type) ? PropertyType.valueFromName((String)property.type) : 1;
            String name = property.name;
            String oldname = property.oldname;
            if (!StringUtils.isBlank((CharSequence)oldname) && !name.equals(oldname) && node.hasProperty(name)) {
                throw new RepositoryException("property '" + name + "' already exists");
            }
            if (property.multi || property.value instanceof Object[]) {
                Object[] jsonValues;
                Object[] objectArray = jsonValues = property.value instanceof Object[] ? (Object[])property.value : null;
                if (jsonValues == null) {
                    if (property.value instanceof List) {
                        List list = (List)property.value;
                        jsonValues = list.toArray(new Object[0]);
                    } else {
                        jsonValues = property.value != null ? property.value.toString().split("\\s*,\\s*") : new String[]{};
                    }
                }
                Value[] values = new Value[jsonValues.length];
                try {
                    for (int i = 0; i < jsonValues.length; ++i) {
                        values[i] = JsonUtil.makeJcrValue(node, type, jsonValues[i], mapping);
                    }
                }
                catch (PropertyValueFormatException pfex) {
                    return false;
                }
                Property jcrProperty = null;
                try {
                    jcrProperty = PropertyUtil.setProperty(node, name, values, type);
                }
                catch (ValueFormatException vfex) {
                    node.setProperty(name, (Value)null);
                    PropertyUtil.setProperty(node, name, values, type);
                }
                if (!StringUtils.isBlank((CharSequence)oldname) && !name.equals(oldname)) {
                    node.setProperty(oldname, (Value)null);
                }
                return jcrProperty != null;
            }
            String stringValue = property.value instanceof List ? StringUtils.join((Iterable)((List)property.value), (char)',') : (property.value != null ? property.value.toString() : null);
            try {
                value = JsonUtil.makeJcrValue(node, type, stringValue, mapping);
            }
            catch (PropertyValueFormatException pfex) {
                return false;
            }
            Property jcrProperty = null;
            try {
                jcrProperty = PropertyUtil.setProperty(node, name, value, type);
            }
            catch (ValueFormatException vfex) {
                node.setProperty(name, (Value[])null);
                PropertyUtil.setProperty(node, name, value, type);
            }
            if (!StringUtils.isBlank((CharSequence)oldname) && !name.equals(oldname)) {
                node.setProperty(oldname, (Value)null);
            }
            return jcrProperty != null;
        }
        return false;
    }

    public static Value makeJcrValue(Node node, int type, Object object, MappingRules mapping) throws PropertyValueFormatException, RepositoryException {
        Session session = node.getSession();
        ValueFactory factory = session.getValueFactory();
        Value value = null;
        if (object != null) {
            switch (type) {
                case 2: {
                    if (mapping.propertyFormat.binary == MappingRules.PropertyFormat.Binary.skip) break;
                    InputStream input = null;
                    if (object instanceof InputStream) {
                        input = (InputStream)object;
                    } else if (object instanceof String && mapping.propertyFormat.binary == MappingRules.PropertyFormat.Binary.base64) {
                        byte[] decoded = Base64.decodeBase64((String)((String)object));
                        input = new ByteArrayInputStream(decoded);
                    }
                    if (input == null) break;
                    Binary binary = factory.createBinary(input);
                    value = factory.createValue(binary);
                    break;
                }
                case 6: {
                    value = factory.createValue(object instanceof Boolean ? (Boolean)object : Boolean.parseBoolean(object.toString()));
                    break;
                }
                case 5: {
                    Date date;
                    Date date2 = date = object instanceof Date ? (Date)object : null;
                    if (date == null) {
                        String string = object.toString();
                        date = mapping.dateParser.parse(string);
                    }
                    if (date != null) {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(date);
                        value = factory.createValue((Calendar)cal);
                        break;
                    }
                    throw new PropertyValueFormatException("invalid date/time value: " + object);
                }
                case 12: {
                    value = factory.createValue(object instanceof BigDecimal ? (BigDecimal)object : new BigDecimal(object.toString()));
                    break;
                }
                case 4: {
                    value = factory.createValue(object instanceof Double ? (Double)object : Double.parseDouble(object.toString()));
                    break;
                }
                case 3: {
                    value = factory.createValue(object instanceof Long ? (Long)object : Long.parseLong(object.toString()));
                    break;
                }
                case 9: 
                case 10: {
                    Node refNode = session.getNodeByIdentifier(object.toString());
                    String identifier = refNode.getIdentifier();
                    value = factory.createValue(identifier, type);
                    break;
                }
                case 1: 
                case 7: 
                case 8: 
                case 11: {
                    value = factory.createValue(object.toString(), type);
                    break;
                }
            }
        }
        return value;
    }

    public static Object makeValueObject(int type, Object value) {
        MappingRules mapping = MappingRules.getDefaultMappingRules();
        Object object = null;
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object[] multi = new Object[collection.size()];
                Iterator it = collection.iterator();
                for (int i = 0; i < collection.size(); ++i) {
                    multi[i] = JsonUtil.makeValueObject(type, it.next());
                }
                object = multi;
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                Object[] multi = new Object[array.length];
                for (int i = 0; i < array.length; ++i) {
                    multi[i] = JsonUtil.makeValueObject(type, array[i]);
                }
                object = multi;
            } else {
                switch (type) {
                    case 2: {
                        if (value instanceof InputStream) {
                            object = value;
                            break;
                        }
                        if (!(value instanceof String)) break;
                        byte[] decoded = Base64.decodeBase64((String)value.toString());
                        object = new ByteArrayInputStream(decoded);
                        break;
                    }
                    case 6: {
                        object = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
                        break;
                    }
                    case 5: {
                        Date date;
                        Date date2 = date = value instanceof Date ? (Date)value : null;
                        if (date == null) {
                            date = mapping.dateParser.parse(value.toString());
                        }
                        if (date != null) {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(date);
                            object = cal;
                            break;
                        }
                        throw new IllegalArgumentException("invalid date/time value: " + value);
                    }
                    case 12: {
                        object = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                        break;
                    }
                    case 4: {
                        object = value instanceof Double ? (Double)value : Double.parseDouble(value.toString());
                        break;
                    }
                    case 3: {
                        object = value instanceof Long ? (Long)value : Long.parseLong(value.toString());
                        break;
                    }
                    case 1: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        object = value.toString();
                        break;
                    }
                }
            }
        }
        return object;
    }

    public static interface ElementCallback<T> {
        public String doWithElement(T var1) throws Exception;
    }

    public static class JsonProperty {
        public String name;
        public String oldname;
        public Object value;
        public String type = PropertyType.nameFromValue((int)1);
        public boolean multi = false;
    }
}

