/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NodeUtil.class);
    public static final String JCR_TITLE = "jcr:title";
    public static final String FORBIDDEN_NAME_CHARS = "/";

    public String getId(Node node) {
        String id = null;
        try {
            id = node.getIdentifier();
        }
        catch (RepositoryException e) {
            id = node.toString();
        }
        return id;
    }

    public static String getTitle(Node node) {
        String title = NodeUtil.getNodeTitle(node);
        if (StringUtils.isBlank((CharSequence)title)) {
            try {
                title = node.getName();
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return title;
    }

    public static String getNodeTitle(Node node) {
        String result = null;
        try {
            Property title = node.getProperty(JCR_TITLE);
            if (title != null) {
                result = title.getString();
            }
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
        return result;
    }

    public static String mangleNodeName(String name) {
        if (name != null && name.length() > 0) {
            StringBuilder builder = new StringBuilder();
            int length = name.length();
            char c = name.charAt(0);
            if (c >= '0' && c <= '9') {
                builder.append('_');
            }
            for (int i = 0; i < length; ++i) {
                c = name.charAt(i);
                if (c > ' ' && FORBIDDEN_NAME_CHARS.indexOf(c) < 0) {
                    builder.append(c);
                    continue;
                }
                builder.append('_');
            }
            name = builder.toString();
            name = StringEscapeUtils.escapeEcmaScript((String)name);
        }
        return name;
    }

    public static boolean isNodeType(Node node, String ... nodeType) throws RepositoryException {
        for (String type : nodeType) {
            if (!node.isNodeType(type)) continue;
            return true;
        }
        return false;
    }
}

