/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.SetPropertyStrategy;
import com.composum.sling.core.util.XSS;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang3.StringEscapeUtils;

public class PropertyUtil {
    public static final String FORBIDDEN_NAME_CHARS = "/";
    public static final String PROP_PRIMARY_TYPE = "jcr:primaryType";
    public static final String PROP_MIXIN_TYPES = "jcr:mixinTypes";
    public static final SetPropertyStrategy DEFAULT_PROPERTY_STRATEGY = new SetPropertyStrategy.Property();
    public static final Map<String, SetPropertyStrategy> SET_PROPERTY_STRATEGY_MAP = new HashMap<String, SetPropertyStrategy>();
    protected static final Map<Integer, Class> DEFAULT_PROPERTY_TYPES;

    public static StringSubtype getStringSubtype(String value) {
        return value.contains("</") ? (PropertyUtil.xssCheck(value) ? StringSubtype.richtext : StringSubtype.plaintext) : (value.contains("\n") ? StringSubtype.plaintext : StringSubtype.string);
    }

    public static boolean xssCheck(String value) {
        return value == null || value.replaceAll("\"", "&quot;").equals(XSS.filter(value));
    }

    public static <T> Class<T> getType(T defaultValue) {
        Class type = defaultValue != null ? defaultValue.getClass() : String.class;
        return type;
    }

    public static String getProperty(Node node, String name, String defaultValue) throws RepositoryException {
        String value = null;
        if (node.hasProperty(name)) {
            Property property = node.getProperty(name);
            value = property.getString();
        }
        return value != null ? value : defaultValue;
    }

    public static Boolean getProperty(Node node, String name, Boolean defaultValue) throws RepositoryException {
        Boolean value = null;
        if (node.hasProperty(name)) {
            Property property = node.getProperty(name);
            value = property.getBoolean();
        }
        return value != null ? value : defaultValue;
    }

    public static Long getProperty(Node node, String name, Long defaultValue) throws RepositoryException {
        Long value = null;
        if (node.hasProperty(name)) {
            Property property = node.getProperty(name);
            value = property.getLong();
        }
        return value != null ? value : defaultValue;
    }

    public static Calendar getProperty(Node node, String name, Calendar defaultValue) throws RepositoryException {
        Calendar value = null;
        if (node.hasProperty(name)) {
            Property property = node.getProperty(name);
            value = property.getDate();
        }
        return value != null ? value : defaultValue;
    }

    public static BigDecimal getProperty(Node node, String name, BigDecimal defaultValue) throws RepositoryException {
        BigDecimal value = null;
        if (node.hasProperty(name)) {
            Property property = node.getProperty(name);
            value = property.getDecimal();
        }
        return value != null ? value : defaultValue;
    }

    public static Double getProperty(Node node, String name, Double defaultValue) throws RepositoryException {
        Double value = null;
        if (node.hasProperty(name)) {
            Property property = node.getProperty(name);
            value = property.getDouble();
        }
        return value != null ? value : defaultValue;
    }

    public static String manglePropertyName(String name) {
        if (name != null && name.length() > 0) {
            StringBuilder builder = new StringBuilder();
            int length = name.length();
            char c = name.charAt(0);
            if (c >= '0' && c <= '9') {
                builder.append('_');
            }
            for (int i = 0; i < length; ++i) {
                c = name.charAt(i);
                if (c > ' ' && FORBIDDEN_NAME_CHARS.indexOf(c) < 0) {
                    builder.append(c);
                    continue;
                }
                builder.append('_');
            }
            name = builder.toString();
            name = StringEscapeUtils.escapeEcmaScript((String)name);
        } else {
            name = "_";
        }
        return name;
    }

    public static Binary getBinaryData(Node node) {
        Binary result = null;
        if (node != null) {
            try {
                Property property = null;
                try {
                    property = node.getProperty("jcr:data");
                    result = property.getBinary();
                }
                catch (PathNotFoundException pnfex) {
                    Node contentNode = node.getNode("jcr:content");
                    property = contentNode.getProperty("jcr:data");
                    result = property.getBinary();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return result;
    }

    public static SetPropertyStrategy getSetPropertyStrategy(String name) {
        SetPropertyStrategy strategy = SET_PROPERTY_STRATEGY_MAP.get(name);
        return strategy != null ? strategy : DEFAULT_PROPERTY_STRATEGY;
    }

    public static Property setProperty(Node node, String name, Value value, int type) throws RepositoryException {
        return PropertyUtil.getSetPropertyStrategy(name).setProperty(node, name, value, type);
    }

    public static Property setProperty(Node node, String name, Value[] values, int type) throws RepositoryException {
        return PropertyUtil.getSetPropertyStrategy(name).setProperty(node, name, values, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Property setProperty(Node node, String name, InputStream input) throws RepositoryException {
        Property property = null;
        if (input != null) {
            Session session = node.getSession();
            ValueFactory valueFactory = session.getValueFactory();
            Binary binary = valueFactory.createBinary(input);
            try {
                property = node.setProperty(name, valueFactory.createValue(binary));
            }
            finally {
                binary.dispose();
            }
        }
        return property;
    }

    public static Property setProperty(Node node, String name, Iterable<?> values, int type) throws RepositoryException {
        Session session = node.getSession();
        ValueFactory factory = session.getValueFactory();
        ArrayList<Value> valueList = new ArrayList<Value>();
        for (Object value : values) {
            Value jcrValue = PropertyUtil.createValue(factory, value, type);
            if (jcrValue == null) continue;
            valueList.add(jcrValue);
        }
        Value[] valueArray = valueList.toArray(new Value[valueList.size()]);
        return PropertyUtil.setProperty(node, name, valueArray, type);
    }

    public static Property setProperty(Node node, String name, Object value, int type) throws RepositoryException {
        Session session = node.getSession();
        ValueFactory factory = session.getValueFactory();
        return PropertyUtil.setProperty(node, name, PropertyUtil.createValue(factory, value, type), type);
    }

    public static Value createValue(ValueFactory factory, Object value, int type) throws ValueFormatException {
        Value jcrValue = null;
        if (value != null) {
            switch (type) {
                case 6: {
                    jcrValue = factory.createValue(((Boolean)value).booleanValue());
                    break;
                }
                case 5: {
                    jcrValue = factory.createValue((Calendar)value);
                    break;
                }
                case 12: {
                    jcrValue = factory.createValue((BigDecimal)value);
                    break;
                }
                case 4: {
                    jcrValue = factory.createValue(((Double)value).doubleValue());
                    break;
                }
                case 3: {
                    jcrValue = factory.createValue(((Long)value).longValue());
                    break;
                }
                default: {
                    jcrValue = factory.createValue((String)value, type);
                }
            }
        }
        return jcrValue;
    }

    public static <T> T readValue(Value value, Class<T> type) throws RepositoryException {
        try {
            if (null == value) {
                return null;
            }
            if (type.isAssignableFrom(value.getClass())) {
                return type.cast(value);
            }
            if (Long.class.equals(type)) {
                return type.cast(value.getLong());
            }
            if (Integer.class.equals(type)) {
                return type.cast(value.getLong());
            }
            if (Short.class.equals(type)) {
                return type.cast((short)value.getLong());
            }
            if (Byte.class.equals(type)) {
                return type.cast((byte)value.getLong());
            }
            if (Float.class.equals(type)) {
                return type.cast(Float.valueOf(value.getLong()));
            }
            if (Double.class.equals(type)) {
                return type.cast(value.getDouble());
            }
            if (String.class.equals(type)) {
                return type.cast(value.getString());
            }
            if (Boolean.class.equals(type)) {
                return type.cast(value.getBoolean());
            }
            if (URI.class.equals(type)) {
                return type.cast(new URI(value.getString()));
            }
            if (URL.class.equals(type)) {
                return type.cast(new URL(value.getString()));
            }
            if (Date.class.equals(type)) {
                return type.cast(value.getDate().getTime());
            }
            if (Calendar.class.equals(type)) {
                return type.cast(value.getDate());
            }
            if (BigDecimal.class.equals(type)) {
                return type.cast(value.getDecimal());
            }
            if (Binary.class.equals(type)) {
                return type.cast(value.getBinary());
            }
            if (InputStream.class.equals(type)) {
                return type.cast(value.getBinary().getStream());
            }
            Class defaultType = DEFAULT_PROPERTY_TYPES.get(value.getType());
            if (null != defaultType && type.isAssignableFrom(defaultType)) {
                return type.cast(PropertyUtil.readValue(value, defaultType));
            }
            throw new IllegalArgumentException("Type " + type + " not supported yet.");
        }
        catch (RuntimeException | MalformedURLException | URISyntaxException e) {
            throw new ValueFormatException("Can't convert to " + type, (Throwable)e);
        }
    }

    static {
        SET_PROPERTY_STRATEGY_MAP.put(PROP_PRIMARY_TYPE, new SetPropertyStrategy.PrimaryType());
        SET_PROPERTY_STRATEGY_MAP.put(PROP_MIXIN_TYPES, new SetPropertyStrategy.MixinTypes());
        DEFAULT_PROPERTY_TYPES = new HashMap<Integer, Class>(){
            {
                this.put(1, String.class);
                this.put(2, Binary.class);
                this.put(3, Long.class);
                this.put(4, Double.class);
                this.put(5, Calendar.class);
                this.put(6, Boolean.class);
                this.put(7, String.class);
                this.put(8, String.class);
                this.put(9, String.class);
                this.put(10, String.class);
                this.put(11, URI.class);
                this.put(12, BigDecimal.class);
            }
        };
    }

    static enum StringSubtype {
        string,
        plaintext,
        richtext;

    }
}

