/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.util.JsonUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

public class ResponseUtil {
    public static final String JSON_CONTENT_TYPE = "application/json;charset=" + MappingRules.CHARSET;

    public static String getMessage(Throwable ex) {
        StringBuilder builder = new StringBuilder();
        String msg = ex.getMessage();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            builder.append(msg);
        } else if (ex instanceof AccessDeniedException || ex instanceof IllegalAccessException || ex instanceof LoginException) {
            builder.append("access denied");
        } else {
            Throwable cause = ex.getCause();
            if (cause != null) {
                builder.append(ResponseUtil.getMessage(cause));
            } else {
                builder.append("server error");
            }
        }
        return builder.toString();
    }

    public static MappingRules getDefaultJsonMapping() {
        return new MappingRules(MappingRules.MAPPING_NODE_FILTER, MappingRules.MAPPING_EXPORT_FILTER, MappingRules.MAPPING_IMPORT_FILTER, new MappingRules.PropertyFormat(MappingRules.PropertyFormat.Scope.definition, MappingRules.PropertyFormat.Binary.link), 0, MappingRules.ChangeRule.update);
    }

    public static JsonWriter getJsonWriter(SlingHttpServletResponse response) throws IOException {
        response.setContentType(JSON_CONTENT_TYPE);
        response.setCharacterEncoding(MappingRules.CHARSET.name());
        PrintWriter writer = response.getWriter();
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setHtmlSafe(true);
        return jsonWriter;
    }

    public static void writeEmptyObject(SlingHttpServletResponse response) throws IOException {
        response.setStatus(200);
        try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);){
            jsonWriter.beginObject().endObject();
        }
    }

    public static void writeEmptyArray(SlingHttpServletResponse response) throws IOException {
        response.setStatus(200);
        try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);){
            jsonWriter.beginArray().endArray();
        }
    }

    public static void writeJsonProperty(@Nonnull Resource resource, @Nonnull SlingHttpServletResponse response, @Nonnull Node node, @Nonnull String name) throws RepositoryException, IOException {
        JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
        Property property = node.getProperty(name);
        if (property != null) {
            JsonUtil.writeJsonProperty(resource, jsonWriter, property, ResponseUtil.getDefaultJsonMapping());
        }
    }
}

