/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueEmbeddingReader
extends Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ValueEmbeddingReader.class);
    public static final String TYPE_RESOURCE = "resource";
    public static final char PATH_SEPARATOR = '/';
    public static final char MEMBER_SEPARATOR = '.';
    public static final char TYPE_SEPARATOR = ':';
    public static final char FORMAT_SEPARATOR = ';';
    public static final int BUFSIZE = 1024;
    protected final Reader reader;
    protected final ValueMap values;
    protected final Locale locale;
    protected final Class<?> resourceContext;
    protected boolean eof = false;
    protected char[] buf = new char[2048];
    protected int off = 0;
    protected int len = 0;
    private transient Reader embed;

    public ValueEmbeddingReader(@Nonnull Reader reader, @Nonnull Map<String, Object> values) {
        this(reader, (ValueMap)new ValueMapDecorator(values), null, null);
    }

    public ValueEmbeddingReader(@Nonnull Reader reader, @Nonnull Map<String, Object> values, @Nullable Locale locale, @Nullable Class<?> resourceContext) {
        this(reader, (ValueMap)new ValueMapDecorator(values), locale, resourceContext);
    }

    public ValueEmbeddingReader(@Nonnull Reader reader, @Nonnull ValueMap values) {
        this(reader, values, null, null);
    }

    public ValueEmbeddingReader(@Nonnull Reader reader, @Nonnull ValueMap values, @Nullable Locale locale, @Nullable Class<?> resourceContext) {
        this.reader = reader;
        this.values = values;
        this.locale = locale != null ? locale : Locale.getDefault();
        this.resourceContext = resourceContext != null ? resourceContext : values.getClass();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(@Nonnull char[] cbuf, int off, int len) throws IOException {
        if (this.embed != null) {
            if (this.len > 0) {
                return this.copy(cbuf, off, len);
            }
            int count = this.embed.read(cbuf, off, len);
            if (count >= 0) {
                return count;
            }
            this.embed.close();
            this.embed = null;
        }
        if (this.len < len && !this.eof) {
            this.load();
        }
        if (this.len < 1) {
            return -1;
        }
        return this.copy(cbuf, off, len);
    }

    protected int copy(@Nonnull char[] cbuf, int off, int len) {
        int count = Math.min(this.len, len);
        if (count > 0) {
            System.arraycopy(this.buf, this.off, cbuf, off, count);
            this.off += count;
            this.len -= count;
        }
        return count;
    }

    protected void load() throws IOException {
        if (this.off > 0) {
            System.arraycopy(this.buf, this.off, this.buf, 0, this.len);
            this.off = 0;
        }
        while (!this.eof && this.len < 1024) {
            int next;
            int token = this.reader.read();
            if (token < 0) {
                this.eof = true;
                continue;
            }
            if (token == 92) {
                next = this.reader.read();
                if (next < 0) {
                    this.buf[this.len++] = 92;
                    this.eof = true;
                    continue;
                }
                if (next != 92 && next != 36) {
                    this.buf[this.len++] = 92;
                }
                this.buf[this.len++] = (char)next;
                continue;
            }
            if (token == 36) {
                next = this.reader.read();
                if (next < 0) {
                    this.buf[this.len++] = 36;
                    this.eof = true;
                    continue;
                }
                if (next == 123) {
                    StringBuilder keyBuffer = new StringBuilder();
                    while (!this.eof && (next = this.reader.read()) != 125) {
                        if (next < 0) {
                            this.eof = true;
                            continue;
                        }
                        keyBuffer.append((char)next);
                    }
                    if (!this.eof) {
                        String string;
                        Key key = new Key(keyBuffer.toString().trim());
                        if (TYPE_RESOURCE.equals(key.type)) {
                            if (this.resourceContext == null) continue;
                            InputStream stream = this.resourceContext.getResourceAsStream(key.name);
                            if (stream != null) {
                                this.embed = new ValueEmbeddingReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), this.values);
                            } else {
                                LOG.warn("resource '{}' not available; probably invalid context ({})", (Object)key.name, (Object)this.resourceContext.getName());
                                this.embed = new StringReader("");
                            }
                            return;
                        }
                        Object value = this.values.get((Object)key.name);
                        if (value instanceof Reader) {
                            this.embed = new ValueEmbeddingReader((Reader)value, this.values);
                            return;
                        }
                        if (value == null) continue;
                        if (StringUtils.isNotBlank((CharSequence)key.format)) {
                            StringBuilder builder = new StringBuilder();
                            Formatter formatter = new Formatter(builder);
                            formatter.format(this.locale, key.format, value);
                            string = builder.toString();
                        } else {
                            string = value.toString();
                        }
                        string.getChars(0, string.length(), this.buf, this.len);
                        this.len += string.length();
                        continue;
                    }
                    this.buf[this.len++] = 36;
                    this.buf[this.len++] = 123;
                    keyBuffer.getChars(0, keyBuffer.length(), this.buf, this.len);
                    this.len += keyBuffer.length();
                    continue;
                }
                this.buf[this.len++] = 36;
                this.buf[this.len++] = (char)next;
                continue;
            }
            this.buf[this.len++] = (char)token;
        }
    }

    public static class Key {
        public String type = null;
        public final String name;
        public final String format;

        public Key(String key) {
            int formatSep;
            int memberSep;
            int pathSep;
            int typeSep = key.indexOf(58);
            if (!(typeSep <= 0 || (pathSep = key.indexOf(47)) >= 0 && pathSep <= typeSep || (memberSep = key.indexOf(46)) >= 0 && memberSep <= typeSep)) {
                this.type = key.substring(0, typeSep);
                key = key.substring(typeSep + 1);
            }
            if ((formatSep = key.indexOf(59)) > 0) {
                this.name = key.substring(0, formatSep);
                this.format = key.substring(formatSep + 1);
            } else {
                this.name = key;
                this.format = null;
            }
        }
    }
}

