/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.cpnl.CpnlElFunctions;
import com.composum.sling.cpnl.UrlTag;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;

public class FormTag
extends UrlTag {
    private String method;
    private String enctype;
    private String charset;

    @Override
    protected String getDefaultTagName() {
        return "form";
    }

    @Override
    protected String getDefaultUrlAttr() {
        return "action";
    }

    public void setAction(String action) {
        this.setUrl(action);
    }

    @Override
    protected void clear() {
        super.clear();
        this.enctype = null;
        this.method = null;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    @Nonnull
    protected String buildUrl(@Nonnull String urlValue, @Nullable Boolean map) {
        urlValue = map != null ? super.buildUrl(urlValue, map) : LinkUtil.getUrl(this.request, urlValue, "");
        return urlValue;
    }

    @Override
    protected void writeAttributes(JspWriter writer) throws IOException {
        super.writeAttributes(writer);
        if (StringUtils.isNotBlank((CharSequence)this.charset)) {
            writer.write(" accept-charset=\"");
            writer.write(CpnlElFunctions.text(this.charset));
            writer.write("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.enctype)) {
            writer.write(" enctype=\"");
            writer.write(CpnlElFunctions.text(this.enctype));
            writer.write("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.method)) {
            writer.write(" method=\"");
            writer.write(CpnlElFunctions.text(this.method.toUpperCase()));
            writer.write("\"");
        }
    }
}

