/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.util.LinkMapper;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.cpnl.CpnlElFunctions;
import com.composum.sling.cpnl.UrlTag;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;

public class ImageTag
extends UrlTag {
    protected String title;
    protected String alt;

    @Override
    protected void clear() {
        super.clear();
        this.alt = null;
        this.title = null;
    }

    @Override
    protected String getDefaultTagName() {
        return "img";
    }

    @Override
    protected String getDefaultUrlAttr() {
        return "src";
    }

    public void setSrc(String src) {
        this.setUrl(src);
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public void setAlt(String value) {
        this.alt = value;
    }

    @Override
    @Nonnull
    protected String buildUrl(@Nonnull String urlValue, @Nullable Boolean map) {
        urlValue = map != null ? LinkUtil.getUrl(this.request, urlValue, null, "", map != false ? LinkMapper.RESOLVER : LinkMapper.CONTEXT) : LinkUtil.getUrl(this.request, urlValue, "");
        return urlValue;
    }

    @Override
    protected void writeAttributes(JspWriter writer) throws IOException {
        super.writeAttributes(writer);
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            writer.write(" title=\"");
            writer.write(CpnlElFunctions.text(this.title));
            writer.write("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.alt)) {
            writer.write(" alt=\"");
            writer.write(CpnlElFunctions.text(this.alt));
            writer.write("\"");
        }
    }
}

