/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.protostellar.search.v1.NumericRangeQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreNumericRangeQuery
extends CoreSearchQuery {
    @Nullable
    private final Double min;
    @Nullable
    private final Double max;
    @Nullable
    private final Boolean inclusiveMin;
    @Nullable
    private final Boolean inclusiveMax;
    @Nullable
    private final String field;

    public CoreNumericRangeQuery(@Nullable Double min, @Nullable Double max, @Nullable Boolean inclusiveMin, @Nullable Boolean inclusiveMax, @Nullable String field, @Nullable Double boost) {
        super(boost);
        if (min == null && max == null) {
            throw new NullPointerException("NumericRangeQuery needs at least one of min or max");
        }
        this.min = min;
        this.max = max;
        this.inclusiveMin = inclusiveMin;
        this.inclusiveMax = inclusiveMax;
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        if (this.min != null) {
            input.put("min", this.min);
            if (this.inclusiveMin != null) {
                input.put("inclusive_min", this.inclusiveMin);
            }
        }
        if (this.max != null) {
            input.put("max", this.max);
            if (this.inclusiveMax != null) {
                input.put("inclusive_max", this.inclusiveMax);
            }
        }
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        NumericRangeQuery.Builder builder = NumericRangeQuery.newBuilder();
        if (this.min != null) {
            builder.setMin(this.min.floatValue());
            if (this.inclusiveMin != null) {
                builder.setInclusiveMin(this.inclusiveMin);
            }
        }
        if (this.max != null) {
            builder.setMax(this.max.floatValue());
            if (this.inclusiveMax != null) {
                builder.setInclusiveMax(this.inclusiveMax);
            }
        }
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setNumericRangeQuery(builder).build();
    }
}

