/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.events.transaction.TransactionEvent;
import com.couchbase.client.core.cnc.events.transaction.TransactionLogEvent;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.cleanup.CleanupRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Stability.Uncommitted
public class TransactionCleanupAttemptEvent
extends TransactionEvent {
    private final boolean success;
    private final boolean isRegular;
    private final List<TransactionLogEvent> logs;
    private final String attemptId;
    private final String atrId;
    private final CollectionIdentifier atrCollection;
    private final CleanupRequest req;
    private final String addlDebug;

    public TransactionCleanupAttemptEvent(Event.Severity severity, boolean success, boolean isRegular, List<TransactionLogEvent> logs, String attemptId, String atrId, CollectionIdentifier atrCollection, CleanupRequest req, String addlDebug) {
        super(Objects.requireNonNull(severity), "com.couchbase.transactions.cleanup");
        this.success = success;
        this.isRegular = isRegular;
        this.logs = new ArrayList<TransactionLogEvent>((Collection)Objects.requireNonNull(logs));
        this.attemptId = Objects.requireNonNull(attemptId);
        this.atrId = Objects.requireNonNull(atrId);
        this.atrCollection = Objects.requireNonNull(atrCollection);
        this.req = Objects.requireNonNull(req);
        this.addlDebug = Objects.requireNonNull(addlDebug);
    }

    public List<TransactionLogEvent> logs() {
        return this.logs;
    }

    public boolean success() {
        return this.success;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public String atrId() {
        return this.atrId;
    }

    @Deprecated
    public String atrBucket() {
        return null;
    }

    public CollectionIdentifier atrCollection() {
        return this.atrCollection;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction cleanup attempt ");
        sb.append(this.success ? "succeeded" : "failed");
        sb.append(", ");
        sb.append(this.addlDebug);
        sb.append("isRegular=");
        sb.append(this.isRegular);
        if (!this.success) {
            sb.append(", logs=[");
            for (int i = 0; i < this.logs.size(); ++i) {
                sb.append(this.logs.get(i).toString());
                if (i == this.logs.size() - 1) continue;
                sb.append("; ");
            }
            sb.append("]");
        } else {
            sb.append(", req=");
            sb.append(this.req);
        }
        return sb.toString();
    }
}

