/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.manager.ManagerHandlerSwitcher;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class ManagerEndpoint
extends BaseEndpoint {
    public ManagerEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().managerEventLoopGroup().get(), ctx, ctx.environment().ioConfig().managerCircuitBreakerConfig(), ServiceType.MANAGER, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new ManagerPipelineInitializer(this.context());
    }

    public static class ManagerPipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext endpointContext;

        public ManagerPipelineInitializer(EndpointContext endpointContext) {
            this.endpointContext = endpointContext;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(ManagerHandlerSwitcher.SWITCHER_IDENTIFIER, (ChannelHandler)new ManagerHandlerSwitcher(endpoint, this.endpointContext));
        }
    }
}

