/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.search.SearchHandlerSwitcher;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class SearchEndpoint
extends BaseEndpoint {
    public SearchEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().searchEventLoopGroup().get(), ctx, ctx.environment().ioConfig().searchCircuitBreakerConfig(), ServiceType.SEARCH, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new SearchPipelineInitializer(this.context());
    }

    public static class SearchPipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext endpointContext;

        SearchPipelineInitializer(EndpointContext endpointContext) {
            this.endpointContext = endpointContext;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(SearchHandlerSwitcher.SWITCHER_IDENTIFIER, (ChannelHandler)new SearchHandlerSwitcher(endpoint, this.endpointContext));
        }
    }
}

