/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CollectionIdentifier
implements Serializable {
    public static final String DEFAULT_SCOPE = "_default";
    public static final String DEFAULT_COLLECTION = "_default";
    private final String bucket;
    private final boolean isDefault;
    @Nullable
    private final String scope;
    @Nullable
    private final String collection;

    public static CollectionIdentifier fromDefault(String bucket) {
        return new CollectionIdentifier(bucket, Optional.of("_default"), Optional.of("_default"));
    }

    public CollectionIdentifier(String bucket, Optional<String> scope, Optional<String> collection) {
        Objects.requireNonNull(bucket);
        Objects.requireNonNull(scope);
        Objects.requireNonNull(collection);
        this.bucket = bucket;
        this.scope = scope.orElse(null);
        this.collection = collection.orElse(null);
        this.isDefault = Optional.of("_default").equals(scope) && Optional.of("_default").equals(collection);
    }

    public String bucket() {
        return this.bucket;
    }

    public Optional<String> scope() {
        return Optional.ofNullable(this.scope);
    }

    public Optional<String> collection() {
        return Optional.ofNullable(this.collection);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionIdentifier that = (CollectionIdentifier)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.scope, that.scope) && Objects.equals(this.collection, that.collection);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.scope, this.collection);
    }

    public String toString() {
        return "CollectionIdentifier{bucket='" + RedactableArgument.redactMeta(this.bucket) + '\'' + ", scope=" + RedactableArgument.redactMeta(this.scope) + ", collection=" + RedactableArgument.redactMeta(this.collection) + ", isDefault=" + RedactableArgument.redactMeta(this.isDefault) + '}';
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> exported = new HashMap<String, Object>();
        exported.put("bucket", RedactableArgument.redactMeta(this.bucket()));
        exported.put("scope", RedactableArgument.redactMeta(this.scope().orElse("_default")));
        exported.put("collection", RedactableArgument.redactMeta(this.collection().orElse("_default")));
        return exported;
    }
}

