/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.service.kv.Observe;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public final class CoreDurability {
    private static final Map<DurabilityLevel, CoreDurability> cached;
    public static final CoreDurability NONE;
    @Nullable
    private final DurabilityLevel durabilityLevel;
    @Nullable
    private final Observe.ObservePersistTo legacyPersistTo;
    @Nullable
    private final Observe.ObserveReplicateTo legacyReplicateTo;

    private CoreDurability(DurabilityLevel durabilityLevel) {
        this.durabilityLevel = Objects.requireNonNull(durabilityLevel);
        this.legacyPersistTo = null;
        this.legacyReplicateTo = null;
    }

    private CoreDurability(Observe.ObservePersistTo legacyPersistTo, Observe.ObserveReplicateTo legacyReplicateTo) {
        this.durabilityLevel = null;
        this.legacyPersistTo = Objects.requireNonNull(legacyPersistTo);
        this.legacyReplicateTo = Objects.requireNonNull(legacyReplicateTo);
    }

    public static CoreDurability of(DurabilityLevel level) {
        return cached.get((Object)level);
    }

    public static CoreDurability of(Observe.ObservePersistTo persistTo, Observe.ObserveReplicateTo replicateTo) {
        return replicateTo == Observe.ObserveReplicateTo.NONE && persistTo == Observe.ObservePersistTo.NONE ? CoreDurability.of(DurabilityLevel.NONE) : new CoreDurability(persistTo, replicateTo);
    }

    public boolean isNone() {
        return this.durabilityLevel == DurabilityLevel.NONE;
    }

    public boolean isLegacy() {
        return this.durabilityLevel == null;
    }

    public boolean isPersistent() {
        return this.durabilityLevel != null ? this.durabilityLevel == DurabilityLevel.PERSIST_TO_MAJORITY || this.durabilityLevel == DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE : this.legacyPersistTo != Observe.ObservePersistTo.NONE;
    }

    public Optional<DurabilityLevel> levelIfSynchronous() {
        return this.durabilityLevel == DurabilityLevel.NONE ? Optional.empty() : Optional.ofNullable(this.durabilityLevel);
    }

    @Nullable
    public Observe.ObservePersistTo legacyPersistTo() {
        return this.legacyPersistTo;
    }

    @Nullable
    public Observe.ObserveReplicateTo legacyReplicateTo() {
        return this.legacyReplicateTo;
    }

    public String toString() {
        if (this.durabilityLevel != null) {
            return this.durabilityLevel.toString();
        }
        return "LegacyDurability{persistTo=" + (Object)((Object)this.legacyPersistTo) + ", replicateTo=" + (Object)((Object)this.legacyReplicateTo) + '}';
    }

    static {
        EnumMap<DurabilityLevel, CoreDurability> map = new EnumMap<DurabilityLevel, CoreDurability>(DurabilityLevel.class);
        for (DurabilityLevel level : DurabilityLevel.values()) {
            map.put(level, new CoreDurability(level));
        }
        cached = Collections.unmodifiableMap(map);
        NONE = CoreDurability.of(DurabilityLevel.NONE);
    }
}

