/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.Query;
import com.couchbase.client.protostellar.search.v1.WildcardQuery;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreWildcardQuery
extends CoreSearchQuery {
    private final String wildcard;
    @Nullable
    private final String field;

    public CoreWildcardQuery(String wildcard, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.wildcard = Validators.notNull(wildcard, "Wildcard");
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        if (this.field != null) {
            input.put("field", this.field);
        }
        input.put("wildcard", this.wildcard);
    }

    @Override
    public Query asProtostellar() {
        WildcardQuery.Builder builder = WildcardQuery.newBuilder().setWildcard(this.wildcard);
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setWildcardQuery(builder).build();
    }
}

