/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class CollectionExistsException
extends CouchbaseException {
    private final String collectionName;

    @Stability.Internal
    public CollectionExistsException(String collectionName, @Nullable ErrorContext context) {
        super("Collection [" + RedactableArgument.redactMeta(collectionName) + "] already exists.", context);
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    public static CollectionExistsException forCollection(String collectionName) {
        return new CollectionExistsException(collectionName, null);
    }

    public String collectionName() {
        return this.collectionName;
    }
}

