/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class ScopeExistsException
extends CouchbaseException {
    private final String scopeName;

    @Stability.Internal
    public ScopeExistsException(String scopeName, @Nullable ErrorContext context) {
        super("Scope [" + RedactableArgument.redactMeta(scopeName) + "] already exists.", context);
        this.scopeName = Objects.requireNonNull(scopeName);
    }

    public static ScopeExistsException forScope(String scopeName) {
        return new ScopeExistsException(scopeName, null);
    }

    public String scopeName() {
        return this.scopeName;
    }
}

