/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.io.SaslMechanismsListedEvent;
import com.couchbase.client.core.cnc.events.io.SaslMechanismsListingFailedEvent;
import com.couchbase.client.core.cnc.events.io.UnknownSaslMechanismDetectedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.KeyValueIoErrorContext;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.kv.ChannelAttributes;
import com.couchbase.client.core.io.netty.kv.ConnectTimings;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

@Stability.Internal
public class SaslListMechanismsHandler
extends ChannelDuplexHandler {
    private final Duration timeout;
    private final EndpointContext endpointContext;
    private IoContext ioContext;
    private ChannelPromise interceptedConnectPromise;

    public SaslListMechanismsHandler(EndpointContext endpointContext) {
        this.endpointContext = endpointContext;
        this.timeout = endpointContext.environment().timeoutConfig().connectTimeout();
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        this.interceptedConnectPromise = promise;
        ChannelPromise downstream = ctx.newPromise();
        downstream.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (!f.isSuccess() && !this.interceptedConnectPromise.isDone()) {
                ConnectTimings.record(ctx.channel(), this.getClass());
                this.interceptedConnectPromise.tryFailure(f.cause());
            }
        }));
        ctx.connect(remoteAddress, localAddress, downstream);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        ctx.executor().schedule(() -> {
            if (!this.interceptedConnectPromise.isDone()) {
                ConnectTimings.stop(ctx.channel(), this.getClass(), true);
                this.interceptedConnectPromise.tryFailure(new TimeoutException("SASL Mechanism listing timed out after " + this.timeout.toMillis() + "ms"));
            }
        }, this.timeout.toNanos(), TimeUnit.NANOSECONDS);
        ConnectTimings.start(ctx.channel(), this.getClass());
        ctx.writeAndFlush(this.buildListMechanismsRequest(ctx));
        ctx.fireChannelActive();
    }

    private ByteBuf buildListMechanismsRequest(ChannelHandlerContext ctx) {
        return MemcacheProtocol.request(ctx.alloc(), MemcacheProtocol.Opcode.SASL_LIST_MECHS, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), BaseKeyValueRequest.nextOpaque(), MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), MemcacheProtocol.noBody());
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            Optional<Duration> latency = ConnectTimings.stop(ctx.channel(), this.getClass(), false);
            if (MemcacheProtocol.successful((ByteBuf)msg)) {
                boolean isEmpty;
                String[] rawMechanisms = MemcacheProtocol.bodyAsString((ByteBuf)msg).split(" ");
                boolean bl = isEmpty = rawMechanisms.length == 1 && rawMechanisms[0].isEmpty();
                if (rawMechanisms.length > 0 && !isEmpty) {
                    Set<SaslMechanism> serverMechanisms = this.decodeMechanisms(rawMechanisms);
                    this.ioContext.environment().eventBus().publish(new SaslMechanismsListedEvent(this.ioContext, serverMechanisms, latency.orElse(Duration.ZERO)));
                    ctx.channel().attr(ChannelAttributes.SASL_MECHS_KEY).set(serverMechanisms);
                    this.interceptedConnectPromise.trySuccess();
                    ctx.pipeline().remove(this);
                } else {
                    this.failConnection("Received empty mechanism list from server", MemcacheProtocol.status((ByteBuf)msg), latency);
                }
            } else {
                this.failConnection("Received non-success status from server", MemcacheProtocol.status((ByteBuf)msg), latency);
            }
        } else {
            this.interceptedConnectPromise.tryFailure(new CouchbaseException("Unexpected response type on channel read, this is a bug - please report. " + msg));
        }
        ReferenceCountUtil.release(msg);
    }

    private void failConnection(String message, short status, Optional<Duration> duration) {
        KeyValueIoErrorContext errorContext = new KeyValueIoErrorContext(MemcacheProtocol.decodeStatus(status), this.endpointContext, null);
        this.ioContext.environment().eventBus().publish(new SaslMechanismsListingFailedEvent(duration.orElse(Duration.ZERO), errorContext, message));
        this.interceptedConnectPromise.tryFailure(new AuthenticationFailureException(message, errorContext, null));
    }

    private Set<SaslMechanism> decodeMechanisms(String[] encoded) {
        return Arrays.stream(encoded).map(e -> {
            SaslMechanism mech = SaslMechanism.from(e);
            if (mech == null) {
                this.ioContext.environment().eventBus().publish(new UnknownSaslMechanismDetectedEvent(this.ioContext, (String)e));
            }
            return mech;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.interceptedConnectPromise.isDone()) {
            this.interceptedConnectPromise.tryFailure(cause);
        }
        ctx.fireExceptionCaught(cause);
    }
}

