/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

public enum CodecFlags {

    public static final int COMMON_FORMAT_MASK = 0xF000000;
    public static final int PRIVATE_COMMON_FLAGS = CodecFlags.createCommonFlags(CommonFlags.PRIVATE.ordinal());
    public static final int JSON_COMMON_FLAGS = CodecFlags.createCommonFlags(CommonFlags.JSON.ordinal());
    public static final int BINARY_COMMON_FLAGS = CodecFlags.createCommonFlags(CommonFlags.BINARY.ordinal());
    public static final int STRING_COMMON_FLAGS = CodecFlags.createCommonFlags(CommonFlags.STRING.ordinal());
    public static final int SERIALIZED_LEGACY_FLAGS = 1;
    public static final int BINARY_LEGACY_FLAGS = 2048;
    public static final int STRING_LEGACY_FLAGS = 0;
    public static final int JSON_LEGACY_FLAGS = 0;
    public static final int BOOLEAN_LEGACY_FLAGS = 0;
    public static final int LONG_LEGACY_FLAGS = 0;
    public static final int DOUBLE_LEGACY_FLAGS = 0;
    public static final int SERIALIZED_COMPAT_FLAGS = PRIVATE_COMMON_FLAGS | 1;
    public static final int JSON_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int BINARY_COMPAT_FLAGS = BINARY_COMMON_FLAGS | 0x800;
    public static final int BOOLEAN_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int LONG_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int DOUBLE_COMPAT_FLAGS = JSON_COMMON_FLAGS | 0;
    public static final int STRING_COMPAT_FLAGS = STRING_COMMON_FLAGS | 0;

    public static int createCommonFlags(int flags) {
        return flags << 24;
    }

    public static boolean hasCommonFlags(int flags) {
        return flags >> 24 > 0;
    }

    public static boolean hasCommonFormat(int flags, int expectedCommonFlag) {
        return CodecFlags.hasCommonFlags(flags) && (flags & 0xF000000) == expectedCommonFlag;
    }

    public static int extractCommonFlags(int flags) {
        return flags >> 24;
    }

    public static int extractCommonFormatFlags(int userFlags) {
        return CodecFlags.extractCommonFlags(userFlags) & 0xF;
    }

    public static boolean hasCompressionFlags(int flags) {
        return flags >> 29 > 0;
    }

    public static enum CommonFlags {
        RESERVED,
        PRIVATE,
        JSON,
        BINARY,
        STRING;

    }
}

