/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class CoreTransactionOptions {
    private final Optional<DurabilityLevel> durabilityLevel;
    private final Optional<String> scanConsistency;
    private final Optional<RequestSpan> parentSpan;
    private final Optional<Duration> timeout;
    private final Optional<TransactionAttemptContextFactory> attemptContextFactory;
    private final Optional<CollectionIdentifier> metadataCollection;

    public CoreTransactionOptions(Optional<DurabilityLevel> durabilityLevel, Optional<String> scanConsistency, Optional<RequestSpan> parentSpan, Optional<Duration> timeout, Optional<CollectionIdentifier> metadataCollection, Optional<TransactionAttemptContextFactory> attemptContextFactory) {
        this.timeout = Objects.requireNonNull(timeout);
        this.durabilityLevel = Objects.requireNonNull(durabilityLevel);
        this.scanConsistency = Objects.requireNonNull(scanConsistency);
        this.parentSpan = Objects.requireNonNull(parentSpan);
        this.attemptContextFactory = Objects.requireNonNull(attemptContextFactory);
        this.metadataCollection = Objects.requireNonNull(metadataCollection);
    }

    public static CoreTransactionOptions create(RequestSpan parentSpan) {
        return new CoreTransactionOptions(Optional.empty(), Optional.empty(), Optional.of(parentSpan), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Optional<DurabilityLevel> durabilityLevel() {
        return this.durabilityLevel;
    }

    public Optional<String> scanConsistency() {
        return this.scanConsistency;
    }

    public Optional<RequestSpan> parentSpan() {
        return this.parentSpan;
    }

    public Optional<Duration> timeout() {
        return this.timeout;
    }

    public Optional<TransactionAttemptContextFactory> attemptContextFactory() {
        return this.attemptContextFactory;
    }

    public Optional<CollectionIdentifier> metadataCollection() {
        return this.metadataCollection;
    }
}

