/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ClusterCleanupTask
implements Runnable {
    private final AtomicBoolean alreadyDisconnected;
    private final EventBus eventBus;
    private final Mono<Void> cleanupTask;
    private final Exception clusterCreationStackTrace = new Exception("A Couchbase `Cluster` object became unreachable (eligible for garbage collection) without first being disconnected. As a safeguard, it is being automatically disconnected now. Please correct this problem by calling `Cluster.disconnect()` or `Cluster.close()` when you are done with the Cluster object and all associated Buckets, Scopes, Collections, managers, etc. The stack trace points to the location where the leaked Cluster was created.");

    public ClusterCleanupTask(Mono<Void> cleanupTask, EventBus eventBus, AtomicBoolean alreadyDisconnected) {
        this.alreadyDisconnected = Objects.requireNonNull(alreadyDisconnected);
        this.cleanupTask = Objects.requireNonNull(cleanupTask);
        this.eventBus = eventBus;
    }

    @Override
    public void run() {
        if (this.alreadyDisconnected.get()) {
            return;
        }
        if (EventBus.PublishResult.SUCCESS != this.eventBus.publish(new ClusterLeakDetected(this.clusterCreationStackTrace))) {
            this.clusterCreationStackTrace.printStackTrace();
        }
        this.cleanupTask.block();
    }

    private static class ClusterLeakDetected
    extends AbstractEvent {
        private final Throwable cause;

        protected ClusterLeakDetected(Throwable cause) {
            super(Event.Severity.WARN, Event.Category.CORE, Duration.ZERO, null);
            this.cause = Objects.requireNonNull(cause);
        }

        @Override
        public String description() {
            return this.cause.getMessage();
        }

        @Override
        public Throwable cause() {
            return this.cause;
        }
    }
}

