/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class MatchQuery
extends SearchQuery {
    private static final int PREFIX_LENGTH = 0;
    private static final int FUZZINESS = 2;
    private final String match;
    private final String field;
    private final String analyzer;
    private final int prefixLength;
    private final int fuzziness;

    protected MatchQuery(Builder builder) {
        super(builder);
        this.match = builder.match;
        this.field = builder.field;
        this.analyzer = builder.analyzer;
        this.prefixLength = builder.prefixLength;
        this.fuzziness = builder.fuzziness;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public String match() {
        return this.match;
    }

    public String field() {
        return this.field;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public int fuzziness() {
        return this.fuzziness;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("match", this.match).put("field", this.field).put("analyzer", this.analyzer).put("prefix_length", this.prefixLength).put("fuzziness", this.fuzziness);
    }

    public static class Builder
    extends SearchQuery.Builder {
        private String match;
        private String field;
        private String analyzer;
        private int prefixLength = 0;
        private int fuzziness = 2;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public MatchQuery build() {
            return new MatchQuery(this);
        }

        public Builder match(String match) {
            this.match = match;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder fuzziness(int fuzziness) {
            this.fuzziness = fuzziness;
            return this;
        }

        public Builder prefixLength(int prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }
    }
}

