/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DmBigDecBinder
extends DmBinder {
    public DmBigDecBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 9;
        this.recPrec = 0;
        this.recScale = 0;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1 && dType != 11 && dType != 10) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = this.recScale;
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        ret = this.isDiffParamObjectType() && !(obj instanceof BigDecimal) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc) : DmBigDecBinder.toDbBytes((BigDecimal)obj, this.destDType, this.destPrec, this.destScale, serverEncoding);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(BigDecimal x, int destDType, int destPrec, int destScale, String serverEncoding) throws SQLException {
        byte[] ret = null;
        if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 9: {
                    ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                    break;
                }
                case 3: 
                case 13: {
                    boolean b_v = x.compareTo(new BigDecimal(0)) != 0;
                    ret = Convertion.booleanToByteArray(b_v);
                    break;
                }
                case 5: {
                    ret = Convertion.byteToByteArray(x.byteValue());
                    break;
                }
                case 6: {
                    ret = Convertion.shortToByteArray(x.shortValue());
                    break;
                }
                case 7: {
                    ret = Convertion.intToByteArray(x.intValue());
                    break;
                }
                case 8: {
                    ret = Convertion.longToByteArray(x.longValue());
                    break;
                }
                case 10: {
                    ret = Convertion.floatToByteArray(x.floatValue());
                    break;
                }
                case 11: {
                    ret = Convertion.doubleToByteArray(x.doubleValue());
                    break;
                }
                case 0: 
                case 1: {
                    ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                    break;
                }
                case 2: 
                case 19: {
                    ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return DmBigDecBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }
}

