/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbTimestamp;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class DmTimestampBinder
extends DmBinder {
    public DmTimestampBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 16;
        this.recPrec = 8;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        byte[] ret = null;
        ret = this.diffParamObjectType && !(obj instanceof Timestamp) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, this.serverEncoding, this.ltz, this.dbTz, this.paramsDesc[icol].getTypeDescriptor()) : DmTimestampBinder.toDbBytes((Timestamp)obj, this.destDType, this.destPrec, this.srcScale, this.serverEncoding, this.ltz, this.dbTz, this.defaultCalendar);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(Timestamp x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz, Calendar defaultCalendar) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                ret = DmdbTimestamp.encodeByDate(x, destDType, destScale, defaultCalendar, ltz, dbTz);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
                    DBError.throwSQLException(6007);
                }
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return DmTimestampBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }
}

