/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.DBError;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import javax.crypto.Cipher;
import sun.misc.BASE64Decoder;

public class RSACipher {
    private static final String ALGORITHM = "RSA";
    private Cipher publicCipher;

    public RSACipher(String file) throws SQLException {
        try {
            PublicKey publicKey = RSACipher.getPubKey(RSACipher.getKey(file));
            this.publicCipher = Cipher.getInstance(ALGORITHM);
            this.publicCipher.init(1, publicKey);
        }
        catch (Exception exception) {
            DBError.throwSQLException("Init public cipher error: ");
        }
    }

    public byte[] encrypt(byte[] byteSource, int offset, int len) throws SQLException {
        try {
            return this.publicCipher.doFinal(byteSource, offset, len);
        }
        catch (Exception exception) {
            DBError.throwSQLException("Cert Encrypt Error");
            return null;
        }
    }

    public static String getKey(String fileName) throws SQLException {
        StringBuilder key;
        block17: {
            key = new StringBuilder();
            BufferedReader ois = null;
            try {
                try {
                    ois = new BufferedReader(new FileReader(fileName));
                    String line = null;
                    boolean start = false;
                    while ((line = ois.readLine()) != null) {
                        if (line.startsWith("-")) {
                            if (!start) {
                                start = true;
                                continue;
                            }
                            if (!start) continue;
                            break;
                        }
                        if (!start) continue;
                        key.append(line);
                    }
                }
                catch (Exception exception) {
                    DBError.throwSQLException("Get key error: " + fileName);
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return key.toString();
    }

    public static PublicKey getPubKey(String key) throws Exception {
        X509EncodedKeySpec bobPubKeySpec = new X509EncodedKeySpec(new BASE64Decoder().decodeBuffer(key));
        return KeyFactory.getInstance(ALGORITHM).generatePublic(bobPubKeySpec);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(new BASE64Decoder().decodeBuffer(key));
        return KeyFactory.getInstance(ALGORITHM).generatePrivate(priPKCS8);
    }

    public static void main(String[] args) throws Exception {
        PublicKey key = RSACipher.getPubKey(RSACipher.getKey("d:\\Users\\zhaokan\\Desktop\\dm_login.pubkey"));
        System.out.println(key);
    }
}

