/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.processor.BaseFlusher;
import dm.jdbc.util.StringUtil;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogWriter
extends BaseFlusher {
    protected static LinkedBlockingQueue<byte[]> flushQueue = new LinkedBlockingQueue();

    private LogWriter() {
        super("LogFlusher", DmSvcConf.logDir, "dm_jdbc", DmSvcConf.logFlushFreq);
        this.start();
    }

    public static LogWriter getInstance() {
        return LoggerHolder.instance;
    }

    @Override
    protected void doRun() {
        byte[] ibytes = null;
        while (this.flushFreq > 0) {
            try {
                ibytes = flushQueue.poll(DmSvcConf.logFlushFreq, TimeUnit.SECONDS);
                if (ibytes != null) {
                    this.buffer.addBytes(ibytes, 0, ibytes.length);
                }
                if ((ibytes != null || this.buffer.length() <= 0) && this.buffer.length() < 32768) continue;
                this.doFlush(this.buffer);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void beforeExit() throws Exception {
        byte[] ibytes = null;
        while ((ibytes = flushQueue.poll()) != null) {
            this.buffer.addBytes(ibytes, 0, ibytes.length);
            if (this.buffer.length() < DmSvcConf.logBufferSize) continue;
            this.doFlush(this.buffer);
        }
        if (this.buffer.length() > 0) {
            this.doFlush(this.buffer);
        }
    }

    public synchronized void write(String msg) {
        try {
            byte[] bytes = msg.getBytes();
            flushQueue.put(bytes);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void writeLine(String msg) {
        try {
            byte[] bytes = (String.valueOf(StringUtil.trimToEmpty(msg)) + StringUtil.LINE_SEPARATOR).getBytes();
            flushQueue.put(bytes);
        }
        catch (Exception exception) {}
    }

    public synchronized void writeLines(List<String> msgs) {
        if (msgs == null || msgs.size() == 0) {
            return;
        }
        for (String msg : msgs) {
            this.writeLine(msg);
        }
    }

    /* synthetic */ LogWriter(LogWriter logWriter) {
        this();
    }

    private static class LoggerHolder {
        private static final LogWriter instance = new LogWriter(null);

        private LoggerHolder() {
        }
    }
}

